/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.components.crypto;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.x500.X500Principal;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.CryptoBase;
import org.apache.ws.security.components.crypto.CryptoType;

public class CertificateStore
extends CryptoBase {
    protected X509Certificate[] trustedCerts;

    public CertificateStore(X509Certificate[] trustedCerts) {
        this.trustedCerts = trustedCerts;
    }

    public X509Certificate[] getX509Certificates(CryptoType cryptoType) throws WSSecurityException {
        if (cryptoType == null) {
            return null;
        }
        CryptoType.TYPE type = cryptoType.getType();
        X509Certificate[] certs = null;
        switch (type) {
            case ISSUER_SERIAL: {
                certs = this.getX509Certificates(cryptoType.getIssuer(), cryptoType.getSerial());
                break;
            }
            case THUMBPRINT_SHA1: {
                certs = this.getX509Certificates(cryptoType.getBytes());
                break;
            }
            case SKI_BYTES: {
                certs = this.getX509CertificatesSKI(cryptoType.getBytes());
                break;
            }
            case ALIAS: 
            case SUBJECT_DN: {
                certs = this.getX509CertificatesSubjectDN(cryptoType.getSubjectDN());
            }
        }
        return certs;
    }

    public String getX509Identifier(X509Certificate cert) throws WSSecurityException {
        return cert.getSubjectDN().toString();
    }

    public PrivateKey getPrivateKey(X509Certificate certificate, CallbackHandler callbackHandler) throws WSSecurityException {
        return null;
    }

    public PrivateKey getPrivateKey(String identifier, String password) throws WSSecurityException {
        return null;
    }

    @Deprecated
    public boolean verifyTrust(X509Certificate[] certs) throws WSSecurityException {
        return this.verifyTrust(certs, false);
    }

    public boolean verifyTrust(X509Certificate[] certs, boolean enableRevocation) throws WSSecurityException {
        try {
            List<X509Certificate> certList = Arrays.asList(certs);
            CertPath path = this.getCertificateFactory().generateCertPath(certList);
            HashSet<TrustAnchor> set = new HashSet<TrustAnchor>();
            if (this.trustedCerts != null) {
                for (X509Certificate cert : this.trustedCerts) {
                    TrustAnchor anchor = new TrustAnchor(cert, cert.getExtensionValue("2.5.29.30"));
                    set.add(anchor);
                }
            }
            PKIXParameters param = new PKIXParameters(set);
            param.setRevocationEnabled(enableRevocation);
            String provider = this.getCryptoProvider();
            CertPathValidator validator = null;
            validator = provider == null || provider.length() == 0 ? CertPathValidator.getInstance("PKIX") : CertPathValidator.getInstance("PKIX", provider);
            validator.validate(path, param);
            return true;
        }
        catch (NoSuchProviderException e) {
            throw new WSSecurityException(0, "certpath", new Object[]{e.getMessage()}, e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new WSSecurityException(0, "certpath", new Object[]{e.getMessage()}, e);
        }
        catch (CertificateException e) {
            throw new WSSecurityException(0, "certpath", new Object[]{e.getMessage()}, e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new WSSecurityException(0, "certpath", new Object[]{e.getMessage()}, e);
        }
        catch (CertPathValidatorException e) {
            throw new WSSecurityException(0, "certpath", new Object[]{e.getMessage()}, e);
        }
    }

    public boolean verifyTrust(PublicKey publicKey) throws WSSecurityException {
        if (publicKey == null) {
            return false;
        }
        for (X509Certificate trustedCert : this.trustedCerts) {
            if (!publicKey.equals(trustedCert.getPublicKey())) continue;
            return true;
        }
        return false;
    }

    private X509Certificate[] getX509Certificates(String issuer, BigInteger serialNumber) throws WSSecurityException {
        Object issuerName = null;
        try {
            X500Principal issuerRDN = new X500Principal(issuer);
            issuerName = this.createBCX509Name(issuerRDN.getName());
        }
        catch (IllegalArgumentException ex) {
            issuerName = this.createBCX509Name(issuer);
        }
        for (X509Certificate trustedCert : this.trustedCerts) {
            Object certName;
            if (trustedCert.getSerialNumber().compareTo(serialNumber) != 0 || !(certName = this.createBCX509Name(trustedCert.getIssuerX500Principal().getName())).equals(issuerName)) continue;
            return new X509Certificate[]{trustedCert};
        }
        return null;
    }

    private X509Certificate[] getX509Certificates(byte[] thumb) throws WSSecurityException {
        MessageDigest sha = null;
        if (this.trustedCerts == null) {
            return null;
        }
        try {
            sha = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new WSSecurityException(0, "noSHA1availabe", null, e);
        }
        for (X509Certificate trustedCert : this.trustedCerts) {
            try {
                sha.update(trustedCert.getEncoded());
            }
            catch (CertificateEncodingException ex) {
                throw new WSSecurityException(7, "encodeError", null, ex);
            }
            byte[] data = sha.digest();
            if (!Arrays.equals(data, thumb)) continue;
            return new X509Certificate[]{trustedCert};
        }
        return null;
    }

    private X509Certificate[] getX509CertificatesSKI(byte[] skiBytes) throws WSSecurityException {
        if (this.trustedCerts == null) {
            return null;
        }
        for (X509Certificate trustedCert : this.trustedCerts) {
            byte[] data = this.getSKIBytesFromCert(trustedCert);
            if (data.length != skiBytes.length || !Arrays.equals(data, skiBytes)) continue;
            return new X509Certificate[]{trustedCert};
        }
        return null;
    }

    private X509Certificate[] getX509CertificatesSubjectDN(String subjectDN) throws WSSecurityException {
        Object subject;
        try {
            X500Principal subjectRDN = new X500Principal(subjectDN);
            subject = this.createBCX509Name(subjectRDN.getName());
        }
        catch (IllegalArgumentException ex) {
            subject = this.createBCX509Name(subjectDN);
        }
        if (this.trustedCerts != null) {
            for (X509Certificate trustedCert : this.trustedCerts) {
                X500Principal foundRDN = trustedCert.getSubjectX500Principal();
                Object certName = this.createBCX509Name(foundRDN.getName());
                if (!subject.equals(certName)) continue;
                return new X509Certificate[]{trustedCert};
            }
        }
        return null;
    }
}

