/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.PathMap;
import org.eclipse.jetty.server.AsyncContinuation;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class ContextHandlerCollection
extends HandlerCollection {
    private static final Logger LOG = Log.getLogger(ContextHandlerCollection.class);
    private volatile PathMap _contextMap;
    private Class<? extends ContextHandler> _contextClass = ContextHandler.class;

    public ContextHandlerCollection() {
        super(true);
    }

    public void mapContexts() {
        PathMap contextMap = new PathMap();
        Handler[] branches = this.getHandlers();
        for (int b = 0; branches != null && b < branches.length; ++b) {
            Handler[] handlers = null;
            if (branches[b] instanceof ContextHandler) {
                handlers = new Handler[]{branches[b]};
            } else {
                if (!(branches[b] instanceof HandlerContainer)) continue;
                handlers = ((HandlerContainer)((Object)branches[b])).getChildHandlersByClass(ContextHandler.class);
            }
            for (int i = 0; i < handlers.length; ++i) {
                HashMap<String, Object> hosts;
                ContextHandler handler = (ContextHandler)handlers[i];
                String contextPath = handler.getContextPath();
                if (contextPath == null || contextPath.indexOf(44) >= 0 || contextPath.startsWith("*")) {
                    throw new IllegalArgumentException("Illegal context spec:" + contextPath);
                }
                if (!contextPath.startsWith("/")) {
                    contextPath = '/' + contextPath;
                }
                if (contextPath.length() > 1) {
                    if (contextPath.endsWith("/")) {
                        contextPath = contextPath + "*";
                    } else if (!contextPath.endsWith("/*")) {
                        contextPath = contextPath + "/*";
                    }
                }
                Object contexts = contextMap.get((Object)contextPath);
                String[] vhosts = handler.getVirtualHosts();
                if (vhosts != null && vhosts.length > 0) {
                    if (contexts instanceof Map) {
                        hosts = (Map)contexts;
                    } else {
                        hosts = new HashMap<String, Object>();
                        hosts.put("*", contexts);
                        contextMap.put((Object)contextPath, hosts);
                    }
                    for (int j = 0; j < vhosts.length; ++j) {
                        String vhost = vhosts[j];
                        contexts = hosts.get(vhost);
                        contexts = LazyList.add((Object)contexts, (Object)branches[b]);
                        hosts.put(vhost, contexts);
                    }
                    continue;
                }
                if (contexts instanceof Map) {
                    hosts = (HashMap<String, Object>)contexts;
                    contexts = hosts.get("*");
                    contexts = LazyList.add((Object)contexts, (Object)branches[b]);
                    hosts.put("*", contexts);
                    continue;
                }
                contexts = LazyList.add((Object)contexts, (Object)branches[b]);
                contextMap.put((Object)contextPath, contexts);
            }
        }
        this._contextMap = contextMap;
    }

    @Override
    public void setHandlers(Handler[] handlers) {
        this._contextMap = null;
        super.setHandlers(handlers);
        if (this.isStarted()) {
            this.mapContexts();
        }
    }

    @Override
    protected void doStart() throws Exception {
        this.mapContexts();
        super.doStart();
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ContextHandler context;
        Handler[] handlers = this.getHandlers();
        if (handlers == null || handlers.length == 0) {
            return;
        }
        AsyncContinuation async = baseRequest.getAsyncContinuation();
        if (async.isAsync() && (context = async.getContextHandler()) != null) {
            context.handle(target, baseRequest, request, response);
            return;
        }
        PathMap map = this._contextMap;
        if (map != null && target != null && target.startsWith("/")) {
            Object contexts = map.getLazyMatches(target);
            for (int i = 0; i < LazyList.size((Object)contexts); ++i) {
                Map.Entry entry = (Map.Entry)LazyList.get((Object)contexts, (int)i);
                Object list = entry.getValue();
                if (list instanceof Map) {
                    Handler handler;
                    int j;
                    Map hosts = (Map)list;
                    String host = this.normalizeHostname(request.getServerName());
                    list = hosts.get(host);
                    for (j = 0; j < LazyList.size(list); ++j) {
                        handler = (Handler)LazyList.get(list, (int)j);
                        handler.handle(target, baseRequest, request, response);
                        if (!baseRequest.isHandled()) continue;
                        return;
                    }
                    list = hosts.get("*." + host.substring(host.indexOf(".") + 1));
                    for (j = 0; j < LazyList.size(list); ++j) {
                        handler = (Handler)LazyList.get(list, (int)j);
                        handler.handle(target, baseRequest, request, response);
                        if (!baseRequest.isHandled()) continue;
                        return;
                    }
                    list = hosts.get("*");
                    for (j = 0; j < LazyList.size(list); ++j) {
                        handler = (Handler)LazyList.get(list, (int)j);
                        handler.handle(target, baseRequest, request, response);
                        if (!baseRequest.isHandled()) continue;
                        return;
                    }
                    continue;
                }
                for (int j = 0; j < LazyList.size(list); ++j) {
                    Handler handler = (Handler)LazyList.get(list, (int)j);
                    handler.handle(target, baseRequest, request, response);
                    if (!baseRequest.isHandled()) continue;
                    return;
                }
            }
        } else {
            for (int i = 0; i < handlers.length; ++i) {
                handlers[i].handle(target, baseRequest, request, response);
                if (!baseRequest.isHandled()) continue;
                return;
            }
        }
    }

    public ContextHandler addContext(String contextPath, String resourceBase) {
        try {
            ContextHandler context = this._contextClass.newInstance();
            context.setContextPath(contextPath);
            context.setResourceBase(resourceBase);
            this.addHandler(context);
            return context;
        }
        catch (Exception e) {
            LOG.debug((Throwable)e);
            throw new Error(e);
        }
    }

    public Class getContextClass() {
        return this._contextClass;
    }

    public void setContextClass(Class contextClass) {
        if (contextClass == null || !ContextHandler.class.isAssignableFrom(contextClass)) {
            throw new IllegalArgumentException();
        }
        this._contextClass = contextClass;
    }

    private String normalizeHostname(String host) {
        if (host == null) {
            return null;
        }
        if (host.endsWith(".")) {
            return host.substring(0, host.length() - 1);
        }
        return host;
    }
}

