/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler.gzip;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.zip.Deflater;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http.pathmap.PathSpecSet;
import org.eclipse.jetty.server.HttpOutput;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.handler.gzip.GzipFactory;
import org.eclipse.jetty.server.handler.gzip.GzipHttpOutputInterceptor;
import org.eclipse.jetty.util.IncludeExclude;
import org.eclipse.jetty.util.RegexSet;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class GzipHandler
extends HandlerWrapper
implements GzipFactory {
    private static final Logger LOG = Log.getLogger(GzipHandler.class);
    public static final String GZIP = "gzip";
    public static final String DEFLATE = "deflate";
    public static final int DEFAULT_MIN_GZIP_SIZE = 16;
    private int _minGzipSize = 16;
    private int _compressionLevel = -1;
    private boolean _checkGzExists = true;
    private boolean _syncFlush = false;
    private final ThreadLocal<Deflater> _deflater = new ThreadLocal();
    private final IncludeExclude<String> _agentPatterns = new IncludeExclude(RegexSet.class);
    private final IncludeExclude<String> _methods = new IncludeExclude();
    private final IncludeExclude<String> _paths = new IncludeExclude(PathSpecSet.class);
    private final IncludeExclude<String> _mimeTypes = new IncludeExclude();
    private HttpField _vary;

    public GzipHandler() {
        this._methods.include((Object)HttpMethod.GET.asString());
        for (String type : MimeTypes.getKnownMimeTypes()) {
            if ("image/svg+xml".equals(type)) {
                this._paths.exclude((Object)"*.svgz");
                continue;
            }
            if (!type.startsWith("image/") && !type.startsWith("audio/") && !type.startsWith("video/")) continue;
            this._mimeTypes.exclude((Object)type);
        }
        this._mimeTypes.exclude((Object)"application/compress");
        this._mimeTypes.exclude((Object)"application/zip");
        this._mimeTypes.exclude((Object)"application/gzip");
        this._mimeTypes.exclude((Object)"application/bzip2");
        this._mimeTypes.exclude((Object)"application/x-rar-compressed");
        LOG.debug("{} mime types {}", new Object[]{this, this._mimeTypes});
        this._agentPatterns.exclude((Object)".*MSIE 6.0.*");
    }

    public void addExcludedAgentPatterns(String ... patterns) {
        this._agentPatterns.exclude((Object[])patterns);
    }

    public void addExcludedMethods(String ... methods) {
        for (String m : methods) {
            this._methods.exclude((Object)m);
        }
    }

    public void addExcludedMimeTypes(String ... types) {
        for (String t : types) {
            this._mimeTypes.exclude((Object[])StringUtil.csvSplit((String)t));
        }
    }

    public void addExcludedPaths(String ... pathspecs) {
        for (String p : pathspecs) {
            this._paths.exclude((Object[])StringUtil.csvSplit((String)p));
        }
    }

    public void addIncludedAgentPatterns(String ... patterns) {
        this._agentPatterns.include((Object[])patterns);
    }

    public void addIncludedMethods(String ... methods) {
        for (String m : methods) {
            this._methods.include((Object)m);
        }
    }

    public boolean isSyncFlush() {
        return this._syncFlush;
    }

    public void setSyncFlush(boolean syncFlush) {
        this._syncFlush = syncFlush;
    }

    public void addIncludedMimeTypes(String ... types) {
        for (String t : types) {
            this._mimeTypes.include((Object[])StringUtil.csvSplit((String)t));
        }
    }

    public void addIncludedPaths(String ... pathspecs) {
        for (String p : pathspecs) {
            this._paths.include((Object[])StringUtil.csvSplit((String)p));
        }
    }

    @Override
    protected void doStart() throws Exception {
        this._vary = this._agentPatterns.size() > 0 ? GzipHttpOutputInterceptor.VARY_ACCEPT_ENCODING_USER_AGENT : GzipHttpOutputInterceptor.VARY_ACCEPT_ENCODING;
        super.doStart();
    }

    public boolean getCheckGzExists() {
        return this._checkGzExists;
    }

    public int getCompressionLevel() {
        return this._compressionLevel;
    }

    @Override
    public Deflater getDeflater(Request request, long content_length) {
        Deflater df;
        String ua = request.getHttpFields().get(HttpHeader.USER_AGENT);
        if (ua != null && !this.isAgentGzipable(ua)) {
            LOG.debug("{} excluded user agent {}", new Object[]{this, request});
            return null;
        }
        if (content_length >= 0L && content_length < (long)this._minGzipSize) {
            LOG.debug("{} excluded minGzipSize {}", new Object[]{this, request});
            return null;
        }
        if (request.getHttpVersion() != HttpVersion.HTTP_2) {
            HttpField accept = request.getHttpFields().getField(HttpHeader.ACCEPT_ENCODING);
            if (accept == null) {
                LOG.debug("{} excluded !accept {}", new Object[]{this, request});
                return null;
            }
            boolean gzip = accept.contains(GZIP);
            if (!gzip) {
                LOG.debug("{} excluded not gzip accept {}", new Object[]{this, request});
                return null;
            }
        }
        if ((df = this._deflater.get()) == null) {
            df = new Deflater(this._compressionLevel, true);
        } else {
            this._deflater.set(null);
        }
        return df;
    }

    public String[] getExcludedAgentPatterns() {
        Set excluded = this._agentPatterns.getExcluded();
        return excluded.toArray(new String[excluded.size()]);
    }

    public String[] getExcludedMethods() {
        Set excluded = this._methods.getExcluded();
        return excluded.toArray(new String[excluded.size()]);
    }

    public String[] getExcludedMimeTypes() {
        Set excluded = this._mimeTypes.getExcluded();
        return excluded.toArray(new String[excluded.size()]);
    }

    public String[] getExcludedPaths() {
        Set excluded = this._paths.getExcluded();
        return excluded.toArray(new String[excluded.size()]);
    }

    public String[] getIncludedAgentPatterns() {
        Set includes = this._agentPatterns.getIncluded();
        return includes.toArray(new String[includes.size()]);
    }

    public String[] getIncludedMethods() {
        Set includes = this._methods.getIncluded();
        return includes.toArray(new String[includes.size()]);
    }

    public String[] getIncludedMimeTypes() {
        Set includes = this._mimeTypes.getIncluded();
        return includes.toArray(new String[includes.size()]);
    }

    public String[] getIncludedPaths() {
        Set includes = this._paths.getIncluded();
        return includes.toArray(new String[includes.size()]);
    }

    @Deprecated
    public String[] getMethods() {
        return this.getIncludedMethods();
    }

    public int getMinGzipSize() {
        return this._minGzipSize;
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        int i;
        File gz;
        String realpath;
        String mimeType;
        ServletContext context = baseRequest.getServletContext();
        String path = context == null ? baseRequest.getRequestURI() : URIUtil.addPaths((String)baseRequest.getServletPath(), (String)baseRequest.getPathInfo());
        LOG.debug("{} handle {} in {}", new Object[]{this, baseRequest, context});
        HttpOutput out = baseRequest.getResponse().getHttpOutput();
        for (HttpOutput.Interceptor interceptor = out.getInterceptor(); interceptor != null; interceptor = interceptor.getNextInterceptor()) {
            if (!(interceptor instanceof GzipHttpOutputInterceptor)) continue;
            LOG.debug("{} already intercepting {}", new Object[]{this, request});
            this._handler.handle(target, baseRequest, request, response);
            return;
        }
        if (!this._methods.matches((Object)baseRequest.getMethod())) {
            LOG.debug("{} excluded by method {}", new Object[]{this, request});
            this._handler.handle(target, baseRequest, request, response);
            return;
        }
        if (!this.isPathGzipable(path)) {
            LOG.debug("{} excluded by path {}", new Object[]{this, request});
            this._handler.handle(target, baseRequest, request, response);
            return;
        }
        String string = mimeType = context == null ? null : context.getMimeType(path);
        if (mimeType != null && !this.isMimeTypeGzipable(mimeType = MimeTypes.getContentTypeWithoutCharset((String)mimeType))) {
            LOG.debug("{} excluded by path suffix mime type {}", new Object[]{this, request});
            this._handler.handle(target, baseRequest, request, response);
            return;
        }
        if (this._checkGzExists && context != null && (realpath = request.getServletContext().getRealPath(path)) != null && (gz = new File(realpath + ".gz")).exists()) {
            LOG.debug("{} gzip exists {}", new Object[]{this, request});
            this._handler.handle(target, baseRequest, request, response);
            return;
        }
        String etag = baseRequest.getHttpFields().get(HttpHeader.IF_NONE_MATCH);
        if (etag != null && (i = etag.indexOf("--gzip\"")) > 0) {
            while (i >= 0) {
                etag = etag.substring(0, i) + etag.substring(i + "--gzip".length());
                i = etag.indexOf("--gzip\"", i);
            }
            baseRequest.getHttpFields().put(new HttpField(HttpHeader.IF_NONE_MATCH, etag));
        }
        out.setInterceptor(new GzipHttpOutputInterceptor(this, this._vary, baseRequest.getHttpChannel(), out.getInterceptor(), this._syncFlush));
        if (this._handler != null) {
            this._handler.handle(target, baseRequest, request, response);
        }
    }

    protected boolean isAgentGzipable(String ua) {
        if (ua == null) {
            return false;
        }
        return this._agentPatterns.matches((Object)ua);
    }

    @Override
    public boolean isMimeTypeGzipable(String mimetype) {
        return this._mimeTypes.matches((Object)mimetype);
    }

    protected boolean isPathGzipable(String requestURI) {
        if (requestURI == null) {
            return true;
        }
        return this._paths.matches((Object)requestURI);
    }

    @Override
    public void recycle(Deflater deflater) {
        deflater.reset();
        if (this._deflater.get() == null) {
            this._deflater.set(deflater);
        }
    }

    public void setCheckGzExists(boolean checkGzExists) {
        this._checkGzExists = checkGzExists;
    }

    public void setCompressionLevel(int compressionLevel) {
        this._compressionLevel = compressionLevel;
    }

    public void setExcludedAgentPatterns(String ... patterns) {
        this._agentPatterns.getExcluded().clear();
        this.addExcludedAgentPatterns(patterns);
    }

    public void setExcludedMethods(String ... method) {
        this._methods.getExcluded().clear();
        this._methods.exclude((Object[])method);
    }

    public void setExcludedMimeTypes(String ... types) {
        this._mimeTypes.getExcluded().clear();
        this._mimeTypes.exclude((Object[])types);
    }

    public void setExcludedPaths(String ... pathspecs) {
        this._paths.getExcluded().clear();
        this._paths.exclude((Object[])pathspecs);
    }

    public void setIncludedAgentPatterns(String ... patterns) {
        this._agentPatterns.getIncluded().clear();
        this.addIncludedAgentPatterns(patterns);
    }

    public void setIncludedMethods(String ... methods) {
        this._methods.getIncluded().clear();
        this._methods.include((Object[])methods);
    }

    public void setIncludedMimeTypes(String ... types) {
        this._mimeTypes.getIncluded().clear();
        this._mimeTypes.include((Object[])types);
    }

    public void setIncludedPaths(String ... pathspecs) {
        this._paths.getIncluded().clear();
        this._paths.include((Object[])pathspecs);
    }

    public void setMinGzipSize(int minGzipSize) {
        this._minGzipSize = minGzipSize;
    }
}

