/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jaxb;

import jakarta.xml.bind.ValidationEventHandler;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.Callable;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.core.helper.CoreClassConstants;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.jaxb.IDResolver;
import org.xml.sax.SAXException;

public class IDResolverWrapper
extends IDResolver {
    private static final String BIND_METHOD_NAME = "bind";
    private static final String END_DOCUMENT_METHOD_NAME = "endDocument";
    private static final String RESOLVE_METHOD_NAME = "resolve";
    private static final String START_DOCUMENT_METHOD_NAME = "startDocument";
    private static final Class<?>[] BIND_PARAMS = new Class[]{CoreClassConstants.STRING, CoreClassConstants.OBJECT};
    private static final Class<?>[] RESOLVE_PARAMS = new Class[]{CoreClassConstants.STRING, CoreClassConstants.CLASS};
    private static final Class<?>[] START_DOCUMENT_PARAMS = new Class[]{ValidationEventHandler.class};
    private Object resolver;
    private Method bindMethod;
    private Method endDocumentMethod;
    private Method resolveMethod;
    private Method startDocumentMethod;

    public IDResolverWrapper(Object sunResolver) {
        this.resolver = sunResolver;
        Class<?> resolverClass = sunResolver.getClass();
        try {
            this.bindMethod = PrivilegedAccessHelper.getMethod(resolverClass, BIND_METHOD_NAME, BIND_PARAMS, false);
        }
        catch (Exception ex) {
            throw XMLMarshalException.errorProcessingIDResolver(BIND_METHOD_NAME, sunResolver, ex);
        }
        try {
            this.endDocumentMethod = PrivilegedAccessHelper.getMethod(resolverClass, END_DOCUMENT_METHOD_NAME, new Class[0], false);
        }
        catch (Exception ex) {
            throw XMLMarshalException.errorProcessingIDResolver(END_DOCUMENT_METHOD_NAME, sunResolver, ex);
        }
        try {
            this.resolveMethod = PrivilegedAccessHelper.getMethod(resolverClass, RESOLVE_METHOD_NAME, RESOLVE_PARAMS, false);
        }
        catch (Exception ex) {
            throw XMLMarshalException.errorProcessingIDResolver(RESOLVE_METHOD_NAME, sunResolver, ex);
        }
        try {
            this.startDocumentMethod = PrivilegedAccessHelper.getMethod(resolverClass, START_DOCUMENT_METHOD_NAME, START_DOCUMENT_PARAMS, false);
        }
        catch (Exception ex) {
            throw XMLMarshalException.errorProcessingIDResolver(START_DOCUMENT_METHOD_NAME, sunResolver, ex);
        }
    }

    @Override
    public void bind(Object id, Object obj) throws SAXException {
        try {
            Object[] params = new Object[]{id.toString(), obj};
            PrivilegedAccessHelper.invokeMethod(this.bindMethod, this.resolver, params);
        }
        catch (Exception ex) {
            throw XMLMarshalException.errorInvokingIDResolver(BIND_METHOD_NAME, this.resolver, ex);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            PrivilegedAccessHelper.invokeMethod(this.endDocumentMethod, this.resolver, new Object[0]);
        }
        catch (Exception ex) {
            throw XMLMarshalException.errorInvokingIDResolver(END_DOCUMENT_METHOD_NAME, this.resolver, ex);
        }
    }

    @Override
    public void startDocument(ValidationEventHandler eventHandler) throws SAXException {
        try {
            Object[] params = new Object[]{eventHandler};
            PrivilegedAccessHelper.invokeMethod(this.startDocumentMethod, this.resolver, params);
        }
        catch (Exception ex) {
            throw XMLMarshalException.errorInvokingIDResolver(START_DOCUMENT_METHOD_NAME, this.resolver, ex);
        }
    }

    @Override
    public Callable<?> resolve(Object id, Class<?> targetType) throws SAXException {
        try {
            Object[] params = new Object[]{id.toString(), targetType};
            return (Callable)PrivilegedAccessHelper.invokeMethod(this.resolveMethod, this.resolver, params);
        }
        catch (Exception ex) {
            throw XMLMarshalException.errorInvokingIDResolver(RESOLVE_METHOD_NAME, this.resolver, ex);
        }
    }

    @Override
    public Callable<?> resolve(Map<String, Object> id, Class<?> type) throws SAXException {
        throw XMLMarshalException.wrappedIDResolverWithMultiID(id.toString(), this.resolver);
    }

    @Override
    public void bind(Map<String, Object> id, Object obj) throws SAXException {
        throw XMLMarshalException.wrappedIDResolverWithMultiID(id.toString(), this.resolver);
    }

    public Object getResolver() {
        return this.resolver;
    }
}

