/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jaxb;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.descriptors.InstantiationPolicy;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;

public class MultiArgInstantiationPolicy
extends InstantiationPolicy {
    private String[] parameterTypeNames;
    private Class<?>[] parameterTypes;
    private Object[] defaultValues;

    public void setParameterTypeNames(String[] parameterTypeNames) {
        this.parameterTypeNames = parameterTypeNames;
    }

    public void setParameterTypes(Class<?>[] parameterTypes) {
        this.parameterTypes = parameterTypes;
    }

    public void setDefaultValues(Object[] values) {
        this.defaultValues = values;
    }

    @Override
    public void convertClassNamesToClasses(ClassLoader loader) {
        super.convertClassNamesToClasses(loader);
        if (this.parameterTypes == null && this.parameterTypeNames != null) {
            Class[] values = new Class[this.parameterTypeNames.length];
            for (int i = 0; i < values.length; ++i) {
                String parameterTypeName = this.parameterTypeNames[i];
                values[i] = PrivilegedAccessHelper.callDoPrivilegedWithException(() -> PrivilegedAccessHelper.getClassForName(parameterTypeName, true, loader), ex -> ValidationException.classNotFoundWhileConvertingClassNames(this.factoryClassName, ex));
            }
            this.parameterTypes = values;
        }
    }

    @Override
    protected void initializeMethod() throws DescriptorException {
        Class<Object> tempClass = this.getFactory() != null ? this.getFactory().getClass() : (this.getFactoryClass() == null ? this.getDescriptor().getJavaClass() : this.getFactoryClass());
        if (this.parameterTypes == null) {
            this.setMethod(this.buildMethod(tempClass, this.getMethodName(), new Class[0]));
        } else {
            this.setMethod(this.buildMethod(tempClass, this.getMethodName(), this.parameterTypes));
        }
    }

    @Override
    protected Object buildNewInstanceUsingFactory() throws DescriptorException {
        return PrivilegedAccessHelper.callDoPrivilegedWithException(() -> PrivilegedAccessHelper.invokeMethod(this.getMethod(), this.getFactory(), this.defaultValues), ex -> {
            if (ex instanceof IllegalAccessException) {
                return DescriptorException.illegalAccessWhileMethodInstantiation(this.getMethod().toString(), this.getDescriptor(), ex);
            }
            if (ex instanceof InvocationTargetException) {
                return DescriptorException.targetInvocationWhileMethodInstantiation(this.getMethod().toString(), this.getDescriptor(), ex);
            }
            if (ex instanceof NullPointerException) {
                return DescriptorException.nullPointerWhileMethodInstantiation(this.getMethod().toString(), this.getDescriptor(), ex);
            }
            return new RuntimeException("Unexpected exception from MultiArgInstantiationPolicy.buildNewInstanceUsingFactory()", ex);
        });
    }
}

