/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.layer;

import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import org.geoserver.catalog.CatalogException;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.event.CatalogAddEvent;
import org.geoserver.catalog.event.CatalogListener;
import org.geoserver.catalog.event.CatalogModifyEvent;
import org.geoserver.catalog.event.CatalogPostModifyEvent;
import org.geoserver.catalog.event.CatalogRemoveEvent;
import org.geoserver.gwc.layer.CatalogConfiguration;
import org.geoserver.gwc.layer.GeoServerTileLayer;
import org.geoserver.gwc.layer.GeoServerTileLayerInfo;
import org.geotools.util.logging.Logging;

public class CatalogStyleChangeListener
implements CatalogListener {
    private static Logger log = Logging.getLogger(CatalogStyleChangeListener.class);
    private final CatalogConfiguration catalogConfig;

    public CatalogStyleChangeListener(CatalogConfiguration catalogConfiguration) {
        this.catalogConfig = catalogConfiguration;
    }

    public void handleAddEvent(CatalogAddEvent event) throws CatalogException {
    }

    public void handleModifyEvent(CatalogModifyEvent event) throws CatalogException {
        String newStyleName;
        CatalogInfo source = event.getSource();
        if (!(source instanceof StyleInfo)) {
            return;
        }
        List propertyNames = event.getPropertyNames();
        if (!propertyNames.contains("name")) {
            return;
        }
        int index = propertyNames.indexOf("name");
        String oldStyleName = (String)event.getOldValues().get(index);
        if (oldStyleName.equals(newStyleName = (String)event.getNewValues().get(index))) {
            return;
        }
        List<GeoServerTileLayer> affectedLayers = this.catalogConfig.getTileLayersForStyle(oldStyleName);
        for (GeoServerTileLayer tl : affectedLayers) {
            GeoServerTileLayerInfo info = tl.getInfo();
            HashSet<String> styleNames = new HashSet<String>(info.getCachedStyles());
            if (!styleNames.contains(oldStyleName)) continue;
            tl.resetParameterFilters();
            this.catalogConfig.truncate(tl.getName(), oldStyleName);
            styleNames.remove(oldStyleName);
            styleNames.add(newStyleName);
            info.setCachedStyles(styleNames);
            this.catalogConfig.save(tl);
        }
    }

    public void handlePostModifyEvent(CatalogPostModifyEvent event) throws CatalogException {
        CatalogInfo obj = event.getSource();
        if (obj instanceof StyleInfo) {
            StyleInfo si = (StyleInfo)obj;
            this.handleStyleChange(si);
        }
    }

    private void handleStyleChange(StyleInfo modifiedStyle) {
        String styleName = modifiedStyle.getName();
        log.finer("Handling style modification: " + styleName);
        for (LayerInfo affectedLayer : this.catalogConfig.getLayerInfosFor(modifiedStyle)) {
            String prefixedName = affectedLayer.getResource().getPrefixedName();
            log.info("Truncating layer '" + prefixedName + "' due to a change in style '" + styleName + "'");
            this.catalogConfig.truncate(prefixedName, styleName);
        }
        for (LayerGroupInfo layerGroup : this.catalogConfig.getLayerGroupsFor(modifiedStyle)) {
            String layerGroupName = layerGroup.getName();
            log.info("Truncating layer group '" + layerGroupName + "' due to a change in style '" + styleName + "'");
            this.catalogConfig.truncate(layerGroupName);
        }
    }

    public void handleRemoveEvent(CatalogRemoveEvent event) throws CatalogException {
    }

    public void reloaded() {
    }
}

