/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.wms;

import java.io.ByteArrayOutputStream;
import java.lang.reflect.Method;
import java.nio.channels.Channels;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.geoserver.gwc.GWC;
import org.geoserver.ows.HttpErrorCodeException;
import org.geoserver.wms.GetMapRequest;
import org.geoserver.wms.WebMap;
import org.geoserver.wms.WebMapService;
import org.geoserver.wms.map.RawMap;
import org.geotools.util.logging.Logging;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.io.ByteArrayResource;
import org.geowebcache.io.Resource;
import org.springframework.util.Assert;

public class CachingWebMapService
implements MethodInterceptor {
    private static final Logger LOGGER = Logging.getLogger(CachingWebMapService.class);
    private GWC gwc;

    public CachingWebMapService(GWC gwc) {
        this.gwc = gwc;
    }

    public WebMap invoke(MethodInvocation invocation) throws Throwable {
        if (!this.gwc.getConfig().isDirectWMSIntegrationEnabled()) {
            return (WebMap)invocation.proceed();
        }
        Method method = invocation.getMethod();
        Assert.isTrue((boolean)method.getDeclaringClass().equals(WebMapService.class));
        Assert.isTrue((boolean)"getMap".equals(method.getName()));
        Object[] arguments = invocation.getArguments();
        Assert.isTrue((arguments.length == 1 ? 1 : 0) != 0);
        Assert.isInstanceOf(GetMapRequest.class, (Object)arguments[0]);
        GetMapRequest request = (GetMapRequest)arguments[0];
        boolean tiled = request.isTiled();
        if (!tiled) {
            return (WebMap)invocation.proceed();
        }
        ConveyorTile cachedTile = this.gwc.dispatch(request);
        if (cachedTile != null) {
            byte[] tileBytes;
            Resource mapContents;
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("GetMap request intercepted, serving cached content: " + request);
            }
            if ((mapContents = cachedTile.getBlob()) instanceof ByteArrayResource) {
                tileBytes = ((ByteArrayResource)mapContents).getContents();
            } else {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                mapContents.transferTo(Channels.newChannel(out));
                tileBytes = out.toByteArray();
            }
            String ifNoneMatch = request.getHttpRequestHeader("If-None-Match");
            byte[] hash = MessageDigest.getInstance("MD5").digest(tileBytes);
            String etag = this.toHexString(hash);
            if (etag.equals(ifNoneMatch)) {
                LOGGER.finer("ETag matches, returning 304");
                throw new HttpErrorCodeException(304);
            }
            LOGGER.finer("No matching ETag, returning cached tile");
            String mimeType = cachedTile.getMimeType().getMimeType();
            RawMap map = new RawMap(null, tileBytes, mimeType);
            map.setResponseHeader("Cache-Control", "no-cache");
            map.setResponseHeader("ETag", etag);
            map.setResponseHeader("geowebcache-tile-index", Arrays.toString(cachedTile.getTileIndex()));
            map.setContentDispositionHeader(null, "." + cachedTile.getMimeType().getFileExtension());
            return map;
        }
        return (WebMap)invocation.proceed();
    }

    private String toHexString(byte[] hash) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < hash.length) {
            int c1 = 0xFF & hash[i];
            int c2 = 0xFF & hash[i + 1];
            int c3 = 0xFF & hash[i + 2];
            int c4 = 0xFF & hash[i + 3];
            int integer = (c1 << 24) + (c2 << 16) + (c3 << 8) + (c4 << 0);
            sb.append(Integer.toHexString(integer));
            i += 4;
        }
        return sb.toString();
    }
}

