/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows;

import java.util.Collections;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.test.GeoServerTestSupport;

public class URLManglersTest
extends GeoServerTestSupport {
    private static final String BASEURL = "http://localhost:8080/geoserver";

    public void testBasic() {
        String url = ResponseUtils.buildURL((String)BASEURL, (String)"test", null, (URLMangler.URLType)URLMangler.URLType.SERVICE);
        URLManglersTest.assertEquals((String)"http://localhost:8080/geoserver/test", (String)url);
    }

    public void testKVP() {
        String url = ResponseUtils.buildURL((String)BASEURL, (String)"test", Collections.singletonMap("param", "value()"), (URLMangler.URLType)URLMangler.URLType.SERVICE);
        URLManglersTest.assertEquals((String)"http://localhost:8080/geoserver/test?param=value%28%29", (String)url);
    }

    public void testProxyBase() {
        GeoServerInfo gi = this.getGeoServer().getGlobal();
        gi.setProxyBaseUrl("http://geoserver.org/");
        this.getGeoServer().save(gi);
        String url = ResponseUtils.buildURL((String)BASEURL, (String)"test", null, (URLMangler.URLType)URLMangler.URLType.SERVICE);
        URLManglersTest.assertEquals((String)"http://geoserver.org/test", (String)url);
    }
}

