/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import org.acegisecurity.AcegiSecurityException;
import org.easymock.EasyMock;
import org.geoserver.security.SecureCatalogImpl;
import org.geoserver.security.SecureObjectsTest;
import org.geoserver.security.decorators.ReadOnlyDataAccess;
import org.geoserver.security.decorators.ReadOnlyDataStore;
import org.geoserver.security.decorators.ReadOnlyFeatureCollection;
import org.geoserver.security.decorators.ReadOnlyFeatureSource;
import org.geoserver.security.decorators.ReadOnlyFeatureStore;
import org.geotools.data.DataAccess;
import org.geotools.data.DataStore;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureStore;
import org.geotools.data.Query;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.NameImpl;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;

public class ReadOnlyFeatureSourceTest
extends SecureObjectsTest {
    public void testReadOnlyFeatureSourceDataStore() throws Exception {
        DataStore ds = (DataStore)EasyMock.createNiceMock(DataStore.class);
        EasyMock.replay((Object[])new Object[]{ds});
        FeatureSource fs = (FeatureSource)EasyMock.createNiceMock(FeatureSource.class);
        FeatureCollection fc = (FeatureCollection)EasyMock.createNiceMock(FeatureCollection.class);
        EasyMock.expect((Object)fs.getDataStore()).andReturn((Object)ds);
        EasyMock.expect((Object)fs.getFeatures()).andReturn((Object)fc);
        EasyMock.expect((Object)fs.getFeatures((Filter)Filter.INCLUDE)).andReturn((Object)fc);
        EasyMock.expect((Object)fs.getFeatures((Query)new DefaultQuery())).andReturn((Object)fc);
        EasyMock.replay((Object[])new Object[]{fs});
        ReadOnlyFeatureSource ro = new ReadOnlyFeatureSource(fs, SecureCatalogImpl.WrapperPolicy.HIDE);
        ReadOnlyFeatureSourceTest.assertTrue((boolean)(ro.getDataStore() instanceof ReadOnlyDataStore));
        ReadOnlyFeatureCollection collection = (ReadOnlyFeatureCollection)ro.getFeatures();
        ReadOnlyFeatureSourceTest.assertEquals((Object)SecureCatalogImpl.WrapperPolicy.HIDE, (Object)ro.policy);
        ReadOnlyFeatureSourceTest.assertTrue((boolean)(ro.getFeatures((Filter)Filter.INCLUDE) instanceof ReadOnlyFeatureCollection));
        ReadOnlyFeatureSourceTest.assertTrue((boolean)(ro.getFeatures((Query)new DefaultQuery()) instanceof ReadOnlyFeatureCollection));
    }

    public void testReadOnlyFeatureStore() throws Exception {
        SimpleFeatureType schema = (SimpleFeatureType)EasyMock.createNiceMock(SimpleFeatureType.class);
        EasyMock.expect((Object)schema.getName()).andReturn((Object)new NameImpl("testFT"));
        EasyMock.replay((Object[])new Object[]{schema});
        FeatureStore fs = (FeatureStore)EasyMock.createNiceMock(FeatureStore.class);
        EasyMock.expect((Object)fs.getSchema()).andReturn((Object)schema);
        EasyMock.replay((Object[])new Object[]{fs});
        ReadOnlyFeatureStore ro = new ReadOnlyFeatureStore(fs, SecureCatalogImpl.WrapperPolicy.RO_CHALLENGE);
        try {
            ro.addFeatures((FeatureCollection)EasyMock.createNiceMock(FeatureCollection.class));
            ReadOnlyFeatureSourceTest.fail((String)"This should have thrown a security exception");
        }
        catch (AcegiSecurityException e) {
            // empty catch block
        }
    }

    public void testReadOnlyFeatureSourceDataAccess() throws Exception {
        DataAccess da = (DataAccess)EasyMock.createNiceMock(DataAccess.class);
        EasyMock.replay((Object[])new Object[]{da});
        FeatureSource fs = (FeatureSource)EasyMock.createNiceMock(FeatureSource.class);
        EasyMock.expect((Object)fs.getDataStore()).andReturn((Object)da);
        EasyMock.replay((Object[])new Object[]{fs});
        ReadOnlyFeatureSource ro = new ReadOnlyFeatureSource(fs, SecureCatalogImpl.WrapperPolicy.RO_CHALLENGE);
        ReadOnlyFeatureSourceTest.assertTrue((boolean)(ro.getDataStore() instanceof ReadOnlyDataAccess));
    }
}

