/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.template;

import java.io.File;
import java.io.IOException;
import org.geoserver.template.GeoServerTemplateLoader;
import org.geoserver.test.GeoServerTestSupport;
import org.geotools.data.DataUtilities;
import org.opengis.feature.simple.SimpleFeatureType;

public class GeoServerTemplateLoaderTest
extends GeoServerTestSupport {
    public void test() throws Exception {
        File data = this.getTestData().getDataDirectoryRoot();
        File templates = new File(data, "templates");
        File featureTypes = new File(data, "featureTypes");
        File featureType1 = new File(featureTypes, "ft1");
        featureType1.mkdir();
        File featureType2 = new File(featureTypes, "ft2");
        featureType2.mkdir();
        GeoServerTemplateLoader templateLoader = new GeoServerTemplateLoader(((Object)((Object)this)).getClass());
        File expected = new File(templates, "1.ftl");
        expected.createNewFile();
        File actual = (File)templateLoader.findTemplateSource("1.ftl");
        GeoServerTemplateLoaderTest.assertEquals((String)expected.getCanonicalPath(), (String)actual.getCanonicalPath());
        expected = new File(featureType1, "2.ftl");
        expected.createNewFile();
        actual = (File)templateLoader.findTemplateSource("ft1/2.ftl");
        GeoServerTemplateLoaderTest.assertEquals((String)expected.getCanonicalPath(), (String)actual.getCanonicalPath());
        actual = (File)templateLoader.findTemplateSource("2.ftl");
        GeoServerTemplateLoaderTest.assertNull((Object)actual);
        Object source = templateLoader.findTemplateSource("FeatureSimple.ftl");
        GeoServerTemplateLoaderTest.assertNotNull((Object)source);
        GeoServerTemplateLoaderTest.assertFalse((boolean)(source instanceof File));
        templateLoader.getReader(source, "UTF-8");
    }

    public void testRemoteType() throws Exception {
        SimpleFeatureType ft = DataUtilities.createType((String)"remoteType", (String)"the_geom:MultiPolygon,FID:String,ADDRESS:String");
        GeoServerTemplateLoader loader = new GeoServerTemplateLoader(((Object)((Object)this)).getClass());
        loader.setFeatureType(ft);
        loader.findTemplateSource("header.ftl");
    }

    void delete(File file) throws IOException {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                this.delete(files[i]);
            }
        }
        file.delete();
    }
}

