/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows.kvp;

import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.geoserver.ows.util.KvpUtils;

public class KvpUtilsTest
extends TestCase {
    public void testEmptyString() {
        KvpUtilsTest.assertEquals((int)0, (int)KvpUtils.readFlat((String)"").size());
    }

    public void testTrailingEmtpyStrings() {
        KvpUtilsTest.assertEquals(Arrays.asList("x", "", "x", "", ""), (Object)KvpUtils.readFlat((String)"x,,x,,"));
    }

    public void testEmtpyNestedString() {
        List result = KvpUtils.readNested((String)"");
        KvpUtilsTest.assertEquals((int)1, (int)result.size());
        KvpUtilsTest.assertEquals((int)0, (int)((List)result.get(0)).size());
    }

    public void testStarNestedString() {
        List result = KvpUtils.readNested((String)"*");
        KvpUtilsTest.assertEquals((int)1, (int)result.size());
        KvpUtilsTest.assertEquals((int)0, (int)((List)result.get(0)).size());
    }

    public void testWellKnownTokenizers() {
        String[] expected = new String[]{"1", "2", "3", ""};
        List actual = KvpUtils.readFlat((String)"1,2,3,", (KvpUtils.Tokenizer)KvpUtils.INNER_DELIMETER);
        this.assertKvp(expected, actual);
        expected = new String[]{"abc", "def", ""};
        actual = KvpUtils.readFlat((String)"(abc)(def)()", (KvpUtils.Tokenizer)KvpUtils.OUTER_DELIMETER);
        this.assertKvp(expected, actual);
        expected = new String[]{"abc"};
        actual = KvpUtils.readFlat((String)"(abc)", (KvpUtils.Tokenizer)KvpUtils.OUTER_DELIMETER);
        this.assertKvp(expected, actual);
        expected = new String[]{""};
        actual = KvpUtils.readFlat((String)"()", (KvpUtils.Tokenizer)KvpUtils.OUTER_DELIMETER);
        this.assertKvp(expected, actual);
        expected = new String[]{"", "A=1", "B=2", ""};
        actual = KvpUtils.readFlat((String)";A=1;B=2;", (KvpUtils.Tokenizer)KvpUtils.CQL_DELIMITER);
        this.assertKvp(expected, actual);
        expected = new String[]{"ab", "cd", "ef", ""};
        actual = KvpUtils.readFlat((String)"ab&cd&ef&", (KvpUtils.Tokenizer)KvpUtils.KEYWORD_DELIMITER);
        this.assertKvp(expected, actual);
        expected = new String[]{"A", "1 "};
        actual = KvpUtils.readFlat((String)"A=1 ", (KvpUtils.Tokenizer)KvpUtils.VALUE_DELIMITER);
        this.assertKvp(expected, actual);
    }

    public void testRadFlatUnkownDelimiter() {
        String[] expected = new String[]{"1", "2", "3", ""};
        List actual = KvpUtils.readFlat((String)"1^2^3^", (String)"\\^");
        this.assertKvp(expected, actual);
        actual = KvpUtils.readFlat((String)"1-2-3-", (String)"-");
        this.assertKvp(expected, actual);
    }

    private void assertKvp(String[] expected, List actual) {
        List<String> expectedList = Arrays.asList(expected);
        KvpUtilsTest.assertEquals((int)expectedList.size(), (int)actual.size());
        KvpUtilsTest.assertEquals(expectedList, (Object)actual);
    }

    public void testEscapedTokens() {
        List actual = KvpUtils.escapedTokens((String)"", (char)',');
        KvpUtilsTest.assertEquals(Arrays.asList(""), (Object)actual);
        actual = KvpUtils.escapedTokens((String)",", (char)',');
        KvpUtilsTest.assertEquals(Arrays.asList("", ""), (Object)actual);
        actual = KvpUtils.escapedTokens((String)"a,b", (char)',');
        KvpUtilsTest.assertEquals(Arrays.asList("a", "b"), (Object)actual);
        actual = KvpUtils.escapedTokens((String)"a,b,c", (char)',');
        KvpUtilsTest.assertEquals(Arrays.asList("a", "b", "c"), (Object)actual);
        actual = KvpUtils.escapedTokens((String)"\\\\,\\\\", (char)',');
        KvpUtilsTest.assertEquals(Arrays.asList("\\\\", "\\\\"), (Object)actual);
        actual = KvpUtils.escapedTokens((String)"a\\,b,c", (char)',');
        KvpUtilsTest.assertEquals(Arrays.asList("a\\,b", "c"), (Object)actual);
        try {
            KvpUtils.escapedTokens(null, (char)',');
            KvpUtilsTest.fail((String)"Expected IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            KvpUtils.escapedTokens((String)"", (char)'\\');
            KvpUtilsTest.fail((String)"Expected IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            KvpUtils.escapedTokens((String)"\\", (char)'\\');
            KvpUtilsTest.fail((String)"Expected IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public static void testUnescape() {
        String actual = KvpUtils.unescape((String)"abc");
        KvpUtilsTest.assertEquals((String)"abc", (String)actual);
        actual = KvpUtils.unescape((String)"abc\\\\");
        KvpUtilsTest.assertEquals((String)"abc\\", (String)actual);
        actual = KvpUtils.unescape((String)"abc\\d");
        KvpUtilsTest.assertEquals((String)"abcd", (String)actual);
        try {
            KvpUtils.unescape(null);
            KvpUtilsTest.fail((String)"Expected IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            KvpUtils.unescape((String)"\\");
            KvpUtilsTest.fail((String)"Expected IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

