/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wcs.responses;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.MetadataLinkInfo;
import org.geoserver.config.ContactInfo;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.wcs.WCSInfo;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.geotools.xml.transform.TransformerBase;
import org.geotools.xml.transform.Translator;
import org.springframework.context.ApplicationContext;
import org.vfny.geoserver.global.CoverageInfoLabelComparator;
import org.vfny.geoserver.util.requests.CapabilitiesRequest;
import org.vfny.geoserver.wcs.requests.WCSRequest;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;

public class WCSCapsTransformer
extends TransformerBase {
    private static final Logger LOGGER = Logging.getLogger((String)WCSCapsTransformer.class.getPackage().getName());
    protected static final String WCS_URI = "http://www.opengis.net/wcs";
    protected static final String WFS_URI = "http://www.opengis.net/wcs";
    protected static final String CUR_VERSION = "1.0.0";
    protected static final String XSI_PREFIX = "xsi";
    protected static final String XSI_URI = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String[] EXCEPTION_FORMATS = new String[]{"application/vnd.ogc.se_xml", "application/vnd.ogc.se_inimage", "application/vnd.ogc.se_blank"};
    private String baseUrl;
    private ApplicationContext applicationContext;
    protected WCSRequest request;

    public WCSCapsTransformer(String baseUrl, ApplicationContext applicationContext) {
        if (baseUrl == null) {
            throw new NullPointerException();
        }
        this.baseUrl = baseUrl;
        this.setNamespaceDeclarationEnabled(false);
        this.applicationContext = applicationContext;
    }

    public Translator createTranslator(ContentHandler handler) {
        return new WCSCapsTranslator(handler, this.applicationContext);
    }

    public Transformer createTransformer() throws TransformerException {
        return super.createTransformer();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WCSCapsTranslator
    extends TransformerBase.TranslatorSupport {
        private CapabilitiesRequest request;
        private ApplicationContext applicationContext;

        public WCSCapsTranslator(ContentHandler handler, ApplicationContext applicationContext) {
            super(handler, null, null);
            this.applicationContext = applicationContext;
        }

        public void encode(Object o) throws IllegalArgumentException {
            if (!(o instanceof CapabilitiesRequest)) {
                throw new IllegalArgumentException(new StringBuffer("Not a CapabilitiesRequest: ").append(o).toString());
            }
            this.request = (CapabilitiesRequest)o;
            WCSInfo wcs = (WCSInfo)this.request.getServiceConfig();
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("", "version", "version", "", WCSCapsTransformer.CUR_VERSION);
            attributes.addAttribute("", "xmlns", "xmlns", "", "http://www.opengis.net/wcs");
            attributes.addAttribute("", "xmlns:xlink", "xmlns:xlink", "", "http://www.w3.org/1999/xlink");
            attributes.addAttribute("", "xmlns:ogc", "xmlns:ogc", "", "http://www.opengis.net/ogc");
            attributes.addAttribute("", "xmlns:gml", "xmlns:gml", "", "http://www.opengis.net/gml");
            String prefixDef = new StringBuffer("xmlns:").append(WCSCapsTransformer.XSI_PREFIX).toString();
            attributes.addAttribute("", prefixDef, prefixDef, "", WCSCapsTransformer.XSI_URI);
            String locationAtt = new StringBuffer(WCSCapsTransformer.XSI_PREFIX).append(":schemaLocation").toString();
            GeoServerInfo gsInfo = wcs.getGeoServer().getGlobal();
            String locationDef = "http://www.opengis.net/wcs " + ResponseUtils.buildURL((String)this.request.getBaseUrl(), (String)ResponseUtils.appendPath((String[])new String[]{"schemas", "schemas/wcs/1.0.0/wcsCapabilities.xsd"}), null, (URLMangler.URLType)URLMangler.URLType.RESOURCE);
            attributes.addAttribute("", locationAtt, locationAtt, "", locationDef);
            attributes.addAttribute("", "updateSequence", "updateSequence", "", gsInfo.getUpdateSequence() + "");
            this.start("WCS_Capabilities", attributes);
            this.handleService();
            this.handleCapabilities();
            this.end("WCS_Capabilities");
        }

        private void handleService() {
            WCSInfo wcs = (WCSInfo)this.request.getServiceConfig();
            AttributesImpl attributes = new AttributesImpl();
            this.start("Service", attributes);
            if (wcs.getMetadataLink() != null) {
                this.handleMetadataLink(Collections.singletonList(wcs.getMetadataLink()));
            }
            this.element("description", wcs.getAbstract());
            this.element("name", wcs.getName());
            this.element("label", wcs.getTitle());
            this.handleKeywords(wcs.getKeywords());
            this.handleContact(wcs);
            String fees = wcs.getFees();
            if (fees == null || "".equals(fees)) {
                fees = "NONE";
            }
            this.element("fees", fees);
            String accessConstraints = wcs.getAccessConstraints();
            if (accessConstraints == null || "".equals(accessConstraints)) {
                accessConstraints = "NONE";
            }
            this.element("accessConstraints", accessConstraints);
            this.end("Service");
        }

        private void handleCapabilities() {
            WCSInfo wcs = (WCSInfo)this.request.getServiceConfig();
            this.start("Capability");
            this.handleRequest(wcs);
            this.handleExceptions(wcs);
            this.handleVendorSpecifics(wcs);
            this.end("Capability");
            this.handleContentMetadata(wcs);
        }

        private void handleRequest(WCSInfo config) {
            this.start("Request");
            this.handleCapability(config, "GetCapabilities");
            this.handleCapability(config, "DescribeCoverage");
            this.handleCapability(config, "GetCoverage");
            this.end("Request");
        }

        private void handleCapability(WCSInfo config, String capabilityName) {
            AttributesImpl attributes = new AttributesImpl();
            this.start(capabilityName);
            this.start("DCPType");
            this.start("HTTP");
            String baseURL = ResponseUtils.buildURL((String)this.request.getBaseUrl(), (String)"wcs", null, (URLMangler.URLType)URLMangler.URLType.EXTERNAL);
            if (baseURL.indexOf(63) == -1) {
                baseURL = ResponseUtils.appendQueryString((String)baseURL, (String)"");
            }
            attributes.addAttribute("", "xlink:href", "xlink:href", "", baseURL);
            this.start("Get");
            this.start("OnlineResource", attributes);
            this.end("OnlineResource");
            this.end("Get");
            this.end("HTTP");
            this.end("DCPType");
            attributes = new AttributesImpl();
            attributes.addAttribute("", "xlink:href", "xlink:href", "", baseURL);
            this.start("DCPType");
            this.start("HTTP");
            this.start("Post");
            this.start("OnlineResource", attributes);
            this.end("OnlineResource");
            this.end("Post");
            this.end("HTTP");
            this.end("DCPType");
            this.end(capabilityName);
        }

        private void handleKeywords(List kwords) {
            this.start("keywords");
            if (kwords != null) {
                Iterator it = kwords.iterator();
                while (it.hasNext()) {
                    this.element("keyword", it.next().toString());
                }
            }
            this.end("keywords");
        }

        private void handleContact(WCSInfo config) {
            String tmp = "";
            GeoServerInfo geoServer = config.getGeoServer().getGlobal();
            ContactInfo contact = geoServer.getContact();
            String cp = contact.getContactPerson();
            String org = contact.getContactOrganization();
            if (cp != null && cp != "" || org != null && org != "") {
                this.start("responsibleParty");
                tmp = cp;
                if (tmp != null && tmp != "") {
                    this.element("individualName", tmp);
                    tmp = org;
                    if (tmp != null && tmp != "") {
                        this.element("organisationName", tmp);
                    }
                } else {
                    tmp = org;
                    if (tmp != null && tmp != "") {
                        this.element("organisationName", tmp);
                    }
                }
                if ((tmp = contact.getContactPosition()) != null && tmp != "") {
                    this.element("positionName", tmp);
                }
                this.start("contactInfo");
                this.start("phone");
                tmp = contact.getContactVoice();
                if (tmp != null && tmp != "") {
                    this.element("voice", tmp);
                }
                if ((tmp = contact.getContactFacsimile()) != null && tmp != "") {
                    this.element("facsimile", tmp);
                }
                this.end("phone");
                this.start("address");
                tmp = contact.getAddressType();
                if (tmp != null && tmp != "") {
                    String addr = "";
                    addr = contact.getAddress();
                    if (addr != null && addr != "") {
                        this.element("deliveryPoint", tmp + " " + addr);
                    }
                } else {
                    tmp = contact.getAddress();
                    if (tmp != null && tmp != "") {
                        this.element("deliveryPoint", tmp);
                    }
                }
                tmp = contact.getAddressCity();
                if (tmp != null && tmp != "") {
                    this.element("city", tmp);
                }
                if ((tmp = contact.getAddressState()) != null && tmp != "") {
                    this.element("administrativeArea", tmp);
                }
                if ((tmp = contact.getAddressPostalCode()) != null && tmp != "") {
                    this.element("postalCode", tmp);
                }
                if ((tmp = contact.getAddressCountry()) != null && tmp != "") {
                    this.element("country", tmp);
                }
                if ((tmp = contact.getContactEmail()) != null && tmp != "") {
                    this.element("electronicMailAddress", tmp);
                }
                this.end("address");
                tmp = geoServer.getOnlineResource();
                if (tmp != null && tmp != "") {
                    AttributesImpl attributes = new AttributesImpl();
                    attributes.addAttribute("", "xlink:href", "xlink:href", "", tmp);
                    this.start("onlineResource", attributes);
                    this.end("onlineResource");
                }
                this.end("contactInfo");
                this.end("responsibleParty");
            }
        }

        private void handleExceptions(WCSInfo config) {
            this.start("Exception");
            for (String format : EXCEPTION_FORMATS) {
                this.element("Format", format);
            }
            this.end("Exception");
        }

        private void handleVendorSpecifics(WCSInfo config) {
        }

        private void handleEnvelope(ReferencedEnvelope envelope) {
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("", "srsName", "srsName", "", "WGS84(DD)");
            this.start("lonLatEnvelope", attributes);
            this.element("gml:pos", new StringBuffer(Double.toString(envelope.getLowerCorner().getOrdinate(0))).append(" ").append(envelope.getLowerCorner().getOrdinate(1)).toString());
            this.element("gml:pos", new StringBuffer(Double.toString(envelope.getUpperCorner().getOrdinate(0))).append(" ").append(envelope.getUpperCorner().getOrdinate(1)).toString());
            this.end("lonLatEnvelope");
        }

        private void handleMetadataLink(List<MetadataLinkInfo> links) {
            for (MetadataLinkInfo mdl : links) {
                AttributesImpl attributes = new AttributesImpl();
                if (mdl.getAbout() != null && mdl.getAbout() != "") {
                    attributes.addAttribute("", "about", "about", "", mdl.getAbout());
                }
                if (mdl.getMetadataType() != null && mdl.getMetadataType() != "") {
                    attributes.addAttribute("", "metadataType", "metadataType", "", mdl.getMetadataType());
                }
                if (attributes.getLength() <= 0) continue;
                this.start("metadataLink", attributes);
                this.end("metadataLink");
            }
        }

        private void handleContentMetadata(WCSInfo config) {
            AttributesImpl attributes = new AttributesImpl();
            this.start("ContentMetadata", attributes);
            Catalog catalog = config.getGeoServer().getCatalog();
            List coverages = catalog.getCoverages();
            Iterator it = coverages.iterator();
            while (it.hasNext()) {
                CoverageInfo cv = (CoverageInfo)it.next();
                if (cv.enabled()) continue;
                it.remove();
            }
            if (this.request.getNamespace() != null) {
                String namespace = this.request.getNamespace();
                Iterator it2 = coverages.iterator();
                while (it2.hasNext()) {
                    CoverageInfo cv = (CoverageInfo)it2.next();
                    if (namespace.equals(cv.getStore().getWorkspace().getName())) continue;
                    it2.remove();
                }
            }
            Collections.sort(coverages, new CoverageInfoLabelComparator());
            Iterator i = coverages.iterator();
            while (i.hasNext()) {
                this.handleCoverageOfferingBrief(config, (CoverageInfo)i.next());
            }
            this.end("ContentMetadata");
        }

        private void handleCoverageOfferingBrief(WCSInfo config, CoverageInfo cv) {
            if (cv.enabled()) {
                this.start("CoverageOfferingBrief");
                this.handleMetadataLink(cv.getMetadataLinks());
                String tmp = cv.getDescription();
                if (tmp != null && tmp != "") {
                    this.element("description", tmp);
                }
                if ((tmp = cv.getName()) != null && tmp != "") {
                    this.element("name", tmp);
                }
                if ((tmp = cv.getTitle()) != null && tmp != "") {
                    this.element("label", tmp);
                }
                this.handleEnvelope(cv.getLatLonBoundingBox());
                this.handleKeywords(cv.getKeywords());
                this.end("CoverageOfferingBrief");
            }
        }
    }
}

