/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.filters;

import com.mockrunner.mock.web.MockHttpServletRequest;
import com.mockrunner.mock.web.MockHttpSession;
import com.mockrunner.mock.web.MockServletContext;
import java.lang.reflect.Method;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.geoserver.test.GeoServerTestSupport;

public class RequestWrapperTestSupport
extends GeoServerTestSupport {
    protected final String[] testStrings = new String[]{"Hello, this is a test", "LongLongLongLongLongLongLongLongLongLongLongLongLongLongLongLong", "", "test\ncontaining\nnewlines"};

    protected HttpServletRequest makeRequest(String body, String queryString) {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setScheme("http");
        request.setServerName("localhost");
        request.setContextPath("/geoserver");
        request.setRequestURI("/geoserver");
        request.setQueryString(queryString != null ? queryString : "");
        request.setRemoteAddr("127.0.0.1");
        request.setServletPath("/geoserver");
        request.setContentType("application/x-www-form-urlencoded");
        request.setMethod("POST");
        request.setBodyContent(body);
        MockHttpSession session = new MockHttpSession();
        session.setupServletContext((ServletContext)new MockServletContext());
        request.setSession((HttpSession)session);
        request.setUserPrincipal(null);
        return request;
    }

    public static void compare(HttpServletRequest reqA, HttpServletRequest reqB) {
        Method[] methods = HttpServletRequest.class.getMethods();
        int i = 0;
        while (i < methods.length) {
            try {
                if (methods[i].getParameterTypes().length == 0) {
                    Object resultA = methods[i].invoke((Object)reqA, new Object[0]);
                    Object resultB = methods[i].invoke((Object)reqB, new Object[0]);
                    RequestWrapperTestSupport.assertEquals((Object)resultA, (Object)resultB);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
    }
}

