/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.filters;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.filters.ReverseProxyFilter;
import org.geoserver.ows.util.RequestUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geotools.util.logging.Logging;

/*
 * Exception performing whole class analysis ignored.
 */
public class ReverseProxyFilter
implements Filter {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geoserver.filters");
    private static final String ENABLED_INIT_PARAM = "enabled";
    private static final String MIME_TYPES_INIT_PARAM = "mime-types";
    private boolean filterIsEnabled;
    private final Set<Pattern> mimeTypePatterns = new HashSet();
    private GeoServerInfo geoServer;

    public void init(FilterConfig filterConfig) throws ServletException {
        String enabledInitParam = filterConfig.getInitParameter("enabled");
        this.filterIsEnabled = Boolean.valueOf(enabledInitParam);
        if (this.filterIsEnabled) {
            String mimeTypesInitParam = filterConfig.getInitParameter("mime-types");
            GeoServer geoServerConfig = (GeoServer)GeoServerExtensions.bean(GeoServer.class);
            if (geoServerConfig == null) {
                throw new ServletException("No " + GeoServer.class.getName() + " found, the system is either not properly " + "configured or the method to get to the GeoServer " + "config instance have changed!");
            }
            this.geoServer = geoServerConfig.getGlobal();
            if (this.geoServer == null) {
                throw new ServletException("No GeoServerInfo instance found. Needed to look for the proxy base URL");
            }
            Set patterns = ReverseProxyFilter.parsePatterns((GeoServerInfo)this.geoServer, (String)mimeTypesInitParam);
            this.mimeTypePatterns.addAll(patterns);
            LOGGER.finer("Reverse Proxy Filter configured");
        } else {
            LOGGER.fine("Reverse Proxy Filter is disabled by configuration");
        }
    }

    static Set<Pattern> parsePatterns(GeoServerInfo geoServer, String mimeTypesInitParam) throws ServletException {
        String[] split = mimeTypesInitParam.split(",");
        LOGGER.finer("Initializing Reverse Proxy Filter");
        HashSet<Pattern> mimeTypePatterns = new HashSet<Pattern>();
        try {
            for (int i = 0; i < split.length; ++i) {
                String mimeTypeRegExp = split[i];
                LOGGER.finest("Registering mime type regexp for reverse proxy filter: " + mimeTypeRegExp);
                Pattern mimeTypePattern = Pattern.compile(mimeTypeRegExp);
                mimeTypePatterns.add(mimeTypePattern);
            }
        }
        catch (PatternSyntaxException e) {
            throw new ServletException("Error compiling Reverse Proxy Filter mime-types: " + e.getMessage(), (Throwable)e);
        }
        return mimeTypePatterns;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        LOGGER.finer("filtering " + ((HttpServletRequest)request).getRequestURL());
        if (!this.filterIsEnabled || !(request instanceof HttpServletRequest)) {
            chain.doFilter(request, response);
            return;
        }
        String proxyBaseUrl = this.geoServer.getProxyBaseUrl();
        if (proxyBaseUrl == null || "".equals(proxyBaseUrl)) {
            chain.doFilter(request, response);
            return;
        }
        CacheingResponseWrapper wrapper = new CacheingResponseWrapper((HttpServletResponse)response, this.mimeTypePatterns);
        chain.doFilter(request, (ServletResponse)wrapper);
        wrapper.flushBuffer();
        if (wrapper.isCacheing()) {
            String line;
            byte[] cachedContent = wrapper.getCachedContent();
            String cs = wrapper.getCharacterEncoding();
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(cachedContent), cs));
            PrintWriter writer = response.getWriter();
            String _baseUrl = RequestUtils.baseURL((HttpServletRequest)((HttpServletRequest)request));
            if (_baseUrl.endsWith("/")) {
                _baseUrl = _baseUrl.substring(0, _baseUrl.length() - 1);
            }
            String baseUrl = _baseUrl;
            URL base = new URL(baseUrl);
            URL proxy = new URL(proxyBaseUrl);
            String serverBase = this.getServerBase(base);
            String proxyBase = this.getServerBase(proxy);
            String context = this.getContext(base);
            String proxyContext = this.getContext(proxy);
            LOGGER.finer("translating " + ((HttpServletRequest)request).getRequestURI());
            while ((line = reader.readLine()) != null) {
                String translatedLine = line.indexOf(proxyBaseUrl) != -1 ? line.replaceAll(proxyBaseUrl, baseUrl) : line;
                translatedLine = translatedLine.replaceAll(serverBase, proxyBase);
                translatedLine = translatedLine.replaceAll(context, proxyContext);
                if (LOGGER.isLoggable(Level.FINE) && !line.equals(translatedLine)) {
                    LOGGER.finest("translated '" + line + "'");
                    LOGGER.finest("        as '" + translatedLine + "'");
                }
                writer.println(translatedLine);
            }
            writer.flush();
        }
    }

    private String getContext(URL url) {
        String context = url.getPath();
        return context.endsWith("/") ? context : context + "/";
    }

    private String getServerBase(URL url) {
        StringBuffer sb = new StringBuffer();
        sb.append(url.getProtocol()).append("://");
        sb.append(url.getHost());
        if (url.getPort() != -1) {
            sb.append(":").append(url.getPort());
        }
        sb.append("/");
        return sb.toString();
    }

    public void destroy() {
    }
}

