/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.demo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.link.ExternalLink;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.GeoServerBasePage;
import org.geoserver.web.demo.PreviewLayer;
import org.geoserver.web.demo.PreviewLayerProvider;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.wfs.WFSGetFeatureOutputFormat;
import org.vfny.geoserver.wms.GetMapProducer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapPreviewPage
extends GeoServerBasePage {
    PreviewLayerProvider provider = new PreviewLayerProvider();
    GeoServerTablePanel<PreviewLayer> table;

    public MapPreviewPage() {
        final List<String> wmsOutputFormats = this.getAvailableWMSFormats();
        final List<String> wfsOutputFormats = this.getAvailableWFSFormats();
        this.table = new GeoServerTablePanel<PreviewLayer>("table", (GeoServerDataProvider)this.provider){

            protected Component getComponentForProperty(String id, IModel itemModel, GeoServerDataProvider.Property<PreviewLayer> property) {
                PreviewLayer layer = (PreviewLayer)itemModel.getObject();
                if (property == PreviewLayerProvider.TYPE) {
                    Fragment f = new Fragment(id, "iconFragment", (MarkupContainer)MapPreviewPage.this);
                    f.add((Component)new Image("layerIcon", layer.getIcon()));
                    return f;
                }
                if (property == PreviewLayerProvider.NAME) {
                    return new Label(id, property.getModel(itemModel));
                }
                if (property == PreviewLayerProvider.TITLE) {
                    return new Label(id, property.getModel(itemModel));
                }
                if (property == PreviewLayerProvider.COMMON) {
                    Fragment f = new Fragment(id, "commonLinks", (MarkupContainer)MapPreviewPage.this);
                    String olUrl = String.valueOf(layer.getWmsLink()) + "&format=application/openlayers";
                    f.add((Component)new ExternalLink("ol", olUrl, "OpenLayers"));
                    String kmlUrl = "../wms/kml?layers=" + layer.getName();
                    f.add((Component)new ExternalLink("kml", kmlUrl, "KML"));
                    String gmlUrl = "../ows?service=WFS&version=1.0.0&request=GetFeature&typeName=" + layer.getName() + "&maxFeatures=50";
                    ExternalLink gmlLink = new ExternalLink("gml", gmlUrl, "GML");
                    f.add((Component)gmlLink);
                    gmlLink.setVisible(layer.getType() == PreviewLayer.PreviewLayerType.Vector);
                    return f;
                }
                if (property == PreviewLayerProvider.ALL) {
                    return MapPreviewPage.this.buildJSWMSSelect(id, wmsOutputFormats, wfsOutputFormats, layer);
                }
                throw new IllegalArgumentException("Don't know a property named " + property.getName());
            }
        };
        this.table.setOutputMarkupId(true);
        this.add((Component)this.table);
    }

    private List<String> getAvailableWMSFormats() {
        ArrayList<String> formats = new ArrayList<String>();
        GeoServerApplication application = this.getGeoServerApplication();
        for (GetMapProducer producer : application.getBeansOfType(GetMapProducer.class)) {
            formats.add(producer.getOutputFormat());
        }
        formats = new ArrayList(new HashSet(formats));
        this.prepareFormatList(formats, new FormatComparator("format.wms."));
        return formats;
    }

    private List<String> getAvailableWFSFormats() {
        ArrayList<String> formats = new ArrayList<String>();
        GeoServerApplication application = this.getGeoServerApplication();
        for (WFSGetFeatureOutputFormat producer : application.getBeansOfType(WFSGetFeatureOutputFormat.class)) {
            for (String format : producer.getOutputFormats()) {
                formats.add(format);
            }
        }
        this.prepareFormatList(formats, new FormatComparator("format.wfs."));
        return formats;
    }

    private void prepareFormatList(List<String> formats, FormatComparator comparator) {
        Collections.sort(formats, comparator);
        String prev = null;
        Iterator<String> it = formats.iterator();
        while (it.hasNext()) {
            String format = it.next();
            if (prev != null && comparator.compare(format, prev) == 0) {
                it.remove();
            }
            prev = format;
        }
    }

    private Component buildJSWMSSelect(String id, List<String> wmsOutputFormats, List<String> wfsOutputFormats, PreviewLayer layer) {
        Fragment f = new Fragment(id, "menuFragment", (MarkupContainer)this);
        WebMarkupContainer menu = new WebMarkupContainer("menu");
        RepeatingView wmsFormats = new RepeatingView("wmsFormats");
        int i = 0;
        while (i < wmsOutputFormats.size()) {
            String wmsOutputFormat = wmsOutputFormats.get(i);
            String label = this.translateFormat("format.wms.", wmsOutputFormat);
            Label format = new Label(String.valueOf(i), label);
            format.add((IBehavior)new AttributeModifier("value", true, (IModel)new Model((Serializable)((Object)wmsOutputFormat))));
            wmsFormats.add((Component)format);
            ++i;
        }
        menu.add((Component)wmsFormats);
        boolean vector = layer.groupInfo == null && layer.layerInfo.getType() != LayerInfo.Type.RASTER;
        WebMarkupContainer wfsFormatsGroup = new WebMarkupContainer("wfs");
        RepeatingView wfsFormats = new RepeatingView("wfsFormats");
        if (vector) {
            int i2 = 0;
            while (i2 < wfsOutputFormats.size()) {
                String wfsOutputFormat = wfsOutputFormats.get(i2);
                String label = this.translateFormat("format.wfs.", wfsOutputFormat);
                Label format = new Label(String.valueOf(i2), label);
                format.add((IBehavior)new AttributeModifier("value", true, (IModel)new Model((Serializable)((Object)wfsOutputFormat))));
                wfsFormats.add((Component)format);
                ++i2;
            }
        }
        wfsFormatsGroup.add((Component)wfsFormats);
        menu.add((Component)wfsFormatsGroup);
        String wmsUrl = "'" + layer.getWmsLink() + "&format=' + this.options[this.selectedIndex].value";
        String wfsUrl = "'../ows?service=WFS&version=1.0.0&request=GetFeature&typeName=" + layer.getName() + "&maxFeatures=50" + "&outputFormat=' + this.options[this.selectedIndex].value";
        String choice = "(this.options[this.selectedIndex].parentNode.label == 'WMS') ? " + wmsUrl + " : " + wfsUrl;
        menu.add((IBehavior)new AttributeAppender("onchange", (IModel)new Model((Serializable)((Object)("window.open(" + choice + ");this.selectedIndex=0"))), ";"));
        f.add((Component)menu);
        return f;
    }

    private String translateFormat(String prefix, String format) {
        try {
            return this.getLocalizer().getString(String.valueOf(prefix) + format, (Component)this);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, e.getMessage());
            return format;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FormatComparator
    implements Comparator<String> {
        String prefix;

        public FormatComparator(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public int compare(String f1, String f2) {
            String t1 = MapPreviewPage.this.translateFormat(this.prefix, f1);
            String t2 = MapPreviewPage.this.translateFormat(this.prefix, f2);
            return t1.compareTo(t2);
        }
    }
}

