/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.web.publish;

import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.geoserver.catalog.AuthorityURLInfo;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.LayerIdentifierInfo;
import org.geoserver.web.wicket.LiveCollectionModel;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.web.publish.AuthorityURLListEditor;
import org.geoserver.wms.web.publish.LayerIdentifierListEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayerAuthoritiesAndIdentifiersPanel
extends Panel {
    private static final long serialVersionUID = 1L;

    public LayerAuthoritiesAndIdentifiersPanel(String id, boolean isRootLayer, IModel<? extends CatalogInfo> layerModel) {
        super(id);
        LiveCollectionModel authURLsModel = LiveCollectionModel.list((IModel)new PropertyModel(layerModel, "authorityURLs"));
        AuthorityURLListEditor authUrlEditor = new AuthorityURLListEditor("authorityurls", (IModel<List<AuthorityURLInfo>>)authURLsModel);
        this.add(new Component[]{authUrlEditor});
        LiveCollectionModel identifiersModel = LiveCollectionModel.list((IModel)new PropertyModel(layerModel, "identifiers"));
        LayerIdentifierListEditor identifiersEditor = new LayerIdentifierListEditor("layerIdentifiers", (IModel<List<LayerIdentifierInfo>>)identifiersModel, authUrlEditor);
        if (!isRootLayer) {
            WMSInfo serviceInfo = WMS.get().getServiceInfo();
            List rootLayerAuthorities = serviceInfo.getAuthorityURLs();
            identifiersEditor.setBaseAuthorities(rootLayerAuthorities);
        }
        this.add(new Component[]{identifiersEditor});
    }
}

