/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import com.mockrunner.mock.web.MockHttpServletRequest;
import com.mockrunner.mock.web.MockHttpServletResponse;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.servlet.Filter;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.codec.binary.Base64;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.exceptions.XpathException;
import org.geoserver.data.test.MockData;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.CatalogMode;
import org.geoserver.security.impl.DataAccessRuleDAO;
import org.geoserver.wfs.WFSTestSupport;
import org.springframework.context.ApplicationContext;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecuredGetFeatureTest
extends WFSTestSupport {
    public static QName NULL_GEOMETRIES = new QName(MockData.CITE_URI, "NullGeometries", MockData.CITE_PREFIX);

    protected void populateDataDirectory(MockData dataDirectory) throws Exception {
        super.populateDataDirectory(dataDirectory);
        File security = new File(dataDirectory.getDataDirectoryRoot(), "security");
        security.mkdir();
        File users = new File(security, "users.properties");
        Properties props = new Properties();
        props.put("admin", "geoserver,ROLE_ADMINISTRATOR");
        props.put("cite", "cite,ROLE_CITE_READER");
        props.store(new FileOutputStream(users), "");
        File layers = new File(security, "layers.properties");
        props.put("*.*.r", "ROLE_NO_ONE");
        props.put("*.*.w", "ROLE_NO_ONE");
        props.put(MockData.CITE_PREFIX, "cite,ROLE_CITE_READER");
        props.put("cite.*.r", "cite,ROLE_CITE_READER");
        props.store(new FileOutputStream(layers), "");
    }

    protected List<Filter> getFilters() {
        return Collections.singletonList((Filter)GeoServerExtensions.bean((String)"filterChainProxy"));
    }

    public void testGetNoAuthHide() throws Exception {
        DataAccessRuleDAO dao = (DataAccessRuleDAO)GeoServerExtensions.bean(DataAccessRuleDAO.class, (ApplicationContext)applicationContext);
        dao.setCatalogMode(CatalogMode.HIDE);
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=1.1.0&service=wfs&typeName=" + this.getLayerId(MockData.BUILDINGS));
        this.checkOws10Exception(doc);
        XMLAssert.assertXpathEvaluatesTo((String)"Unknown namespace [cite]", (String)"//ows:ExceptionText/text()", (Document)doc);
    }

    public void testGetNoAuthChallenge() throws Exception {
        DataAccessRuleDAO dao = (DataAccessRuleDAO)GeoServerExtensions.bean(DataAccessRuleDAO.class, (ApplicationContext)applicationContext);
        dao.setCatalogMode(CatalogMode.CHALLENGE);
        MockHttpServletResponse resp = this.getAsServletResponse("wfs?request=GetFeature&version=1.0.0&service=wfs&typeName=" + this.getLayerId(MockData.BUILDINGS));
        SecuredGetFeatureTest.assertEquals((int)401, (int)resp.getErrorCode());
        SecuredGetFeatureTest.assertEquals((String)"Basic realm=\"GeoServer Realm\"", (String)resp.getHeader("WWW-Authenticate"));
    }

    public void testInvalidAuthChallenge() throws Exception {
        DataAccessRuleDAO dao = (DataAccessRuleDAO)GeoServerExtensions.bean(DataAccessRuleDAO.class, (ApplicationContext)applicationContext);
        dao.setCatalogMode(CatalogMode.CHALLENGE);
        MockHttpServletRequest request = this.createRequest("wfs?request=GetFeature&version=1.0.0&service=wfs&typeName=" + this.getLayerId(MockData.BUILDINGS));
        request.addHeader("Authorization", "Basic " + Base64.encodeBase64((byte[])"cite:wrongpassword".getBytes()));
        MockHttpServletResponse resp = this.dispatch((HttpServletRequest)request);
        SecuredGetFeatureTest.assertEquals((int)401, (int)resp.getErrorCode());
        SecuredGetFeatureTest.assertEquals((String)"Basic realm=\"GeoServer Realm\"", (String)resp.getHeader("WWW-Authenticate"));
    }

    public void testValidAuth() throws Exception {
        this.checkValidAuth("cite", "cite");
    }

    public void testValidAuthAdmin() throws Exception {
        this.checkValidAuth("admin", "geoserver");
    }

    private void checkValidAuth(String username, String password) throws Exception, ParserConfigurationException, SAXException, IOException, XpathException {
        DataAccessRuleDAO dao = (DataAccessRuleDAO)GeoServerExtensions.bean(DataAccessRuleDAO.class, (ApplicationContext)applicationContext);
        dao.setCatalogMode(CatalogMode.CHALLENGE);
        this.authenticate(username, password);
        Document doc = this.getAsDOM("wfs?request=GetFeature&version=1.0.0&service=wfs&typeName=" + this.getLayerId(MockData.BUILDINGS));
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(/wfs:FeatureCollection)", (Document)doc);
    }
}

