/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.kvp;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import net.opengis.wfs.GetFeatureType;
import net.opengis.wfs.QueryType;
import net.opengis.wfs.WfsFactory;
import org.geoserver.data.test.MockData;
import org.geoserver.test.ows.KvpRequestReaderTestSupport;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.kvp.GetFeatureKvpRequestReader;
import org.geotools.factory.CommonFactoryFinder;

public class GetFeatureKvpRequestReaderTest
extends KvpRequestReaderTestSupport {
    private GetFeatureKvpRequestReader reader;

    protected void setUpInternal() throws Exception {
        super.setUpInternal();
        this.reader = new GetFeatureKvpRequestReader(GetFeatureType.class, this.getCatalog(), CommonFactoryFinder.getFilterFactory(null));
    }

    public void testInvalidTypeNameBbox() throws Exception {
        HashMap<String, String> raw = new HashMap<String, String>();
        raw.put("service", "WFS");
        raw.put("version", "1.1.0");
        raw.put("request", "GetFeature");
        raw.put("bbox", "-80.4864795578115,25.6176257083275,-80.3401307394915,25.7002737069969");
        raw.put("typeName", "cite:InvalidTypeName");
        Map parsed = this.parseKvp(raw);
        try {
            this.reader.read((Object)WfsFactory.eINSTANCE.createGetFeatureType(), parsed, raw);
        }
        catch (WFSException e) {
            GetFeatureKvpRequestReaderTest.assertEquals((String)"InvalidParameterValue", (String)e.getCode());
            GetFeatureKvpRequestReaderTest.assertEquals((String)"typeName", (String)e.getLocator());
            System.out.println(e.getMessage());
            GetFeatureKvpRequestReaderTest.assertTrue((boolean)e.getMessage().contains("cite:InvalidTypeName"));
        }
    }

    public void testInvalidTypeName() throws Exception {
        HashMap<String, String> raw = new HashMap<String, String>();
        raw.put("service", "WFS");
        raw.put("version", "1.1.0");
        raw.put("request", "GetFeature");
        raw.put("typeName", "InvalidTypeName");
        try {
            Map parsed = this.parseKvp(raw);
            this.reader.read((Object)WfsFactory.eINSTANCE.createGetFeatureType(), parsed, raw);
        }
        catch (WFSException e) {
            GetFeatureKvpRequestReaderTest.assertEquals((String)"InvalidParameterValue", (String)e.getCode());
            GetFeatureKvpRequestReaderTest.assertEquals((String)"typeName", (String)e.getLocator());
            GetFeatureKvpRequestReaderTest.assertTrue((boolean)e.getMessage().contains("InvalidTypeName"));
        }
    }

    public void testUserProvidedNamespace() throws Exception {
        String localPart = MockData.MLINES.getLocalPart();
        String namespace = MockData.MLINES.getNamespaceURI();
        String alternamePrefix = "ex";
        String alternameTypeName = "ex:" + localPart;
        HashMap<String, String> raw = new HashMap<String, String>();
        raw.put("service", "WFS");
        raw.put("version", "1.1.0");
        raw.put("request", "GetFeature");
        raw.put("typeName", alternameTypeName);
        raw.put("namespace", "xmlns(ex=" + namespace + ")");
        Map parsed = this.parseKvp(raw);
        GetFeatureType req = WfsFactory.eINSTANCE.createGetFeatureType();
        Object read = this.reader.read((Object)req, parsed, raw);
        GetFeatureType parsedReq = (GetFeatureType)read;
        QueryType query = (QueryType)parsedReq.getQuery().get(0);
        List typeNames = query.getTypeName();
        GetFeatureKvpRequestReaderTest.assertEquals((int)1, (int)typeNames.size());
        GetFeatureKvpRequestReaderTest.assertEquals((Object)MockData.MLINES, typeNames.get(0));
    }

    public void testUserProvidedDefaultNamespace() throws Exception {
        QName qName = MockData.STREAMS;
        String typeName = qName.getLocalPart();
        String defaultNamespace = qName.getNamespaceURI();
        HashMap<String, String> raw = new HashMap<String, String>();
        raw.put("service", "WFS");
        raw.put("version", "1.1.0");
        raw.put("request", "GetFeature");
        raw.put("typeName", typeName);
        raw.put("namespace", "xmlns(" + defaultNamespace + ")");
        Map parsed = this.parseKvp(raw);
        GetFeatureType req = WfsFactory.eINSTANCE.createGetFeatureType();
        Object read = this.reader.read((Object)req, parsed, raw);
        GetFeatureType parsedReq = (GetFeatureType)read;
        QueryType query = (QueryType)parsedReq.getQuery().get(0);
        List typeNames = query.getTypeName();
        GetFeatureKvpRequestReaderTest.assertEquals((int)1, (int)typeNames.size());
        GetFeatureKvpRequestReaderTest.assertEquals((Object)qName, typeNames.get(0));
    }

    public void testViewParams() throws Exception {
        HashMap<String, String> raw = new HashMap<String, String>();
        raw.put("service", "WFS");
        raw.put("version", "1.1.0");
        raw.put("request", "GetFeature");
        raw.put("typeName", this.getLayerId(MockData.STREAMS));
        raw.put("viewParams", "where:WHERE PERSONS > 1000000;str:ABCD");
        Map parsed = this.parseKvp(raw);
        GetFeatureType req = WfsFactory.eINSTANCE.createGetFeatureType();
        Object read = this.reader.read((Object)req, parsed, raw);
        GetFeatureType parsedReq = (GetFeatureType)read;
        GetFeatureKvpRequestReaderTest.assertEquals((int)1, (int)parsedReq.getMetadata().size());
        List viewParams = (List)parsedReq.getMetadata().get("GS_SQL_VIEW_PARAMS");
        GetFeatureKvpRequestReaderTest.assertEquals((int)1, (int)viewParams.size());
        Map vp1 = (Map)viewParams.get(0);
        GetFeatureKvpRequestReaderTest.assertEquals((String)"WHERE PERSONS > 1000000", (String)((String)vp1.get("where")));
        GetFeatureKvpRequestReaderTest.assertEquals((String)"ABCD", (String)((String)vp1.get("str")));
    }

    public void testViewParamsMulti() throws Exception {
        HashMap<String, String> raw = new HashMap<String, String>();
        raw.put("service", "WFS");
        raw.put("version", "1.1.0");
        raw.put("request", "GetFeature");
        raw.put("typeName", String.valueOf(this.getLayerId(MockData.STREAMS)) + "," + this.getLayerId(MockData.BASIC_POLYGONS));
        raw.put("viewParams", "where:WHERE PERSONS > 1000000;str:ABCD,where:WHERE PERSONS > 10;str:FOO");
        Map parsed = this.parseKvp(raw);
        GetFeatureType req = WfsFactory.eINSTANCE.createGetFeatureType();
        Object read = this.reader.read((Object)req, parsed, raw);
        GetFeatureType parsedReq = (GetFeatureType)read;
        GetFeatureKvpRequestReaderTest.assertEquals((int)1, (int)parsedReq.getMetadata().size());
        List viewParams = (List)parsedReq.getMetadata().get("GS_SQL_VIEW_PARAMS");
        GetFeatureKvpRequestReaderTest.assertEquals((int)2, (int)viewParams.size());
        Map vp1 = (Map)viewParams.get(0);
        GetFeatureKvpRequestReaderTest.assertEquals((String)"WHERE PERSONS > 1000000", (String)((String)vp1.get("where")));
        GetFeatureKvpRequestReaderTest.assertEquals((String)"ABCD", (String)((String)vp1.get("str")));
        Map vp2 = (Map)viewParams.get(1);
        GetFeatureKvpRequestReaderTest.assertEquals((String)"WHERE PERSONS > 10", (String)((String)vp2.get("where")));
        GetFeatureKvpRequestReaderTest.assertEquals((String)"FOO", (String)((String)vp2.get("str")));
    }

    public void testViewParamsFanOut() throws Exception {
        HashMap<String, String> raw = new HashMap<String, String>();
        raw.put("service", "WFS");
        raw.put("version", "1.1.0");
        raw.put("request", "GetFeature");
        raw.put("typeName", String.valueOf(this.getLayerId(MockData.STREAMS)) + "," + this.getLayerId(MockData.BASIC_POLYGONS));
        raw.put("viewParams", "where:WHERE PERSONS > 1000000;str:ABCD");
        Map parsed = this.parseKvp(raw);
        GetFeatureType req = WfsFactory.eINSTANCE.createGetFeatureType();
        Object read = this.reader.read((Object)req, parsed, raw);
        GetFeatureType parsedReq = (GetFeatureType)read;
        GetFeatureKvpRequestReaderTest.assertEquals((int)1, (int)parsedReq.getMetadata().size());
        List viewParams = (List)parsedReq.getMetadata().get("GS_SQL_VIEW_PARAMS");
        GetFeatureKvpRequestReaderTest.assertEquals((int)2, (int)viewParams.size());
        Map vp1 = (Map)viewParams.get(0);
        GetFeatureKvpRequestReaderTest.assertEquals((String)"WHERE PERSONS > 1000000", (String)((String)vp1.get("where")));
        GetFeatureKvpRequestReaderTest.assertEquals((String)"ABCD", (String)((String)vp1.get("str")));
        Map vp2 = (Map)viewParams.get(1);
        GetFeatureKvpRequestReaderTest.assertEquals((String)"WHERE PERSONS > 1000000", (String)((String)vp2.get("where")));
        GetFeatureKvpRequestReaderTest.assertEquals((String)"ABCD", (String)((String)vp2.get("str")));
    }
}

