/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.v1_1;

import java.net.URLEncoder;
import java.util.Collections;
import javax.xml.namespace.QName;
import junit.textui.TestRunner;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.wfs.GMLInfo;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.WFSTestSupport;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GetFeatureTest
extends WFSTestSupport {
    protected void populateDataDirectory(MockData dataDirectory) throws Exception {
        super.populateDataDirectory(dataDirectory);
        dataDirectory.addPropertiesType(new QName(MockData.SF_URI, "WithGMLProperties", MockData.SF_PREFIX), ((Object)((Object)this)).getClass().getResource("WithGMLProperties.properties"), Collections.EMPTY_MAP);
    }

    public void testGet() throws Exception {
        this.testGetFifteenAll("wfs?request=GetFeature&typename=cdf:Fifteen&version=1.1.0&service=wfs");
    }

    public void testGetPropertyNameEmpty() throws Exception {
        this.testGetFifteenAll("wfs?request=GetFeature&typename=cdf:Fifteen&version=1.1.0&service=wfs&propertyname=");
    }

    public void testGetPropertyNameStar() throws Exception {
        this.testGetFifteenAll("wfs?request=GetFeature&typename=cdf:Fifteen&version=1.1.0&service=wfs&propertyname=*");
    }

    private void testGetFifteenAll(String request) throws Exception {
        Document doc = this.getAsDOM(request);
        GetFeatureTest.assertEquals((String)"wfs:FeatureCollection", (String)doc.getDocumentElement().getNodeName());
        NodeList features = doc.getElementsByTagName("cdf:Fifteen");
        GetFeatureTest.assertFalse((features.getLength() == 0 ? 1 : 0) != 0);
        int i = 0;
        while (i < features.getLength()) {
            Element feature = (Element)features.item(i);
            GetFeatureTest.assertTrue((boolean)feature.hasAttribute("gml:id"));
            ++i;
        }
    }

    public void testGetWithFeatureId() throws Exception {
        Document doc = this.getAsDOM("wfs?request=GetFeature&typeName=cdf:Fifteen&version=1.1.0&service=wfs&featureid=Fifteen.2");
        GetFeatureTest.assertEquals((String)"wfs:FeatureCollection", (String)doc.getDocumentElement().getNodeName());
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wfs:FeatureCollection/gml:featureMembers/cdf:Fifteen)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"Fifteen.2", (String)"//wfs:FeatureCollection/gml:featureMembers/cdf:Fifteen/@gml:id", (Document)doc);
        doc = this.getAsDOM("wfs?request=GetFeature&typeName=cite:NamedPlaces&version=1.1.0&service=wfs&featureId=NamedPlaces.1107531895891");
        GetFeatureTest.assertEquals((String)"wfs:FeatureCollection", (String)doc.getDocumentElement().getNodeName());
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//wfs:FeatureCollection/gml:featureMembers/cite:NamedPlaces)", (Document)doc);
        XMLAssert.assertXpathEvaluatesTo((String)"NamedPlaces.1107531895891", (String)"//wfs:FeatureCollection/gml:featureMembers/cite:NamedPlaces/@gml:id", (Document)doc);
    }

    public void testPost() throws Exception {
        String xml = "<wfs:GetFeature service=\"WFS\" version=\"1.1.0\" xmlns:cdf=\"http://www.opengis.net/cite/data\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" > <wfs:Query typeName=\"cdf:Other\"> <wfs:PropertyName>cdf:string2</wfs:PropertyName> </wfs:Query> </wfs:GetFeature>";
        Document doc = this.postAsDOM("wfs", xml);
        GetFeatureTest.assertEquals((String)"wfs:FeatureCollection", (String)doc.getDocumentElement().getNodeName());
        NodeList features = doc.getElementsByTagName("cdf:Other");
        GetFeatureTest.assertFalse((features.getLength() == 0 ? 1 : 0) != 0);
        int i = 0;
        while (i < features.getLength()) {
            Element feature = (Element)features.item(i);
            GetFeatureTest.assertTrue((boolean)feature.hasAttribute("gml:id"));
            ++i;
        }
    }

    public void testPostFormEncoded() throws Exception {
        String request = "wfs?service=WFS&version=1.1.0&request=GetFeature&typename=sf:PrimitiveGeoFeature&namespace=xmlns(" + URLEncoder.encode("sf=http://cite.opengeospatial.org/gmlsf", "UTF-8") + ")";
        Document doc = this.postAsDOM(request);
        GetFeatureTest.assertEquals((String)"wfs:FeatureCollection", (String)doc.getDocumentElement().getNodeName());
        GetFeatureTest.assertEquals((int)5, (int)doc.getElementsByTagName("sf:PrimitiveGeoFeature").getLength());
    }

    public void testPostWithFilter() throws Exception {
        String xml = "<wfs:GetFeature service=\"WFS\" version=\"1.1.0\" outputFormat=\"text/xml; subtype=gml/3.1.1\" xmlns:cdf=\"http://www.opengis.net/cite/data\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:ogc=\"http://www.opengis.net/ogc\" > <wfs:Query typeName=\"cdf:Other\"> <ogc:Filter> <ogc:PropertyIsEqualTo> <ogc:PropertyName>cdf:integers</ogc:PropertyName> <ogc:Add> <ogc:Literal>4</ogc:Literal> <ogc:Literal>3</ogc:Literal> </ogc:Add> </ogc:PropertyIsEqualTo> </ogc:Filter> </wfs:Query> </wfs:GetFeature>";
        Document doc = this.postAsDOM("wfs", xml);
        GetFeatureTest.assertEquals((String)"wfs:FeatureCollection", (String)doc.getDocumentElement().getNodeName());
        NodeList features = doc.getElementsByTagName("cdf:Other");
        GetFeatureTest.assertFalse((features.getLength() == 0 ? 1 : 0) != 0);
        int i = 0;
        while (i < features.getLength()) {
            Element feature = (Element)features.item(i);
            GetFeatureTest.assertTrue((boolean)feature.hasAttribute("gml:id"));
            ++i;
        }
    }

    public void testPostWithBboxFilter() throws Exception {
        String xml = "<wfs:GetFeature service=\"WFS\" version=\"1.1.0\" outputFormat=\"text/xml; subtype=gml/3.1.1\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:sf=\"http://cite.opengeospatial.org/gmlsf\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:ogc=\"http://www.opengis.net/ogc\" > <wfs:Query typeName=\"sf:PrimitiveGeoFeature\"><ogc:Filter><ogc:BBOX>   <ogc:PropertyName>pointProperty</ogc:PropertyName>   <gml:Envelope srsName=\"EPSG:4326\">      <gml:lowerCorner>57.0 -4.5</gml:lowerCorner>      <gml:upperCorner>62.0 1.0</gml:upperCorner>   </gml:Envelope></ogc:BBOX></ogc:Filter></wfs:Query></wfs:GetFeature>";
        Document doc = this.postAsDOM("wfs", xml);
        GetFeatureTest.assertEquals((String)"wfs:FeatureCollection", (String)doc.getDocumentElement().getNodeName());
        NodeList features = doc.getElementsByTagName("sf:PrimitiveGeoFeature");
        GetFeatureTest.assertEquals((int)1, (int)features.getLength());
    }

    public void testPostWithFailingUrnBboxFilter() throws Exception {
        String xml = "<wfs:GetFeature service=\"WFS\" version=\"1.1.0\" outputFormat=\"text/xml; subtype=gml/3.1.1\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:sf=\"http://cite.opengeospatial.org/gmlsf\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:ogc=\"http://www.opengis.net/ogc\" > <wfs:Query typeName=\"sf:PrimitiveGeoFeature\"><ogc:Filter><ogc:BBOX>   <ogc:PropertyName>pointProperty</ogc:PropertyName>   <gml:Envelope srsName=\"urn:x-ogc:def:crs:EPSG:6.11.2:4326\">      <gml:lowerCorner>57.0 -4.5</gml:lowerCorner>      <gml:upperCorner>62.0 1.0</gml:upperCorner>   </gml:Envelope></ogc:BBOX></ogc:Filter></wfs:Query></wfs:GetFeature>";
        Document doc = this.postAsDOM("wfs", xml);
        GetFeatureTest.assertEquals((String)"wfs:FeatureCollection", (String)doc.getDocumentElement().getNodeName());
        NodeList features = doc.getElementsByTagName("sf:PrimitiveGeoFeature");
        GetFeatureTest.assertEquals((int)0, (int)features.getLength());
    }

    public void testPostWithMatchingUrnBboxFilter() throws Exception {
        String xml = "<wfs:GetFeature service=\"WFS\" version=\"1.1.0\" outputFormat=\"text/xml; subtype=gml/3.1.1\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:sf=\"http://cite.opengeospatial.org/gmlsf\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:ogc=\"http://www.opengis.net/ogc\" > <wfs:Query typeName=\"sf:PrimitiveGeoFeature\"><ogc:Filter><ogc:BBOX>   <ogc:PropertyName>pointProperty</ogc:PropertyName>   <gml:Envelope srsName=\"urn:x-ogc:def:crs:EPSG:6.11.2:4326\">      <gml:lowerCorner>-4.5 57.0</gml:lowerCorner>      <gml:upperCorner>1.0 62.0</gml:upperCorner>   </gml:Envelope></ogc:BBOX></ogc:Filter></wfs:Query></wfs:GetFeature>";
        Document doc = this.postAsDOM("wfs", xml);
        GetFeatureTest.assertEquals((String)"wfs:FeatureCollection", (String)doc.getDocumentElement().getNodeName());
        NodeList features = doc.getElementsByTagName("sf:PrimitiveGeoFeature");
        GetFeatureTest.assertEquals((int)1, (int)features.getLength());
    }

    public void testResultTypeHitsGet() throws Exception {
        Document doc = this.getAsDOM("wfs?request=GetFeature&typename=cdf:Fifteen&version=1.1.0&resultType=hits&service=wfs");
        GetFeatureTest.assertEquals((String)"wfs:FeatureCollection", (String)doc.getDocumentElement().getNodeName());
        NodeList features = doc.getElementsByTagName("cdf:Fifteen");
        GetFeatureTest.assertEquals((int)0, (int)features.getLength());
        GetFeatureTest.assertEquals((String)"15", (String)doc.getDocumentElement().getAttribute("numberOfFeatures"));
    }

    public void testResultTypeHitsPost() throws Exception {
        String xml = "<wfs:GetFeature service=\"WFS\" version=\"1.1.0\" outputFormat=\"text/xml; subtype=gml/3.1.1\" xmlns:cdf=\"http://www.opengis.net/cite/data\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:ogc=\"http://www.opengis.net/ogc\" resultType=\"hits\"> <wfs:Query typeName=\"cdf:Seven\"/> </wfs:GetFeature>";
        Document doc = this.postAsDOM("wfs", xml);
        GetFeatureTest.assertEquals((String)"wfs:FeatureCollection", (String)doc.getDocumentElement().getNodeName());
        NodeList features = doc.getElementsByTagName("cdf:Fifteen");
        GetFeatureTest.assertEquals((int)0, (int)features.getLength());
        GetFeatureTest.assertEquals((String)"7", (String)doc.getDocumentElement().getAttribute("numberOfFeatures"));
    }

    public void testWithSRS() throws Exception {
        String xml = "<wfs:GetFeature xmlns:wfs=\"http://www.opengis.net/wfs\" version=\"1.1.0\" service=\"WFS\"><wfs:Query xmlns:cdf=\"http://www.opengis.net/cite/data\" typeName=\"cdf:Other\" srsName=\"urn:x-ogc:def:crs:EPSG:6.11.2:4326\"/></wfs:GetFeature>";
        Document dom = this.postAsDOM("wfs", xml);
        GetFeatureTest.assertEquals((int)1, (int)dom.getElementsByTagName("cdf:Other").getLength());
    }

    public void testWithSillyLiteral() throws Exception {
        String xml = "<wfs:GetFeature xmlns:cdf=\"http://www.opengis.net/cite/data\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:ogc=\"http://www.opengis.net/ogc\" version=\"1.1.0\" service=\"WFS\"><wfs:Query  typeName=\"cdf:Other\" srsName=\"urn:x-ogc:def:crs:EPSG:6.11.2:4326\"><ogc:Filter>  <ogc:PropertyIsEqualTo>   <ogc:PropertyName>description</ogc:PropertyName>   <ogc:Literal>       <wfs:Native vendorId=\"foo\" safeToIgnore=\"true\"/>   </ogc:Literal>   </ogc:PropertyIsEqualTo> </ogc:Filter></wfs:Query></wfs:GetFeature>";
        Document dom = this.postAsDOM("wfs", xml);
        GetFeatureTest.assertEquals((String)"wfs:FeatureCollection", (String)dom.getDocumentElement().getNodeName());
        GetFeatureTest.assertEquals((int)0, (int)dom.getElementsByTagName("cdf:Other").getLength());
    }

    public void testWithGmlObjectId() throws Exception {
        String xml = "<wfs:GetFeature xmlns:cdf=\"http://www.opengis.net/cite/data\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:ogc=\"http://www.opengis.net/ogc\" version=\"1.1.0\" service=\"WFS\"><wfs:Query  typeName=\"cdf:Seven\" srsName=\"urn:x-ogc:def:crs:EPSG:6.11.2:4326\"></wfs:Query></wfs:GetFeature>";
        Document dom = this.postAsDOM("wfs", xml);
        GetFeatureTest.assertEquals((String)"wfs:FeatureCollection", (String)dom.getDocumentElement().getNodeName());
        GetFeatureTest.assertEquals((int)7, (int)dom.getElementsByTagName("cdf:Seven").getLength());
        NodeList others = dom.getElementsByTagName("cdf:Seven");
        String id = ((Element)others.item(0)).getAttributeNS("http://www.opengis.net/gml", "id");
        GetFeatureTest.assertNotNull((Object)id);
        xml = "<wfs:GetFeature xmlns:cdf=\"http://www.opengis.net/cite/data\" xmlns:wfs=\"http://www.opengis.net/wfs\" xmlns:gml=\"http://www.opengis.net/gml\" xmlns:ogc=\"http://www.opengis.net/ogc\" version=\"1.1.0\" service=\"WFS\"><wfs:Query  typeName=\"cdf:Seven\" srsName=\"urn:x-ogc:def:crs:EPSG:6.11.2:4326\"><ogc:Filter><ogc:GmlObjectId gml:id=\"" + id + "\"/>" + "</ogc:Filter>" + "</wfs:Query>" + "</wfs:GetFeature>";
        dom = this.postAsDOM("wfs", xml);
        GetFeatureTest.assertEquals((int)1, (int)dom.getElementsByTagName("cdf:Seven").getLength());
    }

    public void testPostWithBoundsEnabled() throws Exception {
        WFSInfo wfs = this.getWFS();
        boolean oldFeatureBounding = wfs.isFeatureBounding();
        wfs.setFeatureBounding(true);
        this.getGeoServer().save((ServiceInfo)wfs);
        try {
            String xml = "<wfs:GetFeature service=\"WFS\" version=\"1.1.0\" xmlns:cdf=\"http://www.opengis.net/cite/data\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" > <wfs:Query typeName=\"cdf:Other\"> <wfs:PropertyName>cdf:string2</wfs:PropertyName> </wfs:Query> </wfs:GetFeature>";
            Document doc = this.postAsDOM("wfs", xml);
            GetFeatureTest.assertEquals((String)"wfs:FeatureCollection", (String)doc.getDocumentElement().getNodeName());
            NodeList features = doc.getElementsByTagName("cdf:Other");
            GetFeatureTest.assertFalse((features.getLength() == 0 ? 1 : 0) != 0);
            int i = 0;
            while (i < features.getLength()) {
                Element feature = (Element)features.item(i);
                GetFeatureTest.assertTrue((boolean)feature.hasAttribute("gml:id"));
                NodeList boundList = feature.getElementsByTagName("gml:boundedBy");
                GetFeatureTest.assertEquals((int)1, (int)boundList.getLength());
                Element boundedBy = (Element)boundList.item(0);
                NodeList boxList = boundedBy.getElementsByTagName("gml:Envelope");
                GetFeatureTest.assertEquals((int)1, (int)boxList.getLength());
                Element box = (Element)boxList.item(0);
                GetFeatureTest.assertTrue((boolean)box.hasAttribute("srsName"));
                ++i;
            }
        }
        finally {
            wfs.setFeatureBounding(oldFeatureBounding);
            this.getGeoServer().save((ServiceInfo)wfs);
        }
    }

    public void testAfterFeatureTypeAdded() throws Exception {
        Document dom = this.getAsDOM("wfs?request=getfeature&service=wfs&version=1.1.0&typename=sf:new");
        GetFeatureTest.assertEquals((String)"ExceptionReport", (String)dom.getDocumentElement().getLocalName());
        this.getTestData().addPropertiesType(new QName(MockData.SF_URI, "new", MockData.SF_PREFIX), ((Object)((Object)this)).getClass().getResource("new.properties"), Collections.EMPTY_MAP);
        this.reloadCatalogAndConfiguration();
        dom = this.getAsDOM("wfs?request=getfeature&service=wfs&version=1.1.0&typename=sf:new");
        GetFeatureTest.assertEquals((String)"FeatureCollection", (String)dom.getDocumentElement().getLocalName());
    }

    public void testWithGMLProperties() throws Exception {
        Document dom = this.getAsDOM("wfs?request=getfeature&service=wfs&version=1.1.0&typename=sf:WithGMLProperties");
        GetFeatureTest.assertEquals((String)"FeatureCollection", (String)dom.getDocumentElement().getLocalName());
        NodeList features = dom.getElementsByTagName("sf:WithGMLProperties");
        GetFeatureTest.assertEquals((int)1, (int)features.getLength());
        int i = 0;
        while (i < features.getLength()) {
            Element feature = (Element)features.item(i);
            GetFeatureTest.assertEquals((String)"one", (String)this.getFirstElementByTagName(feature, "gml:name").getFirstChild().getNodeValue());
            GetFeatureTest.assertEquals((String)"1", (String)this.getFirstElementByTagName(feature, "sf:foo").getFirstChild().getNodeValue());
            Element location = this.getFirstElementByTagName(feature, "gml:location");
            GetFeatureTest.assertNotNull((Object)this.getFirstElementByTagName(location, "gml:Point"));
            ++i;
        }
    }

    public void testLayerQualified() throws Exception {
        this.testGetFifteenAll("cdf/Fifteen/wfs?request=GetFeature&typename=cdf:Fifteen&version=1.1.0&service=wfs");
        Document dom = this.getAsDOM("cdf/Seven/wfs?request=GetFeature&typename=cdf:Fifteen&version=1.1.0&service=wfs");
        XMLAssert.assertXpathEvaluatesTo((String)"1", (String)"count(//ows:ExceptionReport)", (Document)dom);
    }

    public void testUserSuppliedNamespacePrefix() throws Exception {
        this.testGetFifteenAll("wfs?request=GetFeature&typename=myPrefix:Fifteen&version=1.1.0&service=wfs&namespace=xmlns(myPrefix%3D" + URLEncoder.encode(MockData.FIFTEEN.getNamespaceURI(), "UTF-8") + ")");
    }

    public void testUserSuppliedDefaultNamespace() throws Exception {
        this.testGetFifteenAll("wfs?request=GetFeature&typename=Fifteen&version=1.1.0&service=wfs&namespace=xmlns(" + URLEncoder.encode(MockData.FIFTEEN.getNamespaceURI(), "UTF-8") + ")");
    }

    public void testGML32OutputFormat() throws Exception {
        this.testGetFifteenAll("wfs?request=getfeature&typename=cdf:Fifteen&version=1.1.0&service=wfs&outputFormat=gml32");
    }

    public void testGMLAttributeMapping() throws Exception {
        WFSInfo wfs = this.getWFS();
        GMLInfo gml = (GMLInfo)wfs.getGML().get(WFSInfo.Version.V_11);
        gml.setOverrideGMLAttributes(Boolean.valueOf(false));
        this.getGeoServer().save((ServiceInfo)wfs);
        Document dom = this.getAsDOM("ows?service=WFS&version=1.1.0&request=GetFeature&typename=" + this.getLayerId(MockData.PRIMITIVEGEOFEATURE));
        XMLAssert.assertXpathExists((String)"//gml:name", (Document)dom);
        XMLAssert.assertXpathExists((String)"//gml:description", (Document)dom);
        XMLAssert.assertXpathNotExists((String)"//sf:name", (Document)dom);
        XMLAssert.assertXpathNotExists((String)"//sf:description", (Document)dom);
        gml.setOverrideGMLAttributes(Boolean.valueOf(true));
        this.getGeoServer().save((ServiceInfo)wfs);
        dom = this.getAsDOM("ows?service=WFS&version=1.1.0&request=GetFeature&typename=" + this.getLayerId(MockData.PRIMITIVEGEOFEATURE));
        XMLAssert.assertXpathNotExists((String)"//gml:name", (Document)dom);
        XMLAssert.assertXpathNotExists((String)"//gml:description", (Document)dom);
        XMLAssert.assertXpathExists((String)"//sf:name", (Document)dom);
        XMLAssert.assertXpathExists((String)"//sf:description", (Document)dom);
    }

    public static void main(String[] args) {
        TestRunner runner = new TestRunner();
        TestRunner.run(GetFeatureTest.class);
    }
}

