/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms.wms_1_1_1;

import java.awt.Color;
import java.awt.image.BufferedImage;
import javax.xml.namespace.QName;
import junit.framework.Test;
import org.geoserver.data.test.MockData;
import org.geoserver.test.OneTimeSetupTest;
import org.geoserver.wms.WMSTestSupport;
import org.geotools.util.Converters;

public class GetLegendGraphicTest
extends WMSTestSupport {
    public static Test suite() {
        return new OneTimeSetupTest.OneTimeTestSetup((OneTimeSetupTest)new GetLegendGraphicTest());
    }

    protected void populateDataDirectory(MockData dataDirectory) throws Exception {
        super.populateDataDirectory(dataDirectory);
        dataDirectory.addStyle("paramFill", GetLegendGraphicTest.class.getResource("paramFill.sld"));
        dataDirectory.addStyle("paramStroke", GetLegendGraphicTest.class.getResource("paramStroke.sld"));
        dataDirectory.addStyle("raster", GetLegendGraphicTest.class.getResource("raster.sld"));
        dataDirectory.addStyle("rasterScales", GetLegendGraphicTest.class.getResource("rasterScales.sld"));
        dataDirectory.addStyle("Population", GetLegendGraphicTest.class.getResource("Population.sld"));
        dataDirectory.addStyle("uom", GetLegendGraphicTest.class.getResource("uomStroke.sld"));
        dataDirectory.addPropertiesType(new QName(MockData.SF_URI, "states", MockData.SF_PREFIX), ((Object)((Object)this)).getClass().getResource("states.properties"), null);
    }

    public void testPlain() throws Exception {
        BufferedImage image = this.getAsImage("wms?service=WMS&version=1.1.1&request=GetLegendGraphic&layer=" + this.getLayerId(MockData.LAKES) + "&style=Lakes" + "&format=image/png&width=20&height=20", "image/png");
        this.assertPixel(image, 10, 10, (Color)Converters.convert((Object)"#4040C0", Color.class));
    }

    public void testEnv() throws Exception {
        String base = "wms?service=WMS&version=1.1.1&request=GetLegendGraphic&layer=" + this.getLayerId(MockData.LAKES) + "&style=paramFill" + "&format=image/png&width=20&height=20";
        BufferedImage image = this.getAsImage(base, "image/png");
        this.assertPixel(image, 10, 10, (Color)Converters.convert((Object)"#FFFFFF", Color.class));
        image = this.getAsImage(String.valueOf(base) + "&env=color:#FF0000", "image/png");
        this.assertPixel(image, 10, 10, (Color)Converters.convert((Object)"#FF0000", Color.class));
    }

    public void testStatesLegend() throws Exception {
        String base = "wms?service=WMS&version=1.1.1&request=GetLegendGraphic&layer=sf:states&style=Population&format=image/png&width=20&height=20";
        BufferedImage image = this.getAsImage(base, "image/png");
        this.assertPixel(image, 10, 10, Color.RED);
        this.assertPixel(image, 10, 30, Color.GREEN);
        this.assertPixel(image, 10, 50, Color.BLUE);
    }

    public void testStatesLegendDpiRescaled() throws Exception {
        String base = "wms?service=WMS&version=1.1.1&request=GetLegendGraphic&layer=sf:states&style=Population&format=image/png&width=20&height=20&legend_options=dpi:180";
        BufferedImage image = this.getAsImage(base, "image/png");
        this.assertPixel(image, 20, 20, Color.RED);
        this.assertPixel(image, 20, 60, Color.GREEN);
        this.assertPixel(image, 20, 100, Color.BLUE);
        Color linePixel = this.getPixelColor(image, 20, 140);
        GetLegendGraphicTest.assertTrue((linePixel.getRed() < 10 ? 1 : 0) != 0);
        GetLegendGraphicTest.assertTrue((linePixel.getGreen() < 10 ? 1 : 0) != 0);
        GetLegendGraphicTest.assertTrue((linePixel.getBlue() < 10 ? 1 : 0) != 0);
    }

    public void testStatesLegendDpiRescaledSingleRule() throws Exception {
        String base = "wms?service=WMS&version=1.1.1&request=GetLegendGraphic&layer=sf:states&style=Population&format=image/png&width=20&height=20&legend_options=dpi:180&rule=2-4M";
        BufferedImage image = this.getAsImage(base, "image/png");
        GetLegendGraphicTest.assertEquals((int)40, (int)image.getWidth());
        GetLegendGraphicTest.assertEquals((int)40, (int)image.getHeight());
        this.assertPixel(image, 20, 20, Color.RED);
    }

    public void testStatesLegendUomRescaled() throws Exception {
        String base = "wms?service=WMS&version=1.1.1&request=GetLegendGraphic&layer=sf:states&style=uom&format=image/png&width=20&height=20&scale=1000000";
        BufferedImage image = this.getAsImage(base, "image/png");
        this.assertPixel(image, 10, 10, Color.BLUE);
        this.assertPixel(image, 5, 10, Color.WHITE);
        this.assertPixel(image, 1, 10, Color.WHITE);
        base = "wms?service=WMS&version=1.1.1&request=GetLegendGraphic&layer=sf:states&style=uom&format=image/png&width=20&height=20&scale=500000";
        image = this.getAsImage(base, "image/png");
        this.assertPixel(image, 10, 10, Color.BLUE);
        this.assertPixel(image, 5, 10, Color.BLUE);
        this.assertPixel(image, 1, 10, Color.WHITE);
    }

    public void testStatesLegendDpiUomRescaled() throws Exception {
        String base = "wms?service=WMS&version=1.1.1&request=GetLegendGraphic&layer=sf:states&style=uom&format=image/png&width=20&height=20&scale=1000000&&legend_options=dpi:180";
        BufferedImage image = this.getAsImage(base, "image/png");
        this.assertPixel(image, 30, 10, Color.BLUE);
        this.assertPixel(image, 20, 20, Color.BLUE);
        this.assertPixel(image, 10, 30, Color.BLUE);
        this.assertPixel(image, 1, 20, Color.WHITE);
    }
}

