/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Point;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import junit.framework.TestCase;
import org.geoserver.platform.ServiceException;
import org.geoserver.wms.MapLayerInfo;
import org.geoserver.wms.WMSMockData;
import org.vfny.geoserver.Request;
import org.vfny.geoserver.wms.GetMapProducer;
import org.vfny.geoserver.wms.requests.GetMapRequest;
import org.vfny.geoserver.wms.responses.GetMapResponse;
import org.vfny.geoserver.wms.responses.map.metatile.MetatileMapProducer;

public class GetMapResponseTest
extends TestCase {
    private WMSMockData mockData;
    private GetMapRequest request;
    private GetMapResponse response;

    protected void setUp() throws Exception {
        GetMapResponse.LOGGER.setLevel(Level.FINEST);
        this.mockData = new WMSMockData();
        this.mockData.setUp();
        this.request = this.mockData.createRequest();
        MapLayerInfo layer = this.mockData.addFeatureTypeLayer("testType", Point.class);
        this.request.setLayers(new MapLayerInfo[]{layer});
        this.response = this.mockData.createResponse();
    }

    protected void tearDown() throws Exception {
        GetMapResponse.LOGGER.setLevel(Level.INFO);
    }

    public void testConstructor() {
        try {
            new GetMapResponse(null);
            GetMapResponseTest.fail((String)"should fail on null list of available producers");
        }
        catch (NullPointerException e) {
            GetMapResponseTest.assertTrue((boolean)true);
        }
        try {
            List producers = Collections.emptyList();
            new GetMapResponse(producers);
            GetMapResponseTest.fail((String)"should fail on empty list of available producers");
        }
        catch (IllegalArgumentException e) {
            GetMapResponseTest.assertTrue((boolean)true);
        }
    }

    public void testDelegateLookup() {
        WMSMockData.DummyRasterMapProducer producer = new WMSMockData.DummyRasterMapProducer();
        this.response = new GetMapResponse(Collections.singleton(producer));
        this.request.setFormat("image/dummy");
        this.response.execute((Request)this.request);
        GetMapProducer delegate = this.response.getDelegate();
        GetMapResponseTest.assertSame((Object)producer, (Object)delegate);
    }

    public void testExecuteNoExtent() {
        this.request.setBbox(null);
        this.assertInvalidMandatoryParam("MissingBBox");
    }

    public void testExecuteEmptyExtent() {
        this.request.setBbox(new Envelope());
        this.assertInvalidMandatoryParam("InvalidBBox");
    }

    public void testExecuteTilingRequested() {
        this.request.setBbox(new Envelope(-180.0, -90.0, 180.0, 90.0));
        this.request.setTiled(true);
        this.request.setTilesOrigin((Point2D)new Point2D.Double(0.0, 0.0));
        this.request.setWidth(256);
        this.request.setHeight(256);
        try {
            this.response.execute((Request)this.request);
            GetMapResponseTest.fail((String)"Expected failure");
        }
        catch (RuntimeException e) {
            GetMapResponseTest.assertTrue((boolean)true);
        }
        GetMapProducer delegate = this.response.getDelegate();
        GetMapResponseTest.assertTrue((boolean)(delegate instanceof MetatileMapProducer));
    }

    public void testSingleVectorLayer() throws IOException {
        WMSMockData.DummyRasterMapProducer producer = new WMSMockData.DummyRasterMapProducer();
        this.response = new GetMapResponse(Collections.singleton(producer));
        this.request.setFormat("image/dummy");
        MapLayerInfo layer = this.mockData.addFeatureTypeLayer("testSingleVectorLayer", Point.class);
        this.request.setLayers(new MapLayerInfo[]{layer});
        this.response.execute((Request)this.request);
        GetMapResponseTest.assertNotNull((Object)producer.mapContext);
        GetMapResponseTest.assertEquals((int)1, (int)producer.mapContext.getLayerCount());
        GetMapResponseTest.assertEquals((String)"image/dummy", (String)producer.outputFormat);
        GetMapResponseTest.assertFalse((boolean)producer.abortCalled);
        GetMapResponseTest.assertTrue((boolean)producer.produceMapCalled);
    }

    public void testExecuteNoLayers() throws Exception {
        this.request.setLayers(null);
        this.assertInvalidMandatoryParam("LayerNotDefined");
    }

    public void testExecuteNoWidth() {
        this.request.setWidth(0);
        this.assertInvalidMandatoryParam("MissingOrInvalidParameter");
        this.request.setWidth(-1);
        this.assertInvalidMandatoryParam("MissingOrInvalidParameter");
    }

    public void testExecuteNoHeight() {
        this.request.setHeight(0);
        this.assertInvalidMandatoryParam("MissingOrInvalidParameter");
        this.request.setHeight(-1);
        this.assertInvalidMandatoryParam("MissingOrInvalidParameter");
    }

    public void testExecuteInvalidFormat() {
        this.request.setFormat("non-existent-output-format");
        this.assertInvalidMandatoryParam("InvalidFormat");
    }

    public void testExecuteNoFormat() {
        this.request.setFormat(null);
        this.assertInvalidMandatoryParam("InvalidFormat");
    }

    public void testExecuteNoStyles() {
        this.request.setStyles(null);
        this.assertInvalidMandatoryParam("StyleNotDefined");
    }

    private void assertInvalidMandatoryParam(String expectedExceptionCode) {
        try {
            this.response.execute((Request)this.request);
            GetMapResponseTest.fail((String)"Expected ServiceException");
        }
        catch (ServiceException e) {
            GetMapResponseTest.assertEquals((String)expectedExceptionCode, (String)e.getCode());
        }
    }
}

