/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.svg;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import junit.framework.Test;
import org.geoserver.test.OneTimeSetupTest;
import org.geoserver.wms.WMSTestSupport;
import org.geotools.data.FeatureSource;
import org.geotools.data.memory.MemoryDataStore;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.styling.Style;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.vfny.geoserver.wms.WMSMapContext;
import org.vfny.geoserver.wms.responses.map.svg.SVGMapProducer;
import org.vfny.geoserver.wms.responses.map.svg.SvgMapProducerProxy;

public class SVGMapProducerTest
extends WMSTestSupport {
    public static Test suite() {
        return new OneTimeSetupTest.OneTimeTestSetup((OneTimeSetupTest)new SVGMapProducerTest());
    }

    public void testHeterogeneousGeometry() throws Exception {
        GeometryFactory gf = new GeometryFactory();
        Point point = gf.createPoint(new Coordinate(10.0, 10.0));
        LineString line = gf.createLineString(new Coordinate[]{new Coordinate(50.0, 50.0), new Coordinate(100.0, 100.0)});
        Polygon polygon = gf.createPolygon(gf.createLinearRing(new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(0.0, 200.0), new Coordinate(200.0, 200.0), new Coordinate(200.0, 0.0), new Coordinate(0.0, 0.0)}), null);
        SimpleFeatureTypeBuilder ftb = new SimpleFeatureTypeBuilder();
        ftb.setName("test");
        ftb.add("geom", Geometry.class);
        SimpleFeatureType type = ftb.buildFeatureType();
        SimpleFeature f1 = SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{point}, null);
        SimpleFeature f2 = SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{line}, null);
        SimpleFeature f3 = SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[]{polygon}, null);
        MemoryDataStore ds = new MemoryDataStore();
        ds.createSchema(type);
        ds.addFeatures(new SimpleFeature[]{f1, f2, f3});
        FeatureSource fs = ds.getFeatureSource("test");
        WMSMapContext map = new WMSMapContext();
        map.setAreaOfInterest(new Envelope(-250.0, 250.0, -250.0, 250.0));
        map.setMapWidth(300);
        map.setMapHeight(300);
        map.setBgColor(Color.red);
        map.setTransparent(false);
        Style basicStyle = this.getCatalog().getStyleByName("Default").getStyle();
        map.addLayer(fs, basicStyle);
        SVGMapProducer producer = new SVGMapProducer("image/svg+xml", SvgMapProducerProxy.OUTPUT_FORMATS);
        producer.setMapContext(map);
        producer.produceMap();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        producer.writeTo((OutputStream)out);
    }
}

