/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wms;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogFactory;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.Wrapper;
import org.geoserver.config.GeoServer;
import org.geoserver.config.util.LegacyServiceLoader;
import org.geoserver.config.util.LegacyServicesReader;
import org.geoserver.wms.WMSInfo;
import org.geoserver.wms.WMSInfoImpl;
import org.geoserver.wms.WatermarkInfo;
import org.geoserver.wms.WatermarkInfoImpl;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.Version;
import org.geotools.util.logging.Logging;

public class WMSLoader
extends LegacyServiceLoader<WMSInfo> {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.wms");

    public Class<WMSInfo> getServiceClass() {
        return WMSInfo.class;
    }

    public WMSInfo load(LegacyServicesReader reader, GeoServer geoServer) throws Exception {
        WMSInfoImpl wms = new WMSInfoImpl();
        wms.setId("wms");
        Map props = reader.wms();
        this.readCommon(wms, props, geoServer);
        WatermarkInfoImpl wm = new WatermarkInfoImpl();
        wm.setEnabled((Boolean)props.get("globalWatermarking"));
        wm.setURL((String)props.get("globalWatermarkingURL"));
        wm.setTransparency((Integer)props.get("globalWatermarkingTransparency"));
        wm.setPosition(WatermarkInfo.Position.get((Integer)props.get("globalWatermarkingPosition")));
        wms.setWatermark(wm);
        try {
            wms.setInterpolation(WMSInfo.WMSInterpolation.valueOf((String)props.get("allowInterpolation")));
        }
        catch (Exception e) {
            wms.setInterpolation(WMSInfo.WMSInterpolation.Nearest);
        }
        wms.getMetadata().put("svgRenderer", (Serializable)props.get("svgRenderer"));
        wms.getMetadata().put("svgAntiAlias", (Serializable)props.get("svgAntiAlias"));
        wms.setMaxBuffer((Integer)props.get("maxBuffer"));
        wms.setMaxRequestMemory((Integer)props.get("maxRequestMemory"));
        wms.setMaxRenderingTime((Integer)props.get("maxRenderingTime"));
        wms.setMaxRenderingErrors((Integer)props.get("maxRenderingErrors"));
        Catalog catalog = geoServer.getCatalog();
        if (catalog instanceof Wrapper) {
            catalog = (Catalog)((Wrapper)catalog).unwrap(Catalog.class);
        }
        CatalogFactory factory = catalog.getFactory();
        List baseMaps = (List)props.get("BaseMapGroups");
        if (baseMaps != null) {
            block2: for (Map baseMap : baseMaps) {
                LayerGroupInfo bm = factory.createLayerGroup();
                bm.setName((String)baseMap.get("baseMapTitle"));
                List layerNames = (List)baseMap.get("baseMapLayers");
                for (String layerName : layerNames) {
                    ResourceInfo resource = null;
                    if (layerName.contains(":")) {
                        String[] qname = layerName.split(":");
                        resource = catalog.getResourceByName(qname[0], qname[1], ResourceInfo.class);
                    } else {
                        resource = catalog.getResourceByName(layerName, ResourceInfo.class);
                    }
                    if (resource == null) {
                        LOGGER.warning("Ignoring layer group '" + bm.getName() + "', resource '" + layerName + "' does not exist");
                        continue block2;
                    }
                    List layers = catalog.getLayers(resource);
                    if (layers.isEmpty()) {
                        LOGGER.warning("Ignoring layer group '" + bm.getName() + "', no layer found for resource '" + layerName + "'");
                        continue block2;
                    }
                    bm.getLayers().add(layers.get(0));
                }
                List styleNames = (List)baseMap.get("baseMapStyles");
                if (styleNames.isEmpty()) {
                    for (LayerInfo l : bm.getLayers()) {
                        bm.getStyles().add(null);
                    }
                } else {
                    for (int i = 0; i < styleNames.size(); ++i) {
                        String styleName = (String)styleNames.get(i);
                        styleName = styleName.trim();
                        StyleInfo style = null;
                        style = "".equals(styleName) ? null : catalog.getStyleByName(styleName);
                        bm.getStyles().add(style);
                    }
                }
                bm.getMetadata().put("rawStyleList", (Serializable)((Object)((String)baseMap.get("rawBaseMapStyles"))));
                ReferencedEnvelope e = (ReferencedEnvelope)baseMap.get("baseMapEnvelope");
                if (e == null) {
                    e = new ReferencedEnvelope();
                    e.setToNull();
                }
                bm.setBounds(e);
                LOGGER.info("Processed layer group '" + bm.getName() + "'");
                catalog.add(bm);
            }
        }
        wms.getVersions().add(new Version("1.1.1"));
        return wms;
    }
}

