/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.config;

import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.geotools.util.SoftValueHashMap;
import org.geotools.util.logging.Logging;
import org.vfny.geoserver.config.PALFileLoader;
import org.vfny.geoserver.global.GeoserverDataDirectory;
import org.vfny.geoserver.wms.responses.palette.InverseColorMapOp;

public class PaletteManager {
    private static final Logger LOG = Logging.getLogger((String)"PaletteManager");
    public static final String SAFE = "SAFE";
    public static final IndexColorModel safePalette = PaletteManager.buildDefaultPalette();
    static SoftValueHashMap paletteCache = new SoftValueHashMap();
    private static InverseColorMapOp safePaletteInversion = new InverseColorMapOp(safePalette);

    private PaletteManager() {
    }

    public static InverseColorMapOp getPalette(String name) throws Exception {
        if (SAFE.equals(name.toUpperCase())) {
            return safePaletteInversion;
        }
        PaletteCacheEntry entry = (PaletteCacheEntry)paletteCache.get((Object)name);
        if (entry != null) {
            if (entry.isStale()) {
                paletteCache.remove((Object)name);
            } else {
                return entry.eicm;
            }
        }
        File root = GeoserverDataDirectory.getGeoserverDataDirectory();
        File paletteDir = GeoserverDataDirectory.findConfigDir((File)root, (String)"palettes");
        final String[] names = new String[]{name + ".gif", name + ".png", name + ".pal", name + ".tif"};
        File[] paletteFiles = paletteDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                for (int i = 0; i < names.length; ++i) {
                    if (!name.toLowerCase().equals(names[i])) continue;
                    return true;
                }
                return false;
            }
        });
        for (int i = 0; i < paletteFiles.length; ++i) {
            File file = paletteFiles[i];
            String fileName = file.getName();
            if (fileName.endsWith("pal")) {
                IndexColorModel icm = new PALFileLoader(file).getIndexColorModel();
                if (icm != null) {
                    InverseColorMapOp eicm = new InverseColorMapOp(icm);
                    paletteCache.put((Object)name, (Object)new PaletteCacheEntry(file, eicm));
                    return eicm;
                }
            } else {
                ImageInputStream iis = ImageIO.createImageInputStream(file);
                Iterator<ImageReader> it = ImageIO.getImageReaders(iis);
                if (it.hasNext()) {
                    ImageReader reader = it.next();
                    reader.setInput(iis);
                    ColorModel cm = reader.getImageTypes(0).next().getColorModel();
                    if (cm instanceof IndexColorModel) {
                        IndexColorModel icm = (IndexColorModel)cm;
                        InverseColorMapOp eicm = new InverseColorMapOp(icm);
                        paletteCache.put((Object)name, (Object)new PaletteCacheEntry(file, eicm));
                        return eicm;
                    }
                }
            }
            LOG.warning("Skipping paletteInverter file " + file.getName() + " since color model is not indexed (no 256 colors paletteInverter)");
        }
        return null;
    }

    static IndexColorModel buildDefaultPalette() {
        int[] cmap = new int[256];
        int i = 0;
        int opaqueAlpha = -16777216;
        for (int r = 0; r < 256; r += 51) {
            for (int g = 0; g < 256; g += 51) {
                for (int b = 0; b < 256; b += 51) {
                    cmap[i] = opaqueAlpha | r << 16 | g << 8 | b;
                    ++i;
                }
            }
        }
        int grayIncr = 256 / (255 - i);
        int gray = 255 - (255 - i - 1) * grayIncr;
        while (i < 255) {
            cmap[i] = opaqueAlpha | gray << 16 | gray << 8 | gray;
            gray += grayIncr;
            ++i;
        }
        cmap[255] = 0xFFFFFF;
        return new IndexColorModel(8, 256, cmap, 0, true, 255, 0);
    }

    private static class PaletteCacheEntry {
        File file;
        long lastModified;
        InverseColorMapOp eicm;

        public PaletteCacheEntry(File file, InverseColorMapOp eicm) {
            this.file = file;
            this.eicm = eicm;
            this.lastModified = file.lastModified();
        }

        public boolean isStale() {
            return !this.file.exists() || this.file.lastModified() != this.lastModified;
        }
    }
}

