/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.legend.jai;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.vfny.geoserver.wms.GetLegendGraphicProducer;
import org.vfny.geoserver.wms.GetLegendGraphicProducerSpi;
import org.vfny.geoserver.wms.responses.helpers.JAISupport;
import org.vfny.geoserver.wms.responses.legend.jai.JaiLegendGraphicProducer;

public class JaiLegendGraphicProducerFactory
implements GetLegendGraphicProducerSpi {
    @Override
    public String getName() {
        return "Legend graphic producer factory for JAI formats";
    }

    @Override
    public Set getSupportedFormats() {
        return JAISupport.getSupportedFormats();
    }

    @Override
    public boolean isAvailable() {
        return JAISupport.isJaiAvailable();
    }

    @Override
    public boolean canProduce(String mimeType) {
        return JAISupport.getSupportedFormats().contains(mimeType);
    }

    @Override
    public GetLegendGraphicProducer createLegendProducer(String format) throws IllegalArgumentException {
        if (!this.canProduce(format)) {
            throw new IllegalArgumentException(format + " not supported by this legend producer");
        }
        return new JaiLegendGraphicProducer(format);
    }

    public Map getImplementationHints() {
        return Collections.EMPTY_MAP;
    }
}

