/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.legend.png;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.vfny.geoserver.wms.GetLegendGraphicProducer;
import org.vfny.geoserver.wms.GetLegendGraphicProducerSpi;
import org.vfny.geoserver.wms.responses.legend.png.PNGLegendGraphicProducer;

public class PNGLegendGraphicProducerFactory
implements GetLegendGraphicProducerSpi {
    @Override
    public String getName() {
        return "Legend graphic producer factory for PNG format";
    }

    @Override
    public Set getSupportedFormats() {
        TreeSet<String> s = new TreeSet<String>();
        s.add("image/png");
        return s;
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public boolean canProduce(String mimeType) {
        return mimeType.equalsIgnoreCase("image/png");
    }

    @Override
    public GetLegendGraphicProducer createLegendProducer(String format) throws IllegalArgumentException {
        if (!this.canProduce(format)) {
            throw new IllegalArgumentException(format + " not supported by this legend producer");
        }
        return new PNGLegendGraphicProducer();
    }

    public Map getImplementationHints() {
        return Collections.EMPTY_MAP;
    }
}

