/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms.responses.map.svg;

import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;
import org.geoserver.platform.ServiceException;
import org.geotools.util.logging.Logging;
import org.vfny.geoserver.wms.GetMapProducer;
import org.vfny.geoserver.wms.WmsException;
import org.vfny.geoserver.wms.responses.AbstractGetMapProducer;
import org.vfny.geoserver.wms.responses.map.svg.EncodeSVG;

class SVGMapProducer
extends AbstractGetMapProducer
implements GetMapProducer {
    private static final Logger LOGGER = Logging.getLogger((String)"org.vfny.geoserver.responses.wms.map");
    private EncodeSVG svgEncoder;

    public SVGMapProducer(String mimeType, String[] outputFormats) {
        super(mimeType, outputFormats);
    }

    @Override
    public void abort() {
        LOGGER.fine("aborting SVG map response");
        if (this.svgEncoder != null) {
            LOGGER.info("aborting SVG encoder");
            this.svgEncoder.abort();
        }
    }

    @Override
    public void produceMap() throws WmsException {
        if (this.mapContext == null) {
            throw new WmsException("The map context is not set");
        }
        this.svgEncoder = new EncodeSVG(this.mapContext);
    }

    @Override
    public void writeTo(OutputStream out) throws ServiceException, IOException {
        this.svgEncoder.encode(out);
    }
}

