/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.wms;

import java.util.List;
import java.util.Set;
import junit.framework.Test;
import org.geoserver.test.OneTimeSetupTest;
import org.geoserver.wms.WMSExtensions;
import org.geoserver.wms.WMSTestSupport;
import org.springframework.context.ApplicationContext;
import org.vfny.geoserver.wms.GetMapProducer;

public class GetMapProducerTest
extends WMSTestSupport {
    public static Test suite() {
        return new OneTimeSetupTest.OneTimeTestSetup((OneTimeSetupTest)new GetMapProducerTest());
    }

    public void testGetOutputFormatNames() {
        List producers = WMSExtensions.findMapProducers((ApplicationContext)applicationContext);
        for (GetMapProducer producer : producers) {
            Set outputFormats = producer.getOutputFormatNames();
            GetMapProducerTest.assertNotNull((Object)outputFormats);
            GetMapProducerTest.assertTrue((outputFormats.size() > 0 ? 1 : 0) != 0);
            for (String oformat : outputFormats) {
                GetMapProducerTest.assertNotNull((Object)oformat);
            }
        }
    }

    public void testGetOutputFormat() {
        List producers = WMSExtensions.findMapProducers((ApplicationContext)applicationContext);
        for (GetMapProducer producer : producers) {
            GetMapProducerTest.assertNotNull((Object)producer.getOutputFormat());
        }
    }

    public void testSetOutputFormat() {
        List producers = WMSExtensions.findMapProducers((ApplicationContext)applicationContext);
        for (GetMapProducer producer : producers) {
            Set outputFormats = producer.getOutputFormatNames();
            for (String outputFormat : outputFormats) {
                producer.setOutputFormat(outputFormat);
                String producerFormat = producer.getOutputFormat();
                String msg = producer.getClass().getName() + " output format not set";
                GetMapProducerTest.assertEquals((String)msg, (String)outputFormat, (String)producerFormat);
            }
            try {
                producer.setOutputFormat("not-a-valid-output-format");
                GetMapProducerTest.fail((String)(producer.getClass().getName() + " didn't throw an IAE when an invalid " + "output format was set"));
            }
            catch (IllegalArgumentException e) {
                GetMapProducerTest.assertTrue((boolean)true);
            }
        }
    }

    public void testSetOutputFormatIsCaseInsensitive() {
        List producers = WMSExtensions.findMapProducers((ApplicationContext)applicationContext);
        for (GetMapProducer producer : producers) {
            Set outputFormats = producer.getOutputFormatNames();
            for (String outputFormat : outputFormats) {
                char caseChangedChar = outputFormat.charAt(0);
                caseChangedChar = Character.isUpperCase(caseChangedChar) ? Character.toLowerCase(caseChangedChar) : Character.toUpperCase(caseChangedChar);
                String caseChangedFormatName = caseChangedChar + outputFormat.substring(1);
                producer.setOutputFormat(caseChangedFormatName);
                String producerFormat = producer.getOutputFormat();
                String msg = producer.getClass().getName() + " output format not set";
                GetMapProducerTest.assertTrue((String)msg, (boolean)outputFormat.equalsIgnoreCase(producerFormat));
            }
        }
    }
}

