/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.demo.jdbc;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import java.util.HashMap;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.h2.tools.DeleteDbFiles;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.spatial.BBOX;

public class JDBCDemo {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        DeleteDbFiles.execute((String)System.getProperty("user.dir"), (String)"acme", (boolean)true);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("dbtype", "h2");
        params.put("database", "acme");
        DataStore ds = DataStoreFinder.getDataStore(params);
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setNamespaceURI("http://acme.com");
        tb.setName("widgets");
        tb.srs("EPSG:4326");
        tb.add("geom", Point.class);
        tb.add("name", String.class);
        tb.add("type", Integer.class);
        tb.add("price", Double.class);
        SimpleFeatureType type = tb.buildFeatureType();
        ds.createSchema((FeatureType)type);
        GeometryFactory gf = new GeometryFactory();
        FeatureWriter fw = ds.getFeatureWriter("widgets", Transaction.AUTO_COMMIT);
        fw.hasNext();
        SimpleFeature f = (SimpleFeature)fw.next();
        f.setAttribute("geom", (Object)gf.createPoint(new Coordinate(1.0, 1.0)));
        f.setAttribute("name", (Object)"foo");
        f.setAttribute("type", (Object)1);
        f.setAttribute("price", (Object)1.1);
        fw.write();
        fw.hasNext();
        f = (SimpleFeature)fw.next();
        f.setAttribute("geom", (Object)gf.createPoint(new Coordinate(10.0, 10.0)));
        f.setAttribute("name", (Object)"bar");
        f.setAttribute("type", (Object)10);
        f.setAttribute("price", (Object)10.1);
        fw.write();
        fw.hasNext();
        f = (SimpleFeature)fw.next();
        f.setAttribute("geom", (Object)gf.createPoint(new Coordinate(20.0, 20.0)));
        f.setAttribute("name", (Object)"foobar");
        f.setAttribute("type", (Object)20);
        f.setAttribute("price", (Object)20.2);
        fw.write();
        fw.close();
        SimpleFeatureSource fs = ds.getFeatureSource("widgets");
        System.out.println("Number of features = " + fs.getCount(Query.ALL));
        FeatureCollection features = fs.getFeatures();
        FeatureIterator fi = features.features();
        try {
            while (fi.hasNext()) {
                f = (SimpleFeature)fi.next();
                System.out.println(f.getID());
            }
        }
        finally {
            features.close(fi);
        }
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        BBOX bbox = ff.bbox("geom", 5.0, 5.0, 15.0, 15.0, "EPSG:4326");
        DefaultQuery q = new DefaultQuery("widgets", (Filter)bbox);
        features = ds.getFeatureSource("widgets").getFeatures((Query)q);
        System.out.println("Number of features = " + features.size());
        fi = features.features();
        try {
            while (fi.hasNext()) {
                f = (SimpleFeature)fi.next();
                System.out.println(f.getID());
            }
        }
        finally {
            features.close(fi);
        }
    }
}

