/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.demo;

import com.vividsolutions.jts.geom.Geometry;
import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.measure.unit.Unit;
import javax.swing.JOptionPane;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.GeoTools;
import org.geotools.swing.data.JFileDataStoreChooser;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class FirstProject {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        System.out.println("Welcome to GeoTools:" + GeoTools.getVersion());
        File file = FirstProject.promptShapeFile(args);
        try {
            HashMap<String, Serializable> connectParameters = new HashMap<String, Serializable>();
            connectParameters.put("url", file.toURI().toURL());
            connectParameters.put("create spatial index", Boolean.valueOf(true));
            DataStore dataStore = DataStoreFinder.getDataStore(connectParameters);
            if (dataStore == null) {
                Logger.getLogger(FirstProject.class.getName()).log(Level.WARNING, "No DataStore found to handle" + file.getPath());
                System.exit(1);
            }
            String[] typeNames = dataStore.getTypeNames();
            String typeName = typeNames[0];
            SimpleFeatureSource featureSource = dataStore.getFeatureSource(typeName);
            SimpleFeatureCollection collection = featureSource.getFeatures();
            SimpleFeatureIterator iterator = collection.features();
            double totalLength = 0.0;
            try {
                while (iterator.hasNext()) {
                    SimpleFeature feature = (SimpleFeature)iterator.next();
                    Geometry geometry = (Geometry)feature.getDefaultGeometry();
                    totalLength += geometry.getLength();
                }
            }
            finally {
                if (iterator != null) {
                    iterator.close();
                }
            }
            String units = "";
            CoordinateReferenceSystem crs = ((SimpleFeatureType)featureSource.getSchema()).getCoordinateReferenceSystem();
            if (crs != null) {
                Unit distanceUnit = crs.getCoordinateSystem().getAxis(0).getUnit();
                units = distanceUnit.toString();
            }
            JOptionPane.showMessageDialog(null, String.format("Total length is %.4f %s", totalLength, units));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    private static File promptShapeFile(String[] args) {
        File file = null;
        if (args.length > 0) {
            file = new File(args[0]);
            if (file.exists()) {
                return file;
            }
            int rtnVal = JOptionPane.showConfirmDialog(null, "Can't find " + file.getName() + ". Choose another ?", "Input shapefile", 0);
            if (rtnVal != 0) {
                return null;
            }
        }
        return JFileDataStoreChooser.showOpenFile((String)"shp", null);
    }
}

