/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.demo;

import java.net.URL;
import java.util.HashMap;
import javax.swing.JOptionPane;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.FeatureSource;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.wfs.WFSDataStoreFactory;
import org.geotools.map.DefaultMapContext;
import org.geotools.map.MapContext;
import org.geotools.swing.JMapFrame;

public class QuickstartWFS {
    public static void main(String[] args) throws Exception {
        String service = JOptionPane.showInputDialog("WFS Capabilities URL", (Object)"http://localhost:8080/geoserver/ows?service=WFS&request=GetCapabilities");
        if (service == null) {
            return;
        }
        URL url = new URL(service);
        HashMap<String, URL> connectionParameters = new HashMap<String, URL>();
        connectionParameters.put(WFSDataStoreFactory.URL.key, url);
        DataStore store = DataStoreFinder.getDataStore(connectionParameters);
        if (store == null) {
            System.out.println("Could not connect to " + url);
            return;
        }
        Object[] selectionValues = store.getTypeNames();
        String typeName = (String)JOptionPane.showInputDialog(null, "Choose FeatureTypes", "WFS Quickstart", 3, null, selectionValues, selectionValues[0]);
        if (typeName == null) {
            return;
        }
        SimpleFeatureSource featureSource = store.getFeatureSource(typeName);
        DefaultMapContext map = new DefaultMapContext();
        map.addLayer((FeatureSource)featureSource, null);
        JMapFrame.showMap((MapContext)map);
    }
}

