/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.demo.coverage;

import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.util.ArrayList;
import java.util.List;
import javax.media.jai.TiledImage;
import javax.media.jai.iterator.RandomIterFactory;
import javax.media.jai.iterator.WritableRandomIter;
import org.geotools.coverage.grid.GridCoordinates2D;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.ViewType;
import org.geotools.geometry.DirectPosition2D;
import org.opengis.coverage.CannotEvaluateException;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.operation.TransformException;

public class WritableGridCoverage2D
extends GridCoverage2D {
    private GridCoverage2D wrapped;
    private static final int MAX_PENDING_VALUES = 10000;
    private List<PendingValue> pendingValues = new ArrayList<PendingValue>();

    public WritableGridCoverage2D(GridCoverage2D grid) {
        super((CharSequence)grid.getName().toString(), grid);
        this.wrapped = grid;
    }

    public Object evaluate(DirectPosition point) throws CannotEvaluateException {
        this.flushCache(true);
        return super.evaluate(point);
    }

    public byte[] evaluate(DirectPosition coord, byte[] dest) throws CannotEvaluateException {
        this.flushCache(true);
        return super.evaluate(coord, dest);
    }

    public int[] evaluate(DirectPosition coord, int[] dest) throws CannotEvaluateException {
        this.flushCache(true);
        return super.evaluate(coord, dest);
    }

    public float[] evaluate(DirectPosition coord, float[] dest) throws CannotEvaluateException {
        this.flushCache(true);
        return super.evaluate(coord, dest);
    }

    public double[] evaluate(DirectPosition coord, double[] dest) throws CannotEvaluateException {
        this.flushCache(true);
        return super.evaluate(coord, dest);
    }

    public int[] evaluate(Point2D coord, int[] dest) throws CannotEvaluateException {
        this.flushCache(true);
        return super.evaluate(coord, dest);
    }

    public float[] evaluate(Point2D coord, float[] dest) throws CannotEvaluateException {
        this.flushCache(true);
        return super.evaluate(coord, dest);
    }

    public double[] evaluate(Point2D coord, double[] dest) throws CannotEvaluateException {
        this.flushCache(true);
        return super.evaluate(coord, dest);
    }

    public int[] evaluate(GridCoordinates2D coord, int[] dest) {
        this.flushCache(true);
        return super.evaluate(coord, dest);
    }

    public float[] evaluate(GridCoordinates2D coord, float[] dest) {
        this.flushCache(true);
        return super.evaluate(coord, dest);
    }

    public double[] evaluate(GridCoordinates2D coord, double[] dest) {
        this.flushCache(true);
        return super.evaluate(coord, dest);
    }

    public GridCoverage2D geophysics(boolean geo) {
        this.flushCache(true);
        return super.geophysics(geo);
    }

    public RenderableImage getRenderableImage(int xAxis, int yAxis) {
        this.flushCache(true);
        return super.getRenderableImage(xAxis, yAxis);
    }

    public RenderedImage getRenderedImage() {
        this.flushCache(true);
        return super.getRenderedImage();
    }

    public boolean isDataEditable() {
        return true;
    }

    public void prefetch(Rectangle2D area) {
    }

    public void show(String title, int xAxis, int yAxis) {
        this.flushCache(true);
        super.show(title, xAxis, yAxis);
    }

    public void show(String title) {
        this.flushCache(true);
        super.show(title);
    }

    public GridCoverage2D view(ViewType type) {
        this.flushCache(true);
        return super.view(type);
    }

    public void setValue(DirectPosition worldPos, int value) {
        this.doSetWorldValue(worldPos, value);
    }

    public void setValue(DirectPosition worldPos, float value) {
        this.doSetWorldValue(worldPos, Float.valueOf(value));
    }

    public void setValue(DirectPosition worldPos, double value) {
        this.doSetWorldValue(worldPos, value);
    }

    public void setValue(GridCoordinates2D gridPos, int value) {
        this.doSetGridValue(gridPos, value);
    }

    public void setValue(GridCoordinates2D gridPos, float value) {
        this.doSetGridValue(gridPos, Float.valueOf(value));
    }

    public void setValue(GridCoordinates2D gridPos, double value) {
        this.doSetGridValue(gridPos, value);
    }

    private void doSetWorldValue(DirectPosition pos, Number value) {
        PendingValue pv = new PendingValue();
        pv.pos = new DirectPosition2D(pos);
        pv.isGeographic = true;
        pv.value = value;
        this.pendingValues.add(pv);
        this.flushCache(false);
    }

    private void doSetGridValue(GridCoordinates2D gridPos, Number value) {
        PendingValue pv = new PendingValue();
        pv.pos = new GridCoordinates2D((Point)gridPos);
        pv.isGeographic = false;
        pv.value = value;
        this.pendingValues.add(pv);
        this.flushCache(false);
    }

    private void flushCache(boolean force) {
        if (this.pendingValues.size() >= 10000 || force && this.pendingValues.size() > 0) {
            WritableRenderedImage writableImage = null;
            writableImage = super.isDataEditable() ? (WritableRenderedImage)this.image : new TiledImage(this.wrapped.getRenderedImage(), true);
            WritableRandomIter writeIter = RandomIterFactory.createWritable((WritableRenderedImage)writableImage, null);
            int dataType = writableImage.getSampleModel().getDataType();
            GridCoordinates2D gridPos = null;
            for (PendingValue pv : this.pendingValues) {
                if (pv.isGeographic) {
                    try {
                        gridPos = this.wrapped.getGridGeometry().worldToGrid((DirectPosition)pv.pos);
                    }
                    catch (TransformException ex) {
                        throw new RuntimeException("Could not transform location [" + pv.pos + "] to grid coords");
                    }
                } else {
                    gridPos = (GridCoordinates2D)pv.pos;
                }
                switch (dataType) {
                    case 3: {
                        writeIter.setSample(gridPos.x, gridPos.y, 0, ((Integer)pv.value).intValue());
                        break;
                    }
                    case 4: {
                        writeIter.setSample(gridPos.x, gridPos.y, 0, ((Float)pv.value).floatValue());
                        break;
                    }
                    case 5: {
                        writeIter.setSample(gridPos.x, gridPos.y, 0, ((Double)pv.value).doubleValue());
                    }
                }
            }
            this.pendingValues.clear();
        }
    }

    private static class PendingValue {
        Object pos;
        boolean isGeographic;
        Object value;

        private PendingValue() {
        }
    }
}

