/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.demo.referencing;

import com.vividsolutions.jts.geom.CoordinateFilter;
import com.vividsolutions.jts.geom.Geometry;
import java.io.File;
import java.net.URL;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.demo.referencing.TransformationCoordinateFilter;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.FeatureTypes;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationFactory;

public class TransformData {
    private static String SOURCE_WKT = "GEOGCS[\"WGS84\", DATUM[\"WGS84\", SPHEROID[\"WGS84\", 6378137.0, 298.257223563]], PRIMEM[\"Greenwich\", 0.0], UNIT[\"degree\",0.017453292519943295], AXIS[\"Longitude\",EAST], AXIS[\"Latitude\",NORTH]]";
    private static String TARGET_WKT = "PROJCS[\"UTM Zone 14N\", GEOGCS[\"WGS84\", DATUM[\"WGS84\", SPHEROID[\"WGS84\", 6378137.0, 298.257223563]], PRIMEM[\"Greenwich\", 0.0], UNIT[\"degree\",0.017453292519943295], AXIS[\"Longitude\",EAST], AXIS[\"Latitude\",NORTH]], PROJECTION[\"Transverse_Mercator\"], PARAMETER[\"central_meridian\", -99.0], PARAMETER[\"latitude_of_origin\", 0.0], PARAMETER[\"scale_factor\", 0.9996], PARAMETER[\"false_easting\", 500000.0], PARAMETER[\"false_northing\", 0.0], UNIT[\"metre\",1.0], AXIS[\"x\",EAST], AXIS[\"y\",NORTH]]";
    private CRSFactory crsFactory = ReferencingFactoryFinder.getCRSFactory(null);
    private CoordinateOperationFactory coFactory = ReferencingFactoryFinder.getCoordinateOperationFactory(null);

    public TransformData(URL inURL, URL outURL, String inWKT, String outWKT) {
        SimpleFeatureCollection fc = null;
        FeatureWriter outFeatureWriter = null;
        try {
            CoordinateReferenceSystem inCRS = this.crsFactory.createFromWKT(inWKT);
            CoordinateReferenceSystem outCRS = this.crsFactory.createFromWKT(outWKT);
            System.out.println("source CRS: " + inCRS.getName().getCode());
            System.out.println("target CRS: " + outCRS.getName().getCode());
            CoordinateOperation co = this.coFactory.createOperation(inCRS, outCRS);
            System.out.println("transform: " + co.getMathTransform().toWKT());
            TransformationCoordinateFilter transFilter = new TransformationCoordinateFilter(co.getMathTransform());
            ShapefileDataStore inStore = new ShapefileDataStore(inURL);
            String name = inStore.getTypeNames()[0];
            SimpleFeatureSource inSource = inStore.getFeatureSource(name);
            fc = inSource.getFeatures();
            SimpleFeatureType inSchema = (SimpleFeatureType)inSource.getSchema();
            ShapefileDataStore outStore = new ShapefileDataStore(outURL);
            outStore.createSchema((FeatureType)FeatureTypes.transform((SimpleFeatureType)inSchema, (CoordinateReferenceSystem)outCRS));
            outFeatureWriter = outStore.getFeatureWriter(outStore.getTypeNames()[0], Transaction.AUTO_COMMIT);
            SimpleFeatureIterator i = fc.features();
            while (i.hasNext()) {
                SimpleFeature inFeature = (SimpleFeature)i.next();
                SimpleFeature outFeature = (SimpleFeature)outFeatureWriter.next();
                for (int j = 0; j < inFeature.getAttributeCount(); ++j) {
                    Object inAttribute = inFeature.getAttribute(j);
                    if (inAttribute instanceof Geometry) {
                        Geometry geom = (Geometry)inAttribute;
                        geom.apply((CoordinateFilter)transFilter);
                        outFeature.setAttribute(j, (Object)geom);
                        continue;
                    }
                    outFeature.setAttribute(j, inAttribute);
                }
                outFeatureWriter.write();
            }
            fc.close((FeatureIterator)i);
            outFeatureWriter.close();
            System.out.println("Done");
        }
        catch (Exception e) {
            System.out.println("Exception: " + e);
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            URL inURL = TransformData.class.getClassLoader().getResource("org/geotools/test-data/shapes/statepop.shp");
            URL outURL = new File(System.getProperty("user.home") + "/statepopTransform.shp").toURI().toURL();
            new TransformData(inURL, outURL, SOURCE_WKT, TARGET_WKT);
        } else if (args.length == 2) {
            URL inURL = new File(args[0]).toURI().toURL();
            URL outURL = new File(args[1]).toURI().toURL();
            new TransformData(inURL, outURL, SOURCE_WKT, TARGET_WKT);
        } else if (args.length == 4) {
            URL inURL = new File(args[0]).toURI().toURL();
            URL outURL = new File(args[1]).toURI().toURL();
            new TransformData(inURL, outURL, args[2], args[4]);
        } else {
            System.out.println("Usage: java TransformData <in file> <out file> <in WKT> <out WKT>");
        }
    }
}

