/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.demo.xml;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.io.WKTReader;
import java.io.OutputStream;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollections;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.kml.KML;
import org.geotools.kml.KMLConfiguration;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.xml.Configuration;
import org.geotools.xml.Encoder;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class KMLExample {
    public static void main(String[] args) throws Exception {
        KMLExample me = new KMLExample();
        me.polygonToKML();
        me.featureCollectionToKML();
    }

    private void polygonToKML() throws Exception {
        GeometryFactory gf = JTSFactoryFinder.getGeometryFactory(null);
        WKTReader reader = new WKTReader(gf);
        Geometry triangle = reader.read("POLYGON((0 0, 10 20, 20 0, 0 0))");
        Encoder encoder = new Encoder((Configuration)new KMLConfiguration());
        encoder.setIndenting(true);
        encoder.encode((Object)triangle, KML.Polygon, (OutputStream)System.out);
    }

    private void featureCollectionToKML() throws Exception {
        SimpleFeatureCollection features = this.createSampleFeatures();
        Encoder encoder = new Encoder((Configuration)new KMLConfiguration());
        encoder.setIndenting(true);
        encoder.encode((Object)features, KML.kml, (OutputStream)System.out);
    }

    private SimpleFeatureCollection createSampleFeatures() {
        SimpleFeatureTypeBuilder typeBuilder = new SimpleFeatureTypeBuilder();
        typeBuilder.setName("cities");
        typeBuilder.add("geometry", Point.class, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        typeBuilder.add("name", String.class);
        typeBuilder.add("country", String.class);
        SimpleFeatureType TYPE = typeBuilder.buildFeatureType();
        SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(TYPE);
        GeometryFactory gf = JTSFactoryFinder.getGeometryFactory(null);
        SimpleFeatureCollection features = FeatureCollections.newCollection();
        featureBuilder.add((Object)gf.createPoint(new Coordinate(12.5, 41.8833)));
        featureBuilder.add((Object)"Rome");
        featureBuilder.add((Object)"Italy");
        features.add((Feature)featureBuilder.buildFeature("1"));
        featureBuilder.add((Object)gf.createPoint(new Coordinate(-74.0, 40.7)));
        featureBuilder.add((Object)"New York");
        featureBuilder.add((Object)"USA");
        features.add((Feature)featureBuilder.buildFeature("2"));
        featureBuilder.add((Object)gf.createPoint(new Coordinate(2.3333, 48.8667)));
        featureBuilder.add((Object)"Paris");
        featureBuilder.add((Object)"France");
        features.add((Feature)featureBuilder.buildFeature("3"));
        featureBuilder.add((Object)gf.createPoint(new Coordinate(-0.0833, 51.5)));
        featureBuilder.add((Object)"London");
        featureBuilder.add((Object)"England");
        features.add((Feature)featureBuilder.buildFeature("4"));
        return features;
    }
}

