/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.demo;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureSource;
import org.geotools.data.postgis.PostgisDataStoreFactory;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.collection.AbstractFeatureVisitor;
import org.geotools.filter.FilterTransformer;
import org.geotools.filter.text.cql2.CQL;
import org.geotools.swing.ProgressWindow;
import org.geotools.swing.data.JDataStoreWizard;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.filter.Filter;
import org.opengis.util.ProgressListener;

public class PostGIS2Example {
    public static void main(String[] args) throws Exception {
        DataStore dataStore = PostGIS2Example.getDatabase(args);
        if (dataStore == null) {
            System.out.println("Could not connect");
            System.exit(0);
        }
        String[] typeNames = dataStore.getTypeNames();
        String typeName = typeNames[0];
        System.out.println("Reading content " + typeName);
        FeatureSource featureSource = dataStore.getFeatureSource(typeName);
        SimpleFeatureType simpleFeatureType = (SimpleFeatureType)featureSource.getSchema();
        System.out.println("Header: " + DataUtilities.spec((FeatureType)simpleFeatureType));
        JQuery dialog = new JQuery(dataStore);
        dialog.setVisible(true);
        dialog.dispose();
        System.exit(0);
    }

    private static DataStore getDatabase(String[] args) throws IOException {
        JDataStoreWizard wizard;
        PostgisDataStoreFactory factory = new PostgisDataStoreFactory();
        if (args.length == 0) {
            wizard = new JDataStoreWizard((DataStoreFactorySpi)factory);
        } else {
            File file = new File(args[0]);
            if (!file.exists()) {
                throw new FileNotFoundException(file.getAbsolutePath());
            }
            FileInputStream input = new FileInputStream(file);
            Properties config = new Properties();
            config.load(input);
            wizard = new JDataStoreWizard((DataStoreFactorySpi)factory, (Map)config);
        }
        int result = wizard.showModalDialog();
        System.out.print("Wizard completed with:");
        switch (result) {
            case 0: {
                break;
            }
            case 1: {
                System.exit(0);
            }
            default: {
                System.exit(1);
            }
        }
        Map properties = wizard.getConnectionParameters();
        wizard.dispose();
        if (properties == null) {
            System.exit(0);
        }
        DataStore dataStore = DataStoreFinder.getDataStore((Map)properties);
        return dataStore;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class JQuery
    extends JDialog {
        final DataStore dataStore;
        JTextArea query;
        JTextArea show;
        JButton selectButton;
        JButton closeButton;
        JComboBox typeNameSelect;
        JButton schemaButton;
        private JButton filterButton;

        JQuery(DataStore database) throws IOException {
            this.dataStore = database;
            this.setTitle("Query");
            this.setModal(true);
            this.setDefaultCloseOperation(1);
            this.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            Vector<String> options = new Vector<String>();
            for (String typeName : this.dataStore.getTypeNames()) {
                options.add(typeName);
            }
            this.typeNameSelect = new JComboBox(options);
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 1;
            c.gridheight = 1;
            c.fill = 2;
            this.add((Component)this.typeNameSelect, c);
            this.schemaButton = new JButton("Describe Schema");
            this.schemaButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        String typeName = (String)JQuery.this.typeNameSelect.getSelectedItem();
                        SimpleFeatureType simpleFeatureType = JQuery.this.dataStore.getSchema(typeName);
                        JQuery.this.display(simpleFeatureType);
                    }
                    catch (Throwable t) {
                        JQuery.this.display(t);
                    }
                }
            });
            c.gridx = -1;
            this.add((Component)this.schemaButton, c);
            this.query = new JTextArea(5, 80);
            c.fill = 2;
            c.gridx = 0;
            c.gridy = 1;
            c.gridwidth = 5;
            c.fill = 1;
            JScrollPane scrollPane1 = new JScrollPane(this.query);
            scrollPane1.setPreferredSize(new Dimension(600, 100));
            this.add((Component)scrollPane1, c);
            this.selectButton = new JButton("Select Features");
            this.selectButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        String text = JQuery.this.query.getText();
                        FeatureCollection<SimpleFeatureType, SimpleFeature> features = JQuery.this.filter(text);
                        JQuery.this.display(features);
                    }
                    catch (Throwable t) {
                        JQuery.this.display(t);
                    }
                }
            });
            c.gridx = 0;
            c.gridy = 2;
            c.gridheight = 1;
            c.gridwidth = 1;
            this.add((Component)this.selectButton, c);
            this.filterButton = new JButton("CQL to Filter 1.0");
            this.filterButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        String text = JQuery.this.query.getText();
                        Filter filter = CQL.toFilter((String)text);
                        JQuery.this.display(filter);
                    }
                    catch (Throwable t) {
                        JQuery.this.display(t);
                    }
                }
            });
            c.gridx = 1;
            this.add((Component)this.filterButton, c);
            this.closeButton = new JButton("Close");
            this.closeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JQuery.this.setVisible(false);
                }
            });
            c.gridx = 3;
            c.gridy = 4;
            this.add((Component)this.closeButton, c);
            this.show = new JTextArea(40, 80);
            this.show.setTabSize(2);
            c.fill = 1;
            c.gridx = 0;
            c.gridy = 3;
            c.gridheight = 1;
            c.gridwidth = 4;
            c.fill = 1;
            JScrollPane scrollPane2 = new JScrollPane(this.show);
            scrollPane2.setPreferredSize(new Dimension(600, 400));
            this.add((Component)scrollPane2, c);
            this.pack();
        }

        protected void display(Filter filter) throws Exception {
            StringBuffer buf = new StringBuffer();
            FilterTransformer transform = new FilterTransformer();
            transform.setIndentation(2);
            String xml = transform.transform(filter);
            this.show.setText(xml);
        }

        public void display(SimpleFeatureType schema) {
            if (schema == null) {
                this.show.setText("");
                return;
            }
            StringBuffer buf = new StringBuffer();
            buf.append("typeName=");
            buf.append(schema.getTypeName());
            buf.append(" namespace=");
            buf.append(schema.getName().getNamespaceURI());
            buf.append("attributes = ([\n");
            for (PropertyDescriptor type : schema.getDescriptors()) {
                buf.append(type.getName().getLocalPart());
                buf.append(" [\n");
                buf.append("\t binding=");
                buf.append(type.getType().getBinding());
                buf.append("\n");
                buf.append("\t minOccurs=");
                buf.append(type.getMinOccurs());
                buf.append(" maxOccurs=");
                buf.append(type.getMaxOccurs());
                buf.append(" nillable=");
                buf.append(type.isNillable());
                buf.append("\n");
                buf.append("\t restrictions=");
                buf.append(type.getType().getRestrictions());
                buf.append("\n");
                if (type instanceof GeometryDescriptor) {
                    GeometryDescriptor geomType = (GeometryDescriptor)type;
                    buf.append("\t crs=");
                    if (geomType.getCoordinateReferenceSystem() == null) {
                        buf.append("null");
                    } else {
                        buf.append(geomType.getCoordinateReferenceSystem().getName());
                    }
                    buf.append("\n");
                }
                buf.append("]\n");
            }
            buf.append(")");
            this.show.setText(buf.toString());
        }

        public FeatureCollection<SimpleFeatureType, SimpleFeature> filter(String text) throws Exception {
            Filter filter = CQL.toFilter((String)text);
            String typeName = (String)this.typeNameSelect.getSelectedItem();
            FeatureSource table = this.dataStore.getFeatureSource(typeName);
            return table.getFeatures(filter);
        }

        protected void display(FeatureCollection<SimpleFeatureType, SimpleFeature> features) throws Exception {
            if (features == null) {
                this.show.setText("");
                return;
            }
            final StringBuffer buf = new StringBuffer();
            final SimpleFeatureType schema = (SimpleFeatureType)features.getSchema();
            buf.append(DataUtilities.spec((FeatureType)schema));
            buf.append("\n");
            features.accepts((FeatureVisitor)new AbstractFeatureVisitor(){

                public void visit(Feature feature) {
                    buf.append(feature.getIdentifier());
                    buf.append(" [\n");
                    for (AttributeDescriptor type : schema.getAttributeDescriptors()) {
                        String name = type.getLocalName();
                        buf.append("\t");
                        buf.append(name);
                        buf.append("=");
                        buf.append(feature.getProperty(name).getValue());
                    }
                    buf.append("]");
                }
            }, (ProgressListener)new ProgressWindow((Component)this));
            this.show.setText(buf.toString());
        }

        public void display(Throwable t) {
            this.show.setText(t.getLocalizedMessage());
            this.show.setForeground(Color.RED);
        }
    }
}

