/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.demo.data;

import com.vividsolutions.jts.geom.Geometry;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.FeatureSource;
import org.geotools.factory.GeoTools;
import org.geotools.feature.FeatureCollection;
import org.geotools.swing.ProgressWindow;
import org.geotools.swing.data.JFileDataStoreChooser;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureVisitor;
import org.opengis.util.ProgressListener;

public class ShapefileRead {
    public static void main(String[] args) throws Exception {
        System.out.println("Welcome to GeoTools:" + GeoTools.getVersion());
        File file = args.length == 0 ? JFileDataStoreChooser.showOpenFile((String)"shp", null) : new File(args[0]);
        if (file == null || !file.exists()) {
            System.exit(1);
        }
        HashMap<String, URL> connect = new HashMap<String, URL>();
        connect.put("url", file.toURI().toURL());
        DataStore dataStore = DataStoreFinder.getDataStore(connect);
        String[] typeNames = dataStore.getTypeNames();
        String typeName = typeNames[0];
        System.out.println("Reading content " + typeName);
        FeatureSource featureSource = dataStore.getFeatureSource(typeName);
        FeatureCollection collection = featureSource.getFeatures();
        class DistanceVisitor
        implements FeatureVisitor {
            int length = 0;

            DistanceVisitor() {
            }

            public void visit(Feature feature) {
                Geometry geometry = (Geometry)feature.getDefaultGeometryProperty().getValue();
                this.length = (int)((double)this.length + geometry.getLength());
            }
        }
        DistanceVisitor distance = new DistanceVisitor();
        collection.accepts((FeatureVisitor)distance, (ProgressListener)new ProgressWindow(null));
        System.out.println("Total length " + distance.length);
    }
}

