/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.demo.coverage;

import java.awt.Color;
import java.awt.image.WritableRaster;
import javax.media.jai.RasterFactory;
import junit.framework.TestCase;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.geometry.Envelope2D;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class FloatRasterDemo
extends TestCase {
    public static void main(String[] args) {
        int width = 500;
        int height = 500;
        WritableRaster raster = RasterFactory.createBandedRaster((int)4, (int)500, (int)500, (int)1, null);
        for (int y = 0; y < 500; ++y) {
            for (int x = 0; x < 500; ++x) {
                raster.setSample(x, y, 0, x + y);
            }
        }
        DefaultGeographicCRS crs = DefaultGeographicCRS.WGS84;
        Envelope2D envelope = new Envelope2D((CoordinateReferenceSystem)crs, 0.0, 0.0, 30.0, 30.0);
        GridCoverageFactory factory = CoverageFactoryFinder.getGridCoverageFactory(null);
        GridCoverage2D gc = factory.create((CharSequence)"My grayscale coverage", raster, (Envelope)envelope);
        gc.show();
        Color[] colors = new Color[]{Color.BLUE, Color.CYAN, Color.WHITE, Color.YELLOW, Color.RED};
        gc = factory.create((CharSequence)"My colored coverage", raster, (Envelope)envelope, null, null, null, (Color[][])new Color[][]{colors}, null);
        gc.geophysics(false).show();
    }

    public void testCoverage() {
        FloatRasterDemo.main(null);
    }
}

