/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.demo.geometry;

import java.awt.RenderingHints;
import java.util.ArrayList;
import org.geotools.factory.Hints;
import org.geotools.geometry.GeometryBuilder;
import org.geotools.geometry.GeometryFactoryFinder;
import org.geotools.geometry.text.WKTParser;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.PositionFactory;
import org.opengis.geometry.aggregate.AggregateFactory;
import org.opengis.geometry.coordinate.GeometryFactory;
import org.opengis.geometry.coordinate.LineString;
import org.opengis.geometry.coordinate.Position;
import org.opengis.geometry.primitive.Curve;
import org.opengis.geometry.primitive.Point;
import org.opengis.geometry.primitive.PrimitiveFactory;
import org.opengis.geometry.primitive.Ring;
import org.opengis.geometry.primitive.Surface;
import org.opengis.geometry.primitive.SurfaceBoundary;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GeometryExample {
    public void createEnvWithFactories() {
        Hints hints = new Hints((RenderingHints.Key)Hints.CRS, (Object)DefaultGeographicCRS.WGS84);
        PositionFactory positionFactory = GeometryFactoryFinder.getPositionFactory((Hints)hints);
        GeometryFactory geometryFactory = GeometryFactoryFinder.getGeometryFactory((Hints)hints);
        DirectPosition upper = positionFactory.createDirectPosition(new double[]{-180.0, -90.0});
        DirectPosition lower = positionFactory.createDirectPosition(new double[]{180.0, 90.0});
        Envelope envelope = geometryFactory.createEnvelope(upper, lower);
        System.out.println(envelope);
    }

    public void createEnvWithGB() {
        GeometryBuilder builder = new GeometryBuilder((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        DirectPosition upper = builder.createDirectPosition(new double[]{-180.0, -90.0});
        DirectPosition lower = builder.createDirectPosition(new double[]{180.0, 90.0});
        Envelope envelope = builder.createEnvelope(upper, lower);
        System.out.println(envelope);
    }

    public void createCurveWithGB() {
        GeometryBuilder builder = new GeometryBuilder((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        DirectPosition start = builder.createDirectPosition(new double[]{48.44, -123.37});
        DirectPosition middle = builder.createDirectPosition(new double[]{47.0, -122.0});
        DirectPosition end = builder.createDirectPosition(new double[]{46.5, -121.5});
        ArrayList<DirectPosition> positions = new ArrayList<DirectPosition>();
        positions.add(start);
        positions.add(middle);
        positions.add(end);
        LineString line = builder.createLineString(positions);
        ArrayList<LineString> segs = new ArrayList<LineString>();
        segs.add(line);
        Curve curve = builder.createCurve(segs);
        System.out.println(curve);
    }

    public void createSurfaceWithGB() {
        GeometryBuilder builder = new GeometryBuilder((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        ArrayList<DirectPosition> dps = new ArrayList<DirectPosition>();
        dps.add(builder.createDirectPosition(new double[]{20.0, 10.0}));
        dps.add(builder.createDirectPosition(new double[]{40.0, 10.0}));
        dps.add(builder.createDirectPosition(new double[]{50.0, 40.0}));
        dps.add(builder.createDirectPosition(new double[]{30.0, 50.0}));
        dps.add(builder.createDirectPosition(new double[]{10.0, 30.0}));
        dps.add(builder.createDirectPosition(new double[]{20.0, 10.0}));
        LineString line = builder.createLineString(dps);
        ArrayList<LineString> segs = new ArrayList<LineString>();
        segs.add(line);
        Curve curve = builder.createCurve(segs);
        ArrayList<Curve> orientableCurves = new ArrayList<Curve>();
        orientableCurves.add(curve);
        Ring extRing = builder.createRing(orientableCurves);
        ArrayList intRings = new ArrayList();
        SurfaceBoundary sb = builder.createSurfaceBoundary(extRing, intRings);
        Surface surface = builder.createSurface(sb);
        System.out.println(surface);
    }

    public void createSurfaceWithFactory() {
        Hints hints = new Hints((RenderingHints.Key)Hints.CRS, (Object)DefaultGeographicCRS.WGS84);
        PositionFactory posF = GeometryFactoryFinder.getPositionFactory((Hints)hints);
        GeometryFactory geomF = GeometryFactoryFinder.getGeometryFactory((Hints)hints);
        PrimitiveFactory primF = GeometryFactoryFinder.getPrimitiveFactory((Hints)hints);
        ArrayList<DirectPosition> dps = new ArrayList<DirectPosition>();
        dps.add(posF.createDirectPosition(new double[]{20.0, 10.0}));
        dps.add(posF.createDirectPosition(new double[]{40.0, 10.0}));
        dps.add(posF.createDirectPosition(new double[]{50.0, 40.0}));
        dps.add(posF.createDirectPosition(new double[]{30.0, 50.0}));
        dps.add(posF.createDirectPosition(new double[]{10.0, 30.0}));
        dps.add(posF.createDirectPosition(new double[]{20.0, 10.0}));
        LineString line = geomF.createLineString(dps);
        ArrayList<LineString> segs = new ArrayList<LineString>();
        segs.add(line);
        Curve curve = primF.createCurve(segs);
        ArrayList<Curve> orientableCurves = new ArrayList<Curve>();
        orientableCurves.add(curve);
        Ring extRing = primF.createRing(orientableCurves);
        ArrayList intRings = new ArrayList();
        SurfaceBoundary sb = primF.createSurfaceBoundary(extRing, intRings);
        Surface surface = primF.createSurface(sb);
        System.out.println(surface);
    }

    public void createPointWithGB() {
        GeometryBuilder builder = new GeometryBuilder((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        Point point = builder.createPoint(48.44, -123.37);
        System.out.println(point);
    }

    public void createPointWithFactory() {
        Hints hints = new Hints((RenderingHints.Key)Hints.CRS, (Object)DefaultGeographicCRS.WGS84);
        PositionFactory positionFactory = GeometryFactoryFinder.getPositionFactory((Hints)hints);
        PrimitiveFactory primitiveFactory = GeometryFactoryFinder.getPrimitiveFactory((Hints)hints);
        DirectPosition here = positionFactory.createDirectPosition(new double[]{48.44, -123.37});
        Point point1 = primitiveFactory.createPoint((Position)here);
        System.out.println(point1);
        Point point2 = primitiveFactory.createPoint(new double[]{48.44, -123.37});
        System.out.println(point2);
    }

    public void createPointWithWKT() throws Exception {
        Hints hints = new Hints((RenderingHints.Key)Hints.CRS, (Object)DefaultGeographicCRS.WGS84);
        PositionFactory positionFactory = GeometryFactoryFinder.getPositionFactory((Hints)hints);
        GeometryFactory geometryFactory = GeometryFactoryFinder.getGeometryFactory((Hints)hints);
        PrimitiveFactory primitiveFactory = GeometryFactoryFinder.getPrimitiveFactory((Hints)hints);
        AggregateFactory aggregateFactory = GeometryFactoryFinder.getAggregateFactory((Hints)hints);
        WKTParser parser = new WKTParser(geometryFactory, primitiveFactory, positionFactory, aggregateFactory);
        Point point = (Point)parser.parse("POINT( 48.44 -123.37)");
        System.out.println(point);
    }

    public static void main(String[] args) throws Exception {
        GeometryExample example = new GeometryExample();
        example.createPointWithGB();
        example.createPointWithFactory();
        example.createPointWithWKT();
        example.createCurveWithGB();
        example.createSurfaceWithGB();
        example.createSurfaceWithFactory();
    }
}

