/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.demo.postgis;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.postgis.PostgisDataStoreFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostGISDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -4773502007868922959L;
    private PostgisDataStoreFactory factory;
    private JParamField database;
    private JParamField dbtype;
    private JParamField host;
    private JParamField port;
    private JParamField schema;
    private JParamField user;
    private JPasswordField password;
    private JButton okay;
    private JButton cancel;
    boolean connect = false;

    public PostGISDialog() {
        this(Collections.EMPTY_MAP);
    }

    public PostGISDialog(Map config) {
        this.setTitle("Connection Parameters");
        this.setModal(true);
        this.dbtype = new JParamField(PostgisDataStoreFactory.DBTYPE, config);
        this.host = new JParamField(PostgisDataStoreFactory.HOST, config);
        this.port = new JParamField(PostgisDataStoreFactory.PORT, config);
        this.schema = new JParamField(PostgisDataStoreFactory.SCHEMA, config);
        this.database = new JParamField(PostgisDataStoreFactory.DATABASE, config);
        this.user = new JParamField(PostgisDataStoreFactory.USER, config);
        this.password = new JPasswordField((String)config.get(PostgisDataStoreFactory.USER.key));
        String description = PostgisDataStoreFactory.PASSWD.description == null ? null : PostgisDataStoreFactory.PASSWD.description.toString();
        this.password.setToolTipText(description);
        this.okay = new JButton("OK");
        this.cancel = new JButton("Cancel");
        this.okay.addActionListener(this);
        this.cancel.addActionListener(this);
        this.setLayout(new GridLayout(0, 2));
        this.add(new JLabel("DBType"));
        this.add(this.dbtype);
        this.add(new JLabel("Host"));
        this.add(this.host);
        this.add(new JLabel("Port"));
        this.add(this.port);
        this.add(new JLabel("Schema"));
        this.add(this.schema);
        this.add(new JLabel("Database"));
        this.add(this.database);
        this.add(new JLabel("user"));
        this.add(this.user);
        this.add(new JLabel("password"));
        this.add(this.password);
        this.add(new JLabel(""));
        JPanel buttons = new JPanel();
        this.add(buttons);
        buttons.add(this.okay);
        buttons.add(this.cancel);
        this.setDefaultCloseOperation(1);
        Dimension preferredSize = this.getPreferredSize();
        preferredSize.height += 30;
        this.setSize(preferredSize);
    }

    public Map<String, Serializable> getProperties() {
        if (!this.connect) {
            return null;
        }
        HashMap<String, Serializable> config = new HashMap<String, Serializable>();
        config.put(PostgisDataStoreFactory.DBTYPE.key, this.dbtype.getValue());
        config.put(PostgisDataStoreFactory.HOST.key, this.host.getValue());
        config.put(PostgisDataStoreFactory.PORT.key, this.port.getValue());
        config.put(PostgisDataStoreFactory.SCHEMA.key, this.schema.getValue());
        config.put(PostgisDataStoreFactory.DATABASE.key, this.database.getValue());
        config.put(PostgisDataStoreFactory.USER.key, this.user.getValue());
        config.put(PostgisDataStoreFactory.PASSWD.key, (Serializable)((Object)this.password.getText()));
        return config;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if ("OK".equals(action)) {
            this.connect = true;
        }
        this.setVisible(false);
    }

    class JParamField
    extends JTextField {
        DataAccessFactory.Param param;
        Serializable value;

        JParamField(DataAccessFactory.Param param) {
            this(param, Collections.EMPTY_MAP);
        }

        JParamField(DataAccessFactory.Param param, Map map) {
            super(14);
            this.param = param;
            this.setValue(map.get(param.key));
            this.addKeyListener(new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    JParamField.this.refresh();
                }
            });
            String description = param.description == null ? null : param.description.toString();
            this.setToolTipText(description);
        }

        public void refresh() {
            try {
                this.value = (Serializable)this.param.parse(this.getText());
                this.setToolTipText(this.param.description.toString());
                this.setForeground(Color.BLACK);
            }
            catch (Throwable e) {
                this.setToolTipText(e.getLocalizedMessage());
                this.setForeground(Color.RED);
                this.value = null;
            }
        }

        public void setValue(Object value) {
            if (value == null) {
                value = this.param.sample;
            }
            this.value = (Serializable)value;
            if (value == null) {
                this.setText("");
            } else {
                this.setText(this.param.text(value));
            }
        }

        public Serializable getValue() {
            return this.value;
        }
    }
}

