/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.demo.xml;

import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.io.StringReader;
import org.geotools.gml.GMLFilterDocument;
import org.geotools.gml.GMLFilterGeometry;
import org.geotools.gml.GMLHandlerGeometry;
import org.geotools.gml.GMLHandlerJTS;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class SAXExample2 {
    static String xml = "<Example xmlns:gml=\"http://www.opengis.net/gml\"><gml:Polygon srsName=\"http://www.opengis.net/gml/srs/EPSG#4326\"><gml:outerBoundaryIs><gml:LinearRing><gml:coordinates>0,0 0,10 10,10 10,0 0,0</gml:coordinates></gml:LinearRing></gml:outerBoundaryIs></gml:Polygon></Example>";

    public static void main(String[] args) throws Exception {
        StringReader reader = new StringReader(xml);
        InputSource input = new InputSource(reader);
        Callback result = SAXExample2.parse(input);
        System.out.println("got:" + result.getGeometry());
    }

    public static Callback parse(InputSource input) throws IOException, SAXException {
        XMLReader reader = XMLReaderFactory.createXMLReader();
        Callback callback = new Callback();
        GMLFilterGeometry geometryCallback = new GMLFilterGeometry((GMLHandlerJTS)callback);
        GMLFilterDocument gmlCallback = new GMLFilterDocument((GMLHandlerGeometry)geometryCallback);
        reader.setContentHandler((ContentHandler)gmlCallback);
        reader.parse(input);
        return callback;
    }

    static class Callback
    extends DefaultHandler
    implements GMLHandlerJTS {
        Geometry geometry = null;

        Callback() {
        }

        public void geometry(Geometry geometry) {
            this.geometry = geometry;
        }

        public Geometry getGeometry() {
            return this.geometry;
        }
    }
}

