/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.demo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.geotools.data.ows.CRSEnvelope;
import org.geotools.data.ows.Layer;
import org.geotools.data.ows.OperationType;
import org.geotools.data.ows.Service;
import org.geotools.data.ows.StyleImpl;
import org.geotools.data.ows.WMSCapabilities;
import org.geotools.data.ows.WMSRequest;
import org.geotools.data.wms.WMSUtils;
import org.geotools.data.wms.WebMapServer;
import org.geotools.data.wms.request.GetLegendGraphicRequest;
import org.geotools.data.wms.request.GetMapRequest;

public class WMSLab2
extends JFrame {
    private static final long serialVersionUID = -3039255518595806472L;
    WebMapServer wms;
    CoveragePanel panel;
    Image image;
    JList layers;
    JButton getMapButton;
    JComboBox styleCombo;
    Map styles = new HashMap();
    Layer selectedLayer = null;
    DefaultComboBoxModel availableStyles;

    public WMSLab2(WebMapServer server) {
        this.wms = server;
        this.setDefaultCloseOperation(3);
        this.setLayout(new BorderLayout());
        String title = this.getWMSTitle(this.wms);
        this.setTitle(title);
        HashSet<Layer> good = new HashSet<Layer>(Arrays.asList(WMSUtils.getNamedLayers((WMSCapabilities)this.wms.getCapabilities())));
        this.layers = new JList<Object>(good.toArray());
        this.layers.setCellRenderer(new LayerCellRenderer());
        this.layers.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                WMSLab2.this.setSelectedLayer((Layer)WMSLab2.this.layers.getSelectedValue());
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.layers);
        scrollPane.setPreferredSize(new Dimension(200, 400));
        this.add((Component)scrollPane, "West");
        this.panel = new CoveragePanel();
        this.add((Component)this.panel, "Center");
        JPanel buttons = new JPanel();
        this.getMapButton = new JButton("GetMap");
        this.getMapButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WMSLab2.this.getMap();
            }
        });
        buttons.add(this.getMapButton);
        this.availableStyles = new DefaultComboBoxModel();
        this.styleCombo = new JComboBox(this.availableStyles);
        this.styleCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (WMSLab2.this.selectedLayer != null) {
                    WMSLab2.this.styles.put(WMSLab2.this.selectedLayer, WMSLab2.this.styleCombo.getSelectedItem());
                }
            }
        });
        this.styleCombo.setRenderer(new StyleCellRenderer());
        buttons.add(this.styleCombo);
        this.add((Component)buttons, "North");
        this.pack();
    }

    public String getWMSTitle(WebMapServer wms) {
        WMSCapabilities capabilities = wms.getCapabilities();
        Service service = capabilities.getService();
        String title = service.getTitle();
        return title;
    }

    public void setSelectedLayer(Layer selected) {
        this.availableStyles.removeAllElements();
        this.selectedLayer = selected;
        if (selected != null) {
            for (StyleImpl style : selected.getStyles()) {
                this.availableStyles.addElement(style);
            }
        }
        this.styleCombo.repaint();
    }

    public Icon getLegendGraphics(Layer layer) {
        Object icon = null;
        WMSCapabilities capabilities = this.wms.getCapabilities();
        WMSRequest request = capabilities.getRequest();
        OperationType description = request.getGetLegendGraphic();
        if (description == null) {
            return null;
        }
        GetLegendGraphicRequest legendGraphicsRequest = this.wms.createGetLegendGraphicRequest();
        legendGraphicsRequest.setLayer(layer.getName());
        legendGraphicsRequest.setStyle(this.getNamedStyle(layer));
        legendGraphicsRequest.setFormat((String)description.getFormats().iterator().next());
        URL url = legendGraphicsRequest.getFinalURL();
        return new ImageIcon(url);
    }

    private String getNamedStyle(Layer layer) {
        Object layerStyle = this.styles.get(layer);
        String namedStyle = null;
        if (layerStyle == null) {
            namedStyle = null;
        } else if (layerStyle instanceof String) {
            namedStyle = (String)layerStyle;
        } else if (layerStyle instanceof StyleImpl) {
            StyleImpl style = (StyleImpl)layerStyle;
            namedStyle = style.getName();
        }
        return namedStyle;
    }

    public void getMap() {
        try {
            Layer selected = (Layer)this.layers.getSelectedValue();
            this.getMap(selected);
            Object[] selection = this.layers.getSelectedValues();
            List<Object> layerList = Arrays.asList(selection);
            this.getMap(layerList);
        }
        catch (Exception e1) {
            this.image = null;
        }
    }

    private void getMap(Layer layer) throws Exception {
        GetMapRequest mapRequest = this.wms.createGetMapRequest();
        String style = this.getNamedStyle(layer);
        mapRequest.addLayer(layer, style);
        mapRequest.setFormat(this.getImageFormat(this.wms));
        CRSEnvelope box = this.getCRSEnvelope(layer, null);
        if (box == null) {
            box = layer.getLatLonBoundingBox();
            box.setEPSGCode("EPSG:4326");
        }
        mapRequest.setSRS(box.getEPSGCode());
        mapRequest.setBBox(box);
        mapRequest.setDimensions(this.panel.getWidth(), this.panel.getHeight());
        URL url = mapRequest.getFinalURL();
        ImageIcon load = new ImageIcon(url);
        this.image = load.getImage();
        this.panel.repaint();
    }

    private void getMap(List layers) throws Exception {
        if (layers == null || layers.isEmpty()) {
            return;
        }
        GetMapRequest mapRequest = this.wms.createGetMapRequest();
        CRSEnvelope bounds = null;
        for (Layer layer : layers) {
            String namedStyle = this.getNamedStyle(layer);
            mapRequest.addLayer(layer, namedStyle);
            CRSEnvelope box = layer.getLatLonBoundingBox();
            box.setEPSGCode("EPSG:4326");
            if (box == null) continue;
            if (bounds != null) {
                bounds.setMinX(Math.min(bounds.getMinX(), box.getMinX()));
                bounds.setMaxX(Math.max(bounds.getMaxX(), box.getMaxX()));
                bounds.setMinY(Math.min(bounds.getMinY(), box.getMinY()));
                bounds.setMaxY(Math.max(bounds.getMaxY(), box.getMaxY()));
                continue;
            }
            bounds = box;
        }
        if (bounds == null) {
            bounds = new CRSEnvelope();
            bounds.setEPSGCode("EPSG:4326");
        }
        mapRequest.setFormat(this.getImageFormat(this.wms));
        mapRequest.setSRS(bounds.getEPSGCode());
        mapRequest.setBBox(bounds);
        mapRequest.setDimensions(this.panel.getWidth(), this.panel.getHeight());
        URL url = mapRequest.getFinalURL();
        ImageIcon load = new ImageIcon(url);
        this.image = load.getImage();
        this.panel.repaint();
    }

    String getImageFormat(WebMapServer wms) {
        OperationType description = wms.getCapabilities().getRequest().getGetMap();
        List formats = description.getFormats();
        for (String format : formats) {
            if (format.indexOf("pdf") != -1) continue;
            return format;
        }
        return "image/jpeg";
    }

    CRSEnvelope getCRSEnvelope(Layer layer, String srs) {
        if (layer == null) {
            return null;
        }
        Map boundingBoxes = layer.getBoundingBoxes();
        if (boundingBoxes != null && !boundingBoxes.isEmpty()) {
            for (Map.Entry entry : boundingBoxes.entrySet()) {
                String layerSrs = (String)entry.getKey();
                CRSEnvelope box = (CRSEnvelope)entry.getValue();
                if (srs != null && !srs.equals(layerSrs)) continue;
                return box;
            }
        }
        return this.getCRSEnvelope(layer.getParent(), srs);
    }

    public static void main(String[] args) throws Exception {
        URL server = WMSLab2.getServerURL(args);
        System.out.println("Connecting to " + server);
        WebMapServer wms = new WebMapServer(server);
        System.out.println("Welcome");
        WMSLab2 wmsLab = new WMSLab2(wms);
        wmsLab.setVisible(true);
    }

    public static String[] getLayerNames(WebMapServer wms) {
        Layer[] namedLayers = WMSUtils.getNamedLayers((WMSCapabilities)wms.getCapabilities());
        String[] names = new String[namedLayers.length];
        for (int i = 0; i < namedLayers.length; ++i) {
            Layer layer = namedLayers[i];
            names[i] = layer.getName();
        }
        return names;
    }

    public static URL getServerURL(String[] args) throws MalformedURLException {
        if (args.length == 0) {
            Object[] servers = new Object[]{"http://localhost:8080/geoserver/wms?service=WMS&request=GetCapabilities", "http://www2.dmsolutions.ca/cgi-bin/mswms_gmap?Service=WMS&VERSION=1.1.0&REQUEST=GetCapabilities", "http://wms.jpl.nasa.gov/wms.cgi?Service=WMS&Version=1.1.1&Request=GetCapabilities", "http://giswebservices.massgis.state.ma.us/geoserver/wms?service=WMS&request=GetCapabilities", "http://wms.cits.rncan.gc.ca/cgi-bin/cubeserv.cgi?VERSION=1.1.0&REQUEST=GetCapabilities", "http://atlas.gc.ca/cgi-bin/atlaswms_en?VERSION=1.1.1&Request=GetCapabilities&Service=WMS"};
            Object selected = JOptionPane.showInputDialog(null, "WMS GetCapabilities URL", "Choose a WMS Server", 3, null, servers, null);
            if (selected == null) {
                System.exit(0);
            }
            return new URL((String)selected);
        }
        return new URL(args[0]);
    }

    class CoveragePanel
    extends JPanel {
        private static final long serialVersionUID = -4755270758709990530L;

        CoveragePanel() {
            this.setBackground(Color.WHITE);
        }

        public Dimension getPreferredSize() {
            return new Dimension(640, 400);
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponents(graphics);
            if (WMSLab2.this.image != null) {
                Graphics2D g = (Graphics2D)graphics;
                g.drawImage(WMSLab2.this.image, 0, 0, null);
            }
        }
    }

    class LayerCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1173012107250651733L;
        HashMap icons = new HashMap();

        LayerCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean iss, boolean chf) {
            Icon glyph;
            super.getListCellRendererComponent((JList<?>)list, value, index, iss, chf);
            Layer layer = (Layer)value;
            this.setText(layer.getTitle());
            if (this.icons.containsKey(layer)) {
                glyph = (Icon)this.icons.get(layer);
            } else {
                glyph = WMSLab2.this.getLegendGraphics(layer);
                this.icons.put(layer, glyph);
            }
            this.setIcon(glyph);
            this.setToolTipText(layer.getName());
            return this;
        }
    }

    class StyleCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 7421698429520525469L;

        StyleCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean iss, boolean chf) {
            super.getListCellRendererComponent((JList<?>)list, value, index, iss, chf);
            StyleImpl style = (StyleImpl)value;
            if (style == null) {
                return this;
            }
            String title = style.getTitle() == null ? style.getName() : style.getTitle().toString();
            this.setText(title);
            return this;
        }

        Icon getIcon(StyleImpl style) {
            List urlList = style.getLegendURLs();
            if (urlList == null || urlList.isEmpty()) {
                return null;
            }
            URL url = (URL)style.getLegendURLs().get(0);
            ImageIcon icon = new ImageIcon(url);
            return icon;
        }
    }
}

