/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.demo.process;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Collections;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.feature.FeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.DefaultMapContext;
import org.geotools.map.MapContext;
import org.geotools.process.raster.RasterToVectorProcess;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.styling.SLD;
import org.geotools.styling.Style;
import org.geotools.swing.JMapFrame;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class RasterToVector {
    public static void main(String[] args) throws Exception {
        new RasterToVector().demo();
    }

    private void demo() throws Exception {
        ReferencedEnvelope env = new ReferencedEnvelope(0.0, 8.0, 0.0, 8.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        GridCoverage2D cov = this.createChessboardCoverage(256, 256, 32, env);
        FeatureCollection fc = RasterToVectorProcess.process((GridCoverage2D)cov, (int)0, (Envelope)env, Collections.singletonList(0.0), null);
        DefaultMapContext map = new DefaultMapContext();
        map.setTitle("raster to vector conversion");
        Style style = SLD.createPolygonStyle((Color)Color.BLUE, (Color)Color.CYAN, (float)1.0f);
        map.addLayer(fc, style);
        JMapFrame.showMap((MapContext)map);
    }

    private GridCoverage2D createChessboardCoverage(int imgWidth, int imgHeight, int squareWidth, ReferencedEnvelope env) {
        GridCoverageFactory factory = CoverageFactoryFinder.getGridCoverageFactory(null);
        GridCoverage2D cov = factory.create((CharSequence)"chessboard", this.createChessboardImage(imgWidth, imgHeight, squareWidth), (Envelope)env);
        return cov;
    }

    private RenderedImage createChessboardImage(int imgWidth, int imgHeight, int squareWidth) {
        BufferedImage img = new BufferedImage(imgWidth, imgHeight, 12);
        WritableRaster raster = img.getRaster();
        for (int y = 0; y < imgHeight; ++y) {
            boolean oddRow = y / squareWidth % 2 == 1;
            for (int x = 0; x < imgWidth; ++x) {
                boolean oddCol = x / squareWidth % 2 == 1;
                raster.setSample(x, y, 0, oddCol == oddRow ? 1 : 0);
            }
        }
        return img;
    }
}

