/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.demo.libraryJTS;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.IntersectionMatrix;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.io.WKTWriter;

public class DemoJTS {
    public static void main(String[] args) {
        System.out.println("Start of the output for the tutorial: DemoJTS.\n");
        System.out.println("PART I: Coordinates from scratch");
        Coordinate ptc = new Coordinate(14.0, 14.0);
        System.out.println("The Coordinate is:            " + ptc);
        Coordinate[] lsc = new Coordinate[]{new Coordinate(5.0, 5.0), new Coordinate(6.0, 5.0), new Coordinate(6.0, 6.0), new Coordinate(7.0, 6.0), new Coordinate(7.0, 7.0), new Coordinate(8.0, 7.0), new Coordinate(8.0, 8.0), new Coordinate(9.0, 9.0)};
        Coordinate[] pgc = new Coordinate[]{new Coordinate(7.0, 7.0), new Coordinate(6.0, 9.0), new Coordinate(6.0, 11.0), new Coordinate(7.0, 12.0), new Coordinate(9.0, 11.0), new Coordinate(11.0, 12.0), new Coordinate(13.0, 11.0), new Coordinate(13.0, 9.0), new Coordinate(11.0, 7.0), new Coordinate(7.0, 7.0)};
        System.out.println("\nPART II: Envelopes from scratch and operations");
        Envelope e1 = new Envelope(8.0, 20.0, 4.0, 12.0);
        Envelope e2 = new Envelope(new Coordinate(12.0, 6.0), new Coordinate(16.0, 16.0));
        System.out.println("The first Envelope is:       " + e1);
        System.out.println("It contains the coordinate?  " + e1.contains(ptc));
        System.out.println("Does the second?             " + e2.contains(ptc));
        Envelope e1prime = new Envelope(e1);
        e1prime.expandToInclude(ptc);
        System.out.println("The first Envelope expanded  " + e1prime);
        System.out.println("Two Envelopes intersected    " + e1.intersection(e2));
        System.out.println("\nPART III: Geometries from Coordinates");
        GeometryFactory geomFac = new GeometryFactory();
        Point ptG = geomFac.createPoint(ptc);
        LineString lnG = geomFac.createLineString(lsc);
        LinearRing rgG = geomFac.createLinearRing(pgc);
        Polygon pgG = geomFac.createPolygon(rgG, null);
        System.out.println("The point is:                " + ptG);
        System.out.println("The line string is:          " + lnG);
        System.out.println("The linear ring is:          " + rgG);
        System.out.println("The polygon is:              " + pgG);
        System.out.println("\nPART IV: Geometry Creation from WKT");
        Geometry lnGwkt = null;
        try {
            lnGwkt = new WKTReader().read("LINESTRING (0 0, 30 30, 0 7, 5 10)");
        }
        catch (ParseException pe) {
            System.out.println("Couldn't parse the linestring");
        }
        System.out.print("The WKT line string is:      ");
        WKTWriter wrt = new WKTWriter();
        String str = wrt.write(lnGwkt);
        System.out.println(str);
        System.out.println(" or with one statement:      " + new WKTWriter().write(lnGwkt));
        System.out.println("\nPART V: Geometry Comparisons");
        Coordinate cNew = new Coordinate(14.000001, 14.0, 3.0);
        Point ptNew = geomFac.createPoint(cNew);
        System.out.println("Are the pt geometries equal? " + ptG.equals((Geometry)ptNew));
        System.out.println(" exactly equal?              " + ptG.equalsExact((Geometry)ptNew));
        System.out.println(" near to exactly equal?      " + ptG.equalsExact((Geometry)ptNew, 1.0E-10));
        System.out.println(" inexactly equal?            " + ptG.equalsExact((Geometry)ptNew, 0.001));
        Geometry g_one = null;
        Geometry g_two = null;
        try {
            g_one = new WKTReader().read("LINESTRING (0 0, 10 10, 0 20, 0 0)");
            g_two = new WKTReader().read("LINESTRING (10 10, 0 20, 0 0, 10 10)");
        }
        catch (ParseException pe) {
            System.out.println("Couldn't parse the linestring");
        }
        System.out.println("Are the triangles equal?     " + g_one.equals(g_two));
        System.out.println("Do the envelopes overalp?    " + lnG.getEnvelope().overlaps(pgG.getEnvelope()));
        System.out.println("Do the convex hulls overalp? " + lnG.convexHull().overlaps(pgG.convexHull()));
        System.out.println("Do the geometries overalp?   " + lnG.overlaps((Geometry)pgG));
        System.out.println("\nPART VI: Geometry Operations");
        System.out.println("Does it self intersect?      " + lnGwkt.isSimple());
        System.out.println("Line strings intersection:   " + lnGwkt.intersection((Geometry)lnG));
        System.out.println("Line, polygon intersection:  " + lnG.intersects((Geometry)pgG));
        System.out.println("Union of two LineStrings:    " + lnG.union(lnGwkt));
        System.out.println("\nPART VII: Operations on Geometry Sets");
        System.out.println("...TODO...");
        System.out.println("\nEnd of the tutorial output.");
        System.out.println("Testing...");
    }

    public static void codeExample(Geometry fire, Geometry cities, Geometry me, Geometry he, Geometry you) {
        Geometry smoke = fire.buffer(10.0);
        Geometry evacuate = cities.intersection(smoke);
        boolean onFire = me.intersects(fire);
        boolean thatIntoYou = he.disjoint(you);
        boolean run = you.isWithinDistance(fire, 2.0);
        IntersectionMatrix matrix = he.relate(you);
        thatIntoYou = matrix.isDisjoint();
        boolean disjoint = matrix.matches("FF*FF****");
    }
}

