/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.svg;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2D;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.MapContext;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.util.logging.Logging;
import org.w3c.dom.Document;

public class GenerateSVG {
    private static Logger LOGGER = Logging.getLogger((String)"org.geotools.svgsupport");
    private Dimension canvasSize = new Dimension(300, 300);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void go(MapContext map, Envelope env, OutputStream out) throws IOException, ParserConfigurationException {
        SVGGeneratorContext ctx = this.setupContext();
        ctx.setComment("Generated by GeoTools2 with Batik SVG Generator");
        SVGGraphics2D g2d = new SVGGraphics2D(ctx, true);
        g2d.setSVGCanvasSize(this.getCanvasSize());
        this.renderMap(map, env, g2d);
        LOGGER.finest("writing to file");
        OutputStreamWriter osw = null;
        try {
            osw = new OutputStreamWriter(out, "UTF-8");
            g2d.stream((Writer)osw);
        }
        finally {
            if (osw != null) {
                osw.close();
            }
        }
    }

    private void renderMap(MapContext map, Envelope env, SVGGraphics2D g2d) throws IOException {
        StreamingRenderer renderer = new StreamingRenderer();
        renderer.setContext(map);
        Rectangle outputArea = new Rectangle(g2d.getSVGCanvasSize());
        ReferencedEnvelope dataArea = map.getLayerBounds();
        LOGGER.finest("rendering map");
        renderer.paint((Graphics2D)g2d, outputArea, (Envelope)dataArea);
    }

    private SVGGeneratorContext setupContext() throws FactoryConfigurationError, ParserConfigurationException {
        Document document = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        document = db.getDOMImplementation().createDocument(null, "svg", null);
        SVGGeneratorContext ctx = SVGGeneratorContext.createDefault((Document)document);
        return ctx;
    }

    public Dimension getCanvasSize() {
        return this.canvasSize;
    }

    public void setCanvasSize(Dimension size) {
        this.canvasSize = size;
    }
}

