/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.raster.gce;

import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.media.jai.ImageLayout;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.FormatDescriptor;
import javax.media.jai.operator.MosaicDescriptor;
import org.geotools.arcsde.raster.gce.ArcSDERasterFormat;
import org.geotools.arcsde.raster.info.RasterDatasetInfo;
import org.geotools.arcsde.raster.info.RasterQueryInfo;
import org.geotools.arcsde.raster.info.RasterUtils;
import org.geotools.arcsde.raster.io.RasterReaderFactory;
import org.geotools.arcsde.raster.io.TiledRasterReader;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.TypeMap;
import org.geotools.coverage.grid.GeneralGridEnvelope;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.OverviewPolicy;
import org.geotools.data.DefaultServiceInfo;
import org.geotools.data.ServiceInfo;
import org.geotools.factory.Hints;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.ColorInterpretation;
import org.opengis.coverage.grid.Format;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArcSDEGridCoverage2DReaderJAI
extends AbstractGridCoverage2DReader {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.arcsde.gce");
    private static final boolean DEBUG_TO_DISK = Boolean.getBoolean("org.geotools.arcsde.gce.debug");
    private final ArcSDERasterFormat parent;
    private final RasterDatasetInfo rasterInfo;
    private DefaultServiceInfo serviceInfo;
    private RasterReaderFactory rasterReaderFactory;

    public ArcSDEGridCoverage2DReaderJAI(ArcSDERasterFormat parent, RasterReaderFactory rasterReaderFactory, RasterDatasetInfo rasterInfo, Hints hints) throws IOException {
        int bitsPerSample = rasterInfo.getBand(0, 0).getCellType().getBitsPerSample();
        if (rasterInfo.getNumBands() > 1 && (bitsPerSample == 1 || bitsPerSample == 4)) {
            throw new IllegalArgumentException(bitsPerSample + "-bit rasters with more than one band are not supported");
        }
        this.parent = parent;
        this.rasterReaderFactory = rasterReaderFactory;
        this.rasterInfo = rasterInfo;
        this.hints = hints;
        this.coverageFactory = CoverageFactoryFinder.getGridCoverageFactory((Hints)this.hints);
        this.crs = rasterInfo.getCoverageCrs();
        this.originalEnvelope = rasterInfo.getOriginalEnvelope();
        GeneralGridEnvelope gridRange = rasterInfo.getOriginalGridRange();
        this.originalGridRange = new GridEnvelope2D(gridRange.toRectangle());
        this.coverageName = rasterInfo.getRasterTable();
        int numLevels = rasterInfo.getNumPyramidLevels(0);
        this.numOverviews = numLevels - 1;
        this.highestRes = AbstractGridCoverage2DReader.getResolution((GeneralEnvelope)this.originalEnvelope, (Rectangle2D)((Rectangle)this.originalGridRange), (CoordinateReferenceSystem)this.crs);
        if (this.numOverviews > 0) {
            this.overViewResolutions = new double[this.numOverviews][2];
            for (int pyramidLevel = 1; pyramidLevel <= this.numOverviews; ++pyramidLevel) {
                Rectangle levelGridRange = rasterInfo.getGridRange(0, pyramidLevel);
                GeneralEnvelope levelEnvelope = rasterInfo.getGridEnvelope(0, pyramidLevel);
                this.overViewResolutions[pyramidLevel - 1] = AbstractGridCoverage2DReader.getResolution((GeneralEnvelope)levelEnvelope, (Rectangle2D)levelGridRange, (CoordinateReferenceSystem)this.crs);
            }
        } else {
            this.overViewResolutions = null;
        }
    }

    public Format getFormat() {
        return this.parent;
    }

    public ServiceInfo getInfo() {
        if (this.serviceInfo == null) {
            this.serviceInfo = new DefaultServiceInfo();
            this.serviceInfo.setTitle(this.rasterInfo.getRasterTable());
            this.serviceInfo.setDescription(this.rasterInfo.toString());
            HashSet<String> keywords = new HashSet<String>();
            keywords.add("ArcSDE");
            this.serviceInfo.setKeywords(keywords);
        }
        return this.serviceInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GridCoverage2D read(GeneralParameterValue[] params) throws IOException {
        ReadParameters opParams = ArcSDEGridCoverage2DReaderJAI.parseReadParams(this.getOriginalEnvelope(), params);
        GeneralEnvelope requestedEnvelope = opParams.requestedEnvelope;
        Rectangle requestedDim = opParams.dim;
        OverviewPolicy overviewPolicy = opParams.overviewPolicy;
        List<RasterQueryInfo> queries = this.findMatchingRasters(requestedEnvelope, requestedDim, overviewPolicy);
        if (queries.isEmpty()) {
            return null;
        }
        GeneralEnvelope resultEnvelope = this.getResultEnvelope(queries);
        LoggingHelper log = new LoggingHelper();
        log.appendLoggingGeometries(LoggingHelper.REQ_ENV, requestedEnvelope);
        log.appendLoggingGeometries(LoggingHelper.RES_ENV, resultEnvelope);
        Rectangle mosaicGeometry = RasterUtils.setMosaicLocations(this.rasterInfo, resultEnvelope, queries);
        if (mosaicGeometry.width == 0 || mosaicGeometry.height == 0) {
            LOGGER.finer("Mosaic geometry width or height is zero, returning fake coverage for pixels " + mosaicGeometry);
            return null;
        }
        TiledRasterReader rasterReader = this.rasterReaderFactory.create(this.rasterInfo);
        this.readAllTiledRasters(queries, rasterReader, log);
        log.log(LoggingHelper.REQ_ENV);
        log.log(LoggingHelper.RES_ENV);
        log.log(LoggingHelper.MOSAIC_ENV);
        log.log(LoggingHelper.MOSAIC_EXPECTED);
        RenderedImage coverageRaster = this.createMosaic(queries, mosaicGeometry, log);
        assert (mosaicGeometry.getWidth() == (double)coverageRaster.getWidth());
        assert (mosaicGeometry.getHeight() == (double)coverageRaster.getHeight());
        GridSampleDimension[] bands = this.getSampleDimensions(coverageRaster);
        GridCoverage2D resultCoverage = this.coverageFactory.create((CharSequence)this.coverageName, coverageRaster, (Envelope)resultEnvelope, bands, null, null);
        return resultCoverage;
    }

    private GridSampleDimension[] getSampleDimensions(RenderedImage coverageRaster) throws IOException {
        GridSampleDimension[] bands = this.rasterInfo.getGridSampleDimensions();
        int imageBands = coverageRaster.getSampleModel().getNumBands();
        if (bands.length == 1 && imageBands > 1) {
            LOGGER.fine(this.coverageName + " was promoted from 1 to " + coverageRaster.getSampleModel().getNumBands() + " bands, returning an appropriate set of GridSampleDimension");
            ColorModel cm = coverageRaster.getColorModel();
            bands = new GridSampleDimension[imageBands];
            for (int i = 0; i < imageBands; ++i) {
                ColorInterpretation colorInterpretation = TypeMap.getColorInterpretation((ColorModel)cm, (int)i);
                if (colorInterpretation == null) {
                    throw new IOException("Unrecognized sample dimension type");
                }
                bands[i] = new GridSampleDimension((CharSequence)colorInterpretation.name()).geophysics(true);
            }
        }
        return bands;
    }

    private void readAllTiledRasters(List<RasterQueryInfo> queries, TiledRasterReader rasterReader, LoggingHelper log) throws IOException {
        for (RasterQueryInfo queryInfo : queries) {
            RenderedImage rasterImage;
            Long rasterId = queryInfo.getRasterId();
            try {
                int pyramidLevel = queryInfo.getPyramidLevel();
                Rectangle matchingTiles = queryInfo.getMatchingTiles();
                rasterImage = rasterReader.read(rasterId, pyramidLevel, matchingTiles);
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Fetching data for " + queryInfo.toString(), e);
                throw e;
            }
            queryInfo.setResultImage(rasterImage);
            LOGGER.finer(queryInfo.toString());
            log.appendLoggingGeometries(LoggingHelper.MOSAIC_EXPECTED, queryInfo.getMosaicLocation());
            log.appendLoggingGeometries(LoggingHelper.MOSAIC_ENV, queryInfo.getResultEnvelope());
        }
    }

    private List<RasterQueryInfo> findMatchingRasters(GeneralEnvelope requestedEnvelope, Rectangle requestedDim, OverviewPolicy overviewPolicy) {
        List<RasterQueryInfo> matchingQueries = RasterUtils.findMatchingRasters(this.rasterInfo, requestedEnvelope, requestedDim, overviewPolicy);
        if (matchingQueries.isEmpty()) {
            return matchingQueries;
        }
        for (RasterQueryInfo match : matchingQueries) {
            RasterUtils.fitRequestToRaster(requestedEnvelope, this.rasterInfo, match);
        }
        return matchingQueries;
    }

    private GeneralEnvelope getResultEnvelope(List<RasterQueryInfo> queryInfos) {
        GeneralEnvelope finalEnvelope = null;
        for (RasterQueryInfo rasterQueryInfo : queryInfos) {
            if (finalEnvelope == null) {
                finalEnvelope = new GeneralEnvelope((Envelope)rasterQueryInfo.getResultEnvelope());
                continue;
            }
            finalEnvelope.add((Envelope)rasterQueryInfo.getResultEnvelope());
        }
        if (finalEnvelope == null) {
            throw new IllegalStateException("Restult envelope is null, this shouldn't happen!! we checked the request overlaps the coverage envelope before!");
        }
        return finalEnvelope;
    }

    private RenderedImage createMosaic(List<RasterQueryInfo> queries, Rectangle mosaicGeometry, LoggingHelper log) throws IOException {
        RenderedImage mosaic;
        boolean expandCM;
        ArrayList<RenderedImage> transformed = new ArrayList<RenderedImage>(queries.size());
        boolean bl = expandCM = queries.size() > 1 && this.rasterInfo.isColorMapped();
        if (expandCM) {
            LOGGER.fine("Creating mosaic out of " + queries.size() + " colormapped rasters. The mosaic tiles will be expanded to " + "\nRGB space and the resulting mosaic reduced to a new IndexColorModel");
        }
        for (RasterQueryInfo query : queries) {
            ParameterBlock pb;
            RenderedImage image = query.getResultImage();
            log.log(image, query.getRasterId(), "01_original");
            if (expandCM) {
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("Creating color expanded version of tile for raster #" + query.getRasterId());
                }
                image = FormatDescriptor.create((RenderedImage)image, (Integer)0, null);
                log.log(image, query.getRasterId(), "04_1_colorExpanded");
            }
            image = this.cropToRequiredDimension(image, query.getTiledImageSize(), query.getResultDimensionInsideTiledImage());
            log.log(image, query.getRasterId(), "02_crop");
            if (queries.size() == 1) {
                return image;
            }
            Rectangle mosaicLocation = query.getMosaicLocation();
            Float scaleX = Float.valueOf((float)(mosaicLocation.getWidth() / (double)image.getWidth()));
            Float scaleY = Float.valueOf((float)(mosaicLocation.getHeight() / (double)image.getHeight()));
            Float translateX = Float.valueOf(0.0f);
            Float translateY = Float.valueOf(0.0f);
            if (!Float.valueOf(1.0f).equals(scaleX) || !Float.valueOf(1.0f).equals(scaleY)) {
                pb = new ParameterBlock();
                pb.addSource(image);
                pb.add(scaleX);
                pb.add(scaleY);
                pb.add(translateX);
                pb.add(translateY);
                pb.add(new InterpolationNearest());
                image = JAI.create((String)"scale", (ParameterBlock)pb);
                log.log(image, query.getRasterId(), "03_scale");
                int width = image.getWidth();
                int height = image.getHeight();
                assert (mosaicLocation.width == width);
                assert (mosaicLocation.height == height);
            }
            if (image.getMinX() != mosaicLocation.x || image.getMinY() != mosaicLocation.y) {
                pb = new ParameterBlock();
                pb.addSource(image);
                pb.add(Float.valueOf(mosaicLocation.x - image.getMinX()));
                pb.add(Float.valueOf(mosaicLocation.y - image.getMinY()));
                pb.add(null);
                image = JAI.create((String)"translate", (ParameterBlock)pb);
                log.log(image, query.getRasterId(), "04_translate");
                assert (image.getMinX() == mosaicLocation.x) : image.getMinX() + " != " + mosaicLocation.x;
                assert (image.getMinY() == mosaicLocation.y) : image.getMinY() + " != " + mosaicLocation.y;
                assert (image.getWidth() == mosaicLocation.width) : image.getWidth() + " != " + mosaicLocation.width;
                assert (image.getHeight() == mosaicLocation.height) : image.getHeight() + " != " + mosaicLocation.height;
            }
            transformed.add(image);
        }
        if (queries.size() == 1) {
            mosaic = (RenderedImage)transformed.get(0);
        } else {
            double[] backgroundValues;
            ParameterBlockJAI mosaicParams = new ParameterBlockJAI("Mosaic");
            mosaicParams.setParameter("mosaicType", (Object)MosaicDescriptor.MOSAIC_TYPE_OVERLAY);
            if (expandCM) {
                backgroundValues = new double[]{0.0, 0.0, 0.0, 0.0};
            } else {
                int numBands = this.rasterInfo.getNumBands();
                backgroundValues = new double[numBands];
                boolean rasterIndex = false;
                for (int bn = 0; bn < numBands; ++bn) {
                    Number noDataValue = this.rasterInfo.getNoDataValue(0, bn);
                    backgroundValues[bn] = noDataValue.doubleValue();
                }
            }
            mosaicParams.setParameter("backgroundValues", (Object)backgroundValues);
            ImageLayout layout = new ImageLayout(mosaicGeometry.x, mosaicGeometry.y, mosaicGeometry.width, mosaicGeometry.height);
            int tileWidth = this.rasterInfo.getTileDimension((int)0).width;
            int tileHeight = this.rasterInfo.getTileDimension((int)0).height;
            layout.setTileWidth(tileWidth);
            layout.setTileHeight(tileHeight);
            RenderingHints hints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
            for (RenderedImage img : transformed) {
                mosaicParams.addSource((Object)img);
                log.appendLoggingGeometries(LoggingHelper.MOSAIC_RESULT, img);
            }
            log.log(LoggingHelper.MOSAIC_RESULT);
            LOGGER.fine("Creating mosaic out of " + queries.size() + " raster tiles");
            mosaic = JAI.create((String)"Mosaic", (ParameterBlock)mosaicParams, (RenderingHints)hints);
            log.log(mosaic, 0L, "05_mosaic_result");
        }
        return mosaic;
    }

    private RenderedImage cropToRequiredDimension(RenderedImage fullTilesRaster, Rectangle tiledImageGridRange, Rectangle cropTo) {
        int minX = tiledImageGridRange.x;
        int minY = tiledImageGridRange.y;
        int width = tiledImageGridRange.width;
        int height = tiledImageGridRange.height;
        Rectangle origDim = new Rectangle(minX, minY, width, height);
        if (!origDim.contains(cropTo)) {
            throw new IllegalArgumentException("Original image (" + origDim + ") does not contain desired dimension (" + cropTo + ")");
        }
        if (origDim.equals(cropTo)) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("No need to crop image, full tiled dimension and target one do match: original: " + width + "x" + height + ", target: " + cropTo.width + "x" + cropTo.height);
            }
            return fullTilesRaster;
        }
        ParameterBlock cropParams = new ParameterBlock();
        cropParams.addSource(fullTilesRaster);
        cropParams.add(Float.valueOf(cropTo.x));
        cropParams.add(Float.valueOf(cropTo.y));
        cropParams.add(Float.valueOf(cropTo.width));
        cropParams.add(Float.valueOf(cropTo.height));
        RenderingHints hints = new RenderingHints(JAI.KEY_OPERATION_BOUND, 3);
        RenderedOp image = JAI.create((String)"Crop", (ParameterBlock)cropParams, (RenderingHints)hints);
        assert (cropTo.x == image.getMinX());
        assert (cropTo.y == image.getMinY());
        assert (cropTo.width == image.getWidth());
        assert (cropTo.height == image.getHeight());
        return image;
    }

    private static ReadParameters parseReadParams(GeneralEnvelope coverageEnvelope, GeneralParameterValue[] params) throws IllegalArgumentException {
        if (params == null) {
            throw new IllegalArgumentException("No GeneralParameterValue given to read operation");
        }
        GeneralEnvelope reqEnvelope = null;
        Rectangle dim = null;
        OverviewPolicy overviewPolicy = null;
        for (int i = 0; i < params.length; ++i) {
            ParameterValue param = (ParameterValue)params[i];
            String name = param.getDescriptor().getName().getCode();
            if (name.equals(AbstractGridFormat.READ_GRIDGEOMETRY2D.getName().toString())) {
                CoordinateReferenceSystem requestCrs;
                GridGeometry2D gg = (GridGeometry2D)param.getValue();
                reqEnvelope = new GeneralEnvelope((Envelope)gg.getEnvelope2D());
                CoordinateReferenceSystem nativeCrs = coverageEnvelope.getCoordinateReferenceSystem();
                if (!CRS.equalsIgnoreMetadata((Object)nativeCrs, (Object)(requestCrs = reqEnvelope.getCoordinateReferenceSystem()))) {
                    LOGGER.fine("Request CRS and native CRS differ, reprojecting request envelope to native CRS");
                    ReferencedEnvelope nativeCrsEnv = ArcSDEGridCoverage2DReaderJAI.toNativeCrs(reqEnvelope, nativeCrs);
                    reqEnvelope = new GeneralEnvelope((Envelope)nativeCrsEnv);
                }
                dim = gg.getGridRange2D().getBounds();
                continue;
            }
            if (!name.equals(AbstractGridFormat.OVERVIEW_POLICY.getName().toString())) continue;
            overviewPolicy = (OverviewPolicy)param.getValue();
        }
        if (dim == null && reqEnvelope == null) {
            throw new ParameterNotFoundException("Parameter is mandatory and shall provide the extent and dimension to request", AbstractGridFormat.READ_GRIDGEOMETRY2D.getName().toString());
        }
        if (!reqEnvelope.intersects((Envelope)coverageEnvelope, true)) {
            throw new IllegalArgumentException("The requested extend does not overlap the coverage extent: " + coverageEnvelope);
        }
        if (dim.width <= 0 || dim.height <= 0) {
            throw new IllegalArgumentException("The requested coverage dimension can't be null: " + dim);
        }
        if (overviewPolicy == null) {
            overviewPolicy = OverviewPolicy.QUALITY;
            LOGGER.finer("No overview policy requested, defaulting to " + overviewPolicy);
        }
        LOGGER.fine("Overview policy is " + overviewPolicy);
        LOGGER.fine("Reading raster for " + dim.getWidth() + "x" + dim.getHeight() + " requested dim and " + reqEnvelope.getMinimum(0) + "," + reqEnvelope.getMaximum(0) + " - " + reqEnvelope.getMinimum(1) + reqEnvelope.getMaximum(1) + " requested extent");
        ReadParameters parsedParams = new ReadParameters();
        parsedParams.requestedEnvelope = reqEnvelope;
        parsedParams.dim = dim;
        parsedParams.overviewPolicy = overviewPolicy;
        return parsedParams;
    }

    private static ReferencedEnvelope toNativeCrs(GeneralEnvelope requestedEnvelope, CoordinateReferenceSystem nativeCRS) throws IllegalArgumentException {
        ReferencedEnvelope reqEnv = ArcSDEGridCoverage2DReaderJAI.toReferencedEnvelope(requestedEnvelope);
        if (!CRS.equalsIgnoreMetadata((Object)nativeCRS, (Object)reqEnv.getCoordinateReferenceSystem())) {
            try {
                reqEnv = reqEnv.transform(nativeCRS, true);
            }
            catch (FactoryException fe) {
                throw new IllegalArgumentException("Unable to find a reprojection from requested coordsys to native coordsys for this request", fe);
            }
            catch (TransformException te) {
                throw new IllegalArgumentException("Unable to perform reprojection from requested coordsys to native coordsys for this request", te);
            }
        }
        return reqEnv;
    }

    private static ReferencedEnvelope toReferencedEnvelope(GeneralEnvelope envelope) {
        double minx = envelope.getMinimum(0);
        double maxx = envelope.getMaximum(0);
        double miny = envelope.getMinimum(1);
        double maxy = envelope.getMaximum(1);
        CoordinateReferenceSystem crs = envelope.getCoordinateReferenceSystem();
        ReferencedEnvelope refEnv = new ReferencedEnvelope(minx, maxx, miny, maxy, crs);
        return refEnv;
    }

    private static class LoggingHelper {
        private static final File debugDir = new File(System.getProperty("user.home") + File.separator + "arcsde_test");
        public Level GEOM_LEVEL = Level.FINER;
        public static String REQ_ENV;
        public static String RES_ENV;
        public static String MOSAIC_ENV;
        public static String MOSAIC_EXPECTED;
        public static String MOSAIC_RESULT;
        private Map<String, StringBuilder> geoms = null;

        LoggingHelper() {
        }

        private StringBuilder getGeom(String geomName) {
            StringBuilder sb;
            if (this.geoms == null) {
                this.geoms = new HashMap<String, StringBuilder>();
            }
            if ((sb = this.geoms.get(geomName)) == null) {
                sb = new StringBuilder("MULTIPOLYGON(\n");
                this.geoms.put(geomName, sb);
            }
            return sb;
        }

        public void appendLoggingGeometries(String geomName, RenderedImage img) {
            if (LOGGER.isLoggable(this.GEOM_LEVEL)) {
                this.appendLoggingGeometries(geomName, new Rectangle(img.getMinX(), img.getMinY(), img.getWidth(), img.getHeight()));
            }
        }

        public void appendLoggingGeometries(String geomName, Rectangle env) {
            if (LOGGER.isLoggable(this.GEOM_LEVEL)) {
                this.appendLoggingGeometries(geomName, new GeneralEnvelope((Rectangle2D)env));
            }
        }

        public void appendLoggingGeometries(String geomName, GeneralEnvelope env) {
            if (LOGGER.isLoggable(this.GEOM_LEVEL)) {
                StringBuilder sb = this.getGeom(geomName);
                sb.append("  ((" + env.getMinimum(0) + " " + env.getMinimum(1) + ", " + env.getMaximum(0) + " " + env.getMinimum(1) + ", " + env.getMaximum(0) + " " + env.getMaximum(1) + ", " + env.getMinimum(0) + " " + env.getMaximum(1) + ", " + env.getMinimum(0) + " " + env.getMinimum(1) + ")),");
            }
        }

        public void log(String geomName) {
            if (LOGGER.isLoggable(this.GEOM_LEVEL)) {
                StringBuilder sb = this.getGeom(geomName);
                sb.setLength(sb.length() - 1);
                sb.append("\n)");
                LOGGER.log(this.GEOM_LEVEL, geomName + ":\n" + sb.toString());
            }
        }

        public void log(RenderedImage image, Long rasterId, String fileName) {
            if (DEBUG_TO_DISK) {
                LOGGER.warning("BEWARE THE DEBUG FLAG IS TURNED ON! IF IN PRODUCTION THIS IS A SEVERE MISTAKE!!!");
                try {
                    ImageIO.write(image, "TIFF", new File(debugDir, rasterId + fileName + ".tiff"));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        static {
            if (DEBUG_TO_DISK) {
                debugDir.mkdir();
            }
            REQ_ENV = "Requested envelope";
            RES_ENV = "Resulting envelope";
            MOSAIC_ENV = "Resulting mosaiced envelopes";
            MOSAIC_EXPECTED = "Expected mosaic layout (in pixels)";
            MOSAIC_RESULT = "Resulting image mosaic layout (in pixels)";
        }
    }

    static class ReadParameters {
        GeneralEnvelope requestedEnvelope;
        Rectangle dim;
        OverviewPolicy overviewPolicy;

        ReadParameters() {
        }
    }
}

