/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.raster.jai;

import com.sun.media.jai.codecimpl.util.DataBufferDouble;
import com.sun.media.jai.util.ImageUtil;
import java.awt.Point;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.math.BigInteger;
import java.util.logging.Logger;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.TileCache;
import javax.media.jai.TileFactory;
import org.geotools.arcsde.raster.io.TileReader;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;

public class ArcSDEPlanarImage
extends PlanarImage {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.arcsde.raster.jai");
    private TileReader tileReader;
    private final SampleModel tileSampleModel;
    private final BigInteger UID;
    private final int hashCode;
    private int lastTileX;
    private int lastTileY;
    private WritableRaster currentTile;

    public ArcSDEPlanarImage(TileReader tileReader, int minX, int minY, int width, int height, int tileGridXOffset, int tileGridYOffset, SampleModel tileSampleModel, ColorModel colorModel) {
        this.tileReader = tileReader;
        this.tileSampleModel = tileSampleModel;
        this.minX = minX;
        this.minY = minY;
        this.width = width;
        this.height = height;
        this.tileGridXOffset = tileGridXOffset;
        this.tileGridYOffset = tileGridYOffset;
        this.tileWidth = tileReader.getTileWidth();
        this.tileHeight = tileReader.getTileHeight();
        this.colorModel = colorModel;
        this.sampleModel = tileSampleModel;
        int result = 17;
        result = Utilities.hash((Object)tileReader.getServerName(), (int)result);
        result = Utilities.hash((Object)tileReader.getRasterTableName(), (int)result);
        result = Utilities.hash((long)tileReader.getRasterId(), (int)result);
        this.hashCode = result = Utilities.hash((int)tileReader.getPyramidLevel(), (int)result);
        this.UID = (BigInteger)ImageUtil.generateID((Object)((Object)this));
    }

    public SampleModel getSampleModel() {
        return this.sampleModel;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public BigInteger getImageID() {
        return this.UID;
    }

    public synchronized Raster getTile(int tileX, int tileY) {
        TileFactory tileFactory;
        if (tileX == this.lastTileX && tileY == this.lastTileY && this.currentTile != null) {
            return this.currentTile;
        }
        boolean useCache = false;
        JAI jai = JAI.getDefaultInstance();
        TileCache jaiCache = jai.getTileCache();
        if (this.tileFactory == null && (tileFactory = (TileFactory)jai.getRenderingHint(JAI.KEY_TILE_FACTORY)) != null) {
            this.tileFactory = tileFactory;
        }
        int xOrigin = this.tileXToX(tileX);
        int yOrigin = this.tileYToY(tileY);
        if (this.currentTile == null) {
            this.currentTile = Raster.createWritableRaster(this.tileSampleModel, new Point(xOrigin, yOrigin));
        } else {
            DataBuffer db = this.currentTile.getDataBuffer();
            this.currentTile = Raster.createWritableRaster(this.tileSampleModel, db, new Point(xOrigin, yOrigin));
        }
        if (this.shallIgnoreTile(tileX, tileY)) {
            return this.currentTile;
        }
        int readerTileX = tileX - this.tileReader.getMinTileX();
        int readerTileY = tileY - this.tileReader.getMinTileY();
        try {
            switch (this.tileSampleModel.getDataType()) {
                case 0: {
                    DataBufferByte dataBuffer = (DataBufferByte)this.currentTile.getDataBuffer();
                    byte[][] bankData = dataBuffer.getBankData();
                    this.tileReader.getTile(readerTileX, readerTileY, bankData);
                    break;
                }
                case 1: {
                    DataBufferUShort dataBuffer = (DataBufferUShort)this.currentTile.getDataBuffer();
                    short[][] bankData = dataBuffer.getBankData();
                    this.tileReader.getTile(readerTileX, readerTileY, bankData);
                    break;
                }
                case 2: {
                    DataBufferShort dataBuffer = (DataBufferShort)this.currentTile.getDataBuffer();
                    short[][] bankData = dataBuffer.getBankData();
                    this.tileReader.getTile(readerTileX, readerTileY, bankData);
                    break;
                }
                case 3: {
                    DataBufferInt dataBuffer = (DataBufferInt)this.currentTile.getDataBuffer();
                    int[][] bankData = dataBuffer.getBankData();
                    this.tileReader.getTile(readerTileX, readerTileY, bankData);
                    break;
                }
                case 4: {
                    DataBufferFloat dataBuffer = (DataBufferFloat)this.currentTile.getDataBuffer();
                    float[][] bankData = dataBuffer.getBankData();
                    this.tileReader.getTile(readerTileX, readerTileY, bankData);
                    break;
                }
                case 5: {
                    DataBufferDouble dataBuffer = (DataBufferDouble)this.currentTile.getDataBuffer();
                    double[][] bankData = dataBuffer.getBankData();
                    this.tileReader.getTile(readerTileX, readerTileY, bankData);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unrecognized DataBuffer type: " + this.tileSampleModel.getDataType());
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        this.lastTileX = tileX;
        this.lastTileY = tileY;
        return this.currentTile;
    }

    private boolean shallIgnoreTile(int tx, int ty) {
        int minTileX = this.tileReader.getMinTileX();
        int minTileY = this.tileReader.getMinTileY();
        int tilesWide = this.tileReader.getTilesWide();
        int tilesHigh = this.tileReader.getTilesHigh();
        return tx < minTileX || ty < minTileY || tx > minTileX + tilesWide || ty > minTileY + tilesHigh;
    }
}

