/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.data;

import com.esri.sde.sdk.client.SDEPoint;
import com.esri.sde.sdk.client.SeCoordinateReference;
import com.esri.sde.sdk.client.SeException;
import com.esri.sde.sdk.client.SeShape;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.arcsde.ArcSdeException;
import org.geotools.arcsde.data.ArcSDEAdapter;
import org.geotools.data.DataSourceException;
import org.geotools.geometry.jts.LiteCoordinateSequenceFactory;
import org.geotools.util.logging.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ArcSDEGeometryBuilder {
    private static final Logger LOGGER = Logging.getLogger((String)ArcSDEGeometryBuilder.class.getName());
    private static final Map<Class<?>, ArcSDEGeometryBuilder> builders = new HashMap();
    private static final Map<Class<?>, Geometry> nullGeometries = new HashMap();

    static {
        builders.put(Geometry.class, GenericGeometryBuilder.getInstance());
        builders.put(GeometryCollection.class, GenericGeometryBuilder.getInstance());
        builders.put(Point.class, PointBuilder.getInstance());
        builders.put(MultiPoint.class, MultiPointBuilder.getInstance());
        builders.put(LineString.class, LineStringBuilder.getInstance());
        builders.put(MultiLineString.class, MultiLineStringBuilder.getInstance());
        builders.put(Polygon.class, PolygonBuilder.getInstance());
        builders.put(MultiPolygon.class, MultiPolygonBuilder.getInstance());
        nullGeometries.put(Geometry.class, new GenericGeometryBuilder().getEmpty());
        nullGeometries.put(Point.class, new PointBuilder().getEmpty());
        nullGeometries.put(MultiPoint.class, new MultiPointBuilder().getEmpty());
        nullGeometries.put(LineString.class, new LineStringBuilder().getEmpty());
        nullGeometries.put(MultiLineString.class, new MultiLineStringBuilder().getEmpty());
        nullGeometries.put(Polygon.class, new PolygonBuilder().getEmpty());
        nullGeometries.put(MultiPolygon.class, new MultiPolygonBuilder().getEmpty());
    }

    private ArcSDEGeometryBuilder() {
    }

    public Geometry construct(SeShape shape, GeometryFactory geometryFactory) throws SeException, DataSourceException {
        if (shape == null || shape.isNil()) {
            return this.getEmpty();
        }
        double[][][] allCoords = shape.getAllCoords();
        return this.newGeometry(allCoords, geometryFactory);
    }

    public final SeShape constructShape(Geometry geometry, SeCoordinateReference seSrs) throws ArcSdeException {
        if (geometry == null) {
            return null;
        }
        SeShape shape = null;
        try {
            shape = new SeShape(seSrs);
        }
        catch (SeException ex) {
            ArcSdeException e = new ArcSdeException("Can't create SeShape with SeCrs " + seSrs, ex);
            LOGGER.log(Level.WARNING, e.getMessage(), (Throwable)e);
            throw e;
        }
        if (geometry.isEmpty()) {
            return shape;
        }
        GeometryCollection gcol = null;
        if (geometry instanceof GeometryCollection) {
            gcol = (GeometryCollection)geometry;
        } else {
            Geometry[] geoms = new Geometry[]{geometry};
            gcol = new GeometryFactory().createGeometryCollection(geoms);
        }
        ArrayList<SDEPoint> allPoints = new ArrayList<SDEPoint>();
        int numParts = gcol.getNumGeometries();
        int[] partOffsets = new int[numParts];
        int currGeom = 0;
        while (currGeom < numParts) {
            partOffsets[currGeom] = allPoints.size();
            Geometry geom = gcol.getGeometryN(currGeom);
            Coordinate[] coords = geom.getCoordinates();
            int i = 0;
            while (i < coords.length) {
                Coordinate c = coords[i];
                allPoints.add(new SDEPoint(c.x, c.y));
                ++i;
            }
            ++currGeom;
        }
        SDEPoint[] points = new SDEPoint[allPoints.size()];
        allPoints.toArray(points);
        try {
            if (geometry instanceof Point || gcol instanceof MultiPoint) {
                shape.generatePoint(points.length, points);
            } else if (geometry instanceof LineString || geometry instanceof MultiLineString) {
                shape.generateLine(points.length, numParts, partOffsets, points);
            } else {
                shape.generatePolygon(points.length, numParts, partOffsets, points);
            }
        }
        catch (SeException e) {
            ArcSdeException sdeEx = new ArcSdeException("Can't generate SeShape from " + geometry + "\n", e);
            LOGGER.log(Level.WARNING, sdeEx.getMessage());
            throw sdeEx;
        }
        return shape;
    }

    protected abstract Geometry newGeometry(double[][][] var1, GeometryFactory var2) throws DataSourceException;

    protected Geometry getEmpty() {
        throw new UnsupportedOperationException("this method sholdn't be called directly, it's intended pourpose is to be implemented by subclasses so they provide propper  null Geometries");
    }

    protected final CoordinateSequence toCoords(double[] coordList, CoordinateSequenceFactory csFact) {
        CoordinateSequence cs;
        int dimension = 2;
        if (csFact instanceof LiteCoordinateSequenceFactory) {
            cs = ((LiteCoordinateSequenceFactory)csFact).create(coordList, 2);
        } else {
            int nCoords = coordList.length / 2;
            cs = csFact.create(nCoords, 2);
            int coordN = 0;
            while (coordN < nCoords) {
                cs.setOrdinate(coordN, 0, coordList[2 * coordN]);
                cs.setOrdinate(coordN, 1, coordList[2 * coordN + 1]);
                ++coordN;
            }
        }
        return cs;
    }

    protected SDEPoint[] toPointsArray(Coordinate[] coords) {
        int nCoords = coords.length;
        SDEPoint[] points = new SDEPoint[nCoords];
        int i = 0;
        while (i < nCoords) {
            Coordinate c = coords[i];
            points[i] = new SDEPoint(c.x, c.y);
            ++i;
        }
        return points;
    }

    public static ArcSDEGeometryBuilder builderFor(Class<? extends Geometry> jtsGeometryClass) throws IllegalArgumentException {
        ArcSDEGeometryBuilder builder = builders.get(jtsGeometryClass);
        if (builder == null) {
            String msg = "no geometry builder is defined to construct " + jtsGeometryClass + " instances.";
            throw new IllegalArgumentException(msg);
        }
        return builder;
    }

    public static Geometry defaultValueFor(Class<?> geoClass) {
        if (geoClass == null) {
            throw new NullPointerException("got null geometry class");
        }
        Geometry emptyGeom = nullGeometries.get(geoClass);
        return emptyGeom;
    }

    /* synthetic */ ArcSDEGeometryBuilder(ArcSDEGeometryBuilder arcSDEGeometryBuilder) {
        this();
    }

    private static class GenericGeometryBuilder
    extends ArcSDEGeometryBuilder {
        private static Geometry EMPTY;
        private static final ArcSDEGeometryBuilder instance;

        static {
            instance = new GenericGeometryBuilder();
        }

        private GenericGeometryBuilder() {
            super(null);
        }

        public static ArcSDEGeometryBuilder getInstance() {
            return instance;
        }

        protected Geometry getEmpty() {
            if (EMPTY == null) {
                EMPTY = new GeometryFactory().createGeometryCollection(new Geometry[0]);
            }
            return EMPTY;
        }

        public Geometry construct(SeShape shape, GeometryFactory geometryFactory) throws SeException, DataSourceException {
            if (shape == null || shape.isNil()) {
                return this.getEmpty();
            }
            Class<? extends Geometry> realGeomClass = ArcSDEAdapter.getGeometryTypeFromSeShape(shape);
            if (realGeomClass == null) {
                return null;
            }
            ArcSDEGeometryBuilder realBuilder = GenericGeometryBuilder.builderFor(realGeomClass);
            return realBuilder.construct(shape, geometryFactory);
        }

        protected Geometry newGeometry(double[][][] coords, GeometryFactory geometryFactory) throws DataSourceException {
            throw new UnsupportedOperationException("This method should not be called for this builder. It should be mapped to the one capable of constructing the actual geometry type");
        }
    }

    private static class LineStringBuilder
    extends ArcSDEGeometryBuilder {
        private static Geometry EMPTY;
        private static final ArcSDEGeometryBuilder instance;

        static {
            instance = new LineStringBuilder();
        }

        private LineStringBuilder() {
            super(null);
        }

        public static ArcSDEGeometryBuilder getInstance() {
            return instance;
        }

        protected Geometry getEmpty() {
            if (EMPTY == null) {
                EMPTY = new GeometryFactory().createLineString(null);
            }
            return EMPTY;
        }

        protected Geometry newGeometry(double[][][] coords, GeometryFactory geometryFactory) throws DataSourceException {
            return this.constructLineString(coords[0][0], geometryFactory);
        }

        protected final LineString constructLineString(double[] linearCoords, GeometryFactory geometryFactory) throws DataSourceException {
            LineString ls = null;
            CoordinateSequence coords = this.toCoords(linearCoords, geometryFactory.getCoordinateSequenceFactory());
            ls = geometryFactory.createLineString(coords);
            return ls;
        }

        /* synthetic */ LineStringBuilder(LineStringBuilder lineStringBuilder, LineStringBuilder lineStringBuilder2) {
            this();
        }
    }

    private static class MultiLineStringBuilder
    extends LineStringBuilder {
        private static Geometry EMPTY;
        private static final ArcSDEGeometryBuilder instance;

        static {
            instance = new MultiLineStringBuilder();
        }

        private MultiLineStringBuilder() {
            super(null, null);
        }

        public static ArcSDEGeometryBuilder getInstance() {
            return instance;
        }

        protected Geometry getEmpty() {
            if (EMPTY == null) {
                EMPTY = new GeometryFactory().createMultiLineString(null);
            }
            return EMPTY;
        }

        protected Geometry newGeometry(double[][][] coords, GeometryFactory geometryFactory) throws DataSourceException {
            MultiLineString mls = null;
            LineString[] lineStrings = null;
            int nLines = coords.length;
            lineStrings = new LineString[nLines];
            int i = 0;
            while (i < nLines) {
                lineStrings[i] = this.constructLineString(coords[i][0], geometryFactory);
                ++i;
            }
            mls = geometryFactory.createMultiLineString(lineStrings);
            return mls;
        }
    }

    private static class MultiPointBuilder
    extends ArcSDEGeometryBuilder {
        private static Geometry EMPTY;
        private static final ArcSDEGeometryBuilder instance;

        static {
            instance = new MultiPointBuilder();
        }

        private MultiPointBuilder() {
            super(null);
        }

        public static ArcSDEGeometryBuilder getInstance() {
            return instance;
        }

        protected Geometry getEmpty() {
            if (EMPTY == null) {
                EMPTY = new GeometryFactory().createMultiPoint(null);
            }
            return EMPTY;
        }

        protected Geometry newGeometry(double[][][] coords, GeometryFactory geometryFactory) throws DataSourceException {
            int nPoints = coords.length;
            Coordinate[] points = new Coordinate[nPoints];
            int i = 0;
            while (i < nPoints) {
                double x = coords[i][0][0];
                double y = coords[i][0][1];
                points[i] = new Coordinate(x, y);
                ++i;
            }
            return geometryFactory.createMultiPoint(points);
        }
    }

    private static class MultiPolygonBuilder
    extends PolygonBuilder {
        private static Geometry EMPTY;
        private static final ArcSDEGeometryBuilder instance;

        static {
            instance = new MultiPolygonBuilder();
        }

        private MultiPolygonBuilder() {
            super(null, null);
        }

        public static ArcSDEGeometryBuilder getInstance() {
            return instance;
        }

        protected Geometry getEmpty() {
            if (EMPTY == null) {
                EMPTY = new GeometryFactory().createMultiPolygon(null);
            }
            return EMPTY;
        }

        protected Geometry newGeometry(double[][][] coords, GeometryFactory geometryFactory) throws DataSourceException {
            Polygon[] polys = null;
            int numPolys = coords.length;
            polys = new Polygon[numPolys];
            int i = 0;
            while (i < numPolys) {
                try {
                    polys[i] = this.buildPolygon(coords[i], geometryFactory);
                }
                catch (Exception ex) {
                    throw new DataSourceException(ex.getMessage(), (Throwable)ex);
                }
                ++i;
            }
            MultiPolygon multiPoly = geometryFactory.createMultiPolygon(polys);
            return multiPoly;
        }
    }

    private static class PointBuilder
    extends ArcSDEGeometryBuilder {
        private static Geometry EMPTY;
        private static final ArcSDEGeometryBuilder instance;

        static {
            instance = new PointBuilder();
        }

        private PointBuilder() {
            super(null);
        }

        public static ArcSDEGeometryBuilder getInstance() {
            return instance;
        }

        protected Geometry getEmpty() {
            if (EMPTY == null) {
                EMPTY = new GeometryFactory().createPoint(null);
            }
            return EMPTY;
        }

        protected Geometry newGeometry(double[][][] coords, GeometryFactory geometryFactory) throws DataSourceException {
            double x = coords[0][0][0];
            double y = coords[0][0][1];
            return geometryFactory.createPoint(new Coordinate(x, y));
        }
    }

    private static class PolygonBuilder
    extends ArcSDEGeometryBuilder {
        private static Geometry EMPTY;
        private static final ArcSDEGeometryBuilder instance;

        static {
            instance = new PolygonBuilder();
        }

        private PolygonBuilder() {
            super(null);
        }

        public static ArcSDEGeometryBuilder getInstance() {
            return instance;
        }

        protected Geometry getEmpty() {
            if (EMPTY == null) {
                EMPTY = new GeometryFactory().createPolygon(null, null);
            }
            return EMPTY;
        }

        protected Geometry newGeometry(double[][][] coords, GeometryFactory geometryFactory) throws DataSourceException {
            double[] shell = coords[0][0];
            int nParts = coords[0].length;
            int nHoles = nParts - 1;
            double[][] holes = new double[nHoles][1];
            int i = 0;
            while (i < nHoles) {
                holes[i] = coords[0][i + 1];
                ++i;
            }
            return this.buildPolygon(shell, holes, geometryFactory);
        }

        protected final Polygon buildPolygon(double[] shellCoords, double[][] holes, GeometryFactory geometryFactory) {
            Polygon p = null;
            CoordinateSequenceFactory sequenceFactory = geometryFactory.getCoordinateSequenceFactory();
            CoordinateSequence coords = this.toCoords(shellCoords, sequenceFactory);
            LinearRing shell = geometryFactory.createLinearRing(coords);
            int nHoles = holes.length;
            LinearRing[] polygonHoles = new LinearRing[nHoles];
            if (nHoles > 0) {
                int i = 0;
                while (i < nHoles) {
                    double[] hole = holes[i];
                    polygonHoles[i] = geometryFactory.createLinearRing(this.toCoords(hole, sequenceFactory));
                    ++i;
                }
            }
            p = geometryFactory.createPolygon(shell, polygonHoles);
            return p;
        }

        @Deprecated
        protected Polygon buildPolygon(double[][] parts, GeometryFactory geometryFactory) {
            Polygon p = null;
            double[] linearCoordArray = parts[0];
            int nHoles = parts.length - 1;
            CoordinateSequenceFactory coordinateSequenceFactory = geometryFactory.getCoordinateSequenceFactory();
            LinearRing shell = geometryFactory.createLinearRing(this.toCoords(linearCoordArray, coordinateSequenceFactory));
            LinearRing[] holes = new LinearRing[nHoles];
            if (nHoles > 0) {
                int i = 0;
                while (i < nHoles) {
                    linearCoordArray = parts[i + 1];
                    holes[i] = geometryFactory.createLinearRing(this.toCoords(linearCoordArray, coordinateSequenceFactory));
                    ++i;
                }
            }
            p = geometryFactory.createPolygon(shell, holes);
            return p;
        }

        /* synthetic */ PolygonBuilder(PolygonBuilder polygonBuilder, PolygonBuilder polygonBuilder2) {
            this();
        }
    }
}

