/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.data.view;

import com.esri.sde.sdk.client.SeColumnDefinition;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.AllTableColumns;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SelectItemVisitor;
import org.geotools.arcsde.data.view.ExpressionQualifier;
import org.geotools.arcsde.data.view.TableQualifier;
import org.geotools.arcsde.session.ISession;

class SelectItemQualifier
implements SelectItemVisitor {
    private List qualifiedItems = Collections.EMPTY_LIST;
    private ISession session;
    private Map tableAliases;

    private SelectItemQualifier(ISession session, Map tableAliases) {
        this.session = session;
        this.tableAliases = tableAliases;
    }

    public static List qualify(ISession session, Map tableAliases, SelectItem item) {
        if (item == null) {
            return null;
        }
        SelectItemQualifier qualifier = new SelectItemQualifier(session, tableAliases);
        item.accept((SelectItemVisitor)qualifier);
        return qualifier.qualifiedItems;
    }

    public void visit(AllColumns allColumns) {
        this.qualifiedItems = Collections.singletonList(allColumns);
    }

    public void visit(AllTableColumns allTableColumns) {
        SeColumnDefinition[] cols;
        AllTableColumns qualified = new AllTableColumns();
        Table qt = allTableColumns.getTable();
        Table unaliasedTable = (Table)this.tableAliases.get(qt.getName());
        qt = unaliasedTable == null ? TableQualifier.qualify(this.session, allTableColumns.getTable()) : unaliasedTable;
        qualified.setTable(qt);
        String tableName = String.valueOf(qt.getSchemaName()) + "." + qt.getName();
        try {
            cols = this.session.describe(tableName);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
        this.qualifiedItems = new ArrayList(cols.length);
        int i = 0;
        while (i < cols.length) {
            String colName = cols[i].getName();
            Column column = new Column();
            column.setTable(qt);
            column.setColumnName(colName);
            SelectExpressionItem item = new SelectExpressionItem();
            item.setExpression((Expression)column);
            this.qualifiedItems.add(item);
            ++i;
        }
    }

    public void visit(SelectExpressionItem selectExpressionItem) {
        SelectExpressionItem qualifiedItem = new SelectExpressionItem();
        qualifiedItem.setAlias(selectExpressionItem.getAlias());
        Expression selectExpression = selectExpressionItem.getExpression();
        Expression qualifiedExpression = ExpressionQualifier.qualify(this.session, this.tableAliases, selectExpression);
        qualifiedItem.setExpression(qualifiedExpression);
        this.qualifiedItems = Collections.singletonList(qualifiedItem);
    }
}

