/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.filter;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import org.geotools.arcsde.data.ArcSDEAdapter;
import org.geotools.data.jdbc.FilterToSQL;
import org.geotools.data.jdbc.FilterToSQLException;
import org.geotools.filter.FilterCapabilities;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.BinaryLogicOperator;
import org.opengis.filter.ExcludeFilter;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Id;
import org.opengis.filter.IncludeFilter;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.PropertyName;

public class FilterToSQLSDE
extends FilterToSQL
implements FilterVisitor {
    private static Logger LOGGER = Logging.getLogger((String)FilterToSQLSDE.class.getName());
    private final String layerQualifiedName;
    private final String layerFidFieldName;
    private final PlainSelect definitionQuery;
    private Map attributeNames = Collections.EMPTY_MAP;

    public FilterToSQLSDE(String layerQName, String layerFidColName, SimpleFeatureType ft, PlainSelect definitionQuery) {
        this.layerQualifiedName = layerQName;
        this.layerFidFieldName = layerFidColName;
        this.featureType = ft;
        this.definitionQuery = definitionQuery;
        if (definitionQuery != null) {
            this.attributeNames = new HashMap();
            List selectItems = definitionQuery.getSelectItems();
            for (SelectItem item : selectItems) {
                if (!(item instanceof SelectExpressionItem)) {
                    String msg = "for item '" + item + "': only SelectExpressionItems should be in query at this stage." + " AllColumns and AllTableColumns instances should be resolved to their list " + " of column names at view registration time.";
                    LOGGER.severe(msg);
                    throw new IllegalStateException(msg);
                }
                SelectExpressionItem colDef = (SelectExpressionItem)item;
                String alias = colDef.getAlias();
                if (alias == null) {
                    if (!(colDef.getExpression() instanceof Column)) {
                        throw new RuntimeException("if select item is not a plain column an alias should be provided: " + colDef);
                    }
                    Column column = (Column)colDef.getExpression();
                    alias = column.getColumnName();
                }
                this.attributeNames.put(alias, colDef);
            }
        }
    }

    public String getColumnDefinition(String alias) {
        String encodedColumnDefinition;
        if (this.definitionQuery != null) {
            String sqlExpression;
            SelectExpressionItem colDef = (SelectExpressionItem)this.attributeNames.get(alias);
            encodedColumnDefinition = sqlExpression = String.valueOf(colDef);
        } else {
            String nonNsPrefixedAlias = alias;
            if (alias.indexOf(":") != -1) {
                nonNsPrefixedAlias = alias.substring(alias.indexOf(":") + 1);
            }
            encodedColumnDefinition = String.valueOf(this.layerQualifiedName) + "." + nonNsPrefixedAlias;
        }
        return encodedColumnDefinition;
    }

    protected FilterCapabilities createFilterCapabilities() {
        FilterCapabilities capabilities = new FilterCapabilities();
        capabilities.addAll(FilterCapabilities.LOGICAL_OPENGIS);
        capabilities.addAll(FilterCapabilities.SIMPLE_COMPARISONS_OPENGIS);
        capabilities.addType(PropertyIsNull.class);
        capabilities.addType(PropertyIsBetween.class);
        capabilities.addType(Id.class);
        capabilities.addType(IncludeFilter.class);
        capabilities.addType(ExcludeFilter.class);
        capabilities.addType(PropertyIsLike.class);
        return capabilities;
    }

    public void encode(Filter filter) throws FilterToSQLException {
        if (!this.getCapabilities().fullySupports(filter)) {
            throw new FilterToSQLException("Filter type not supported");
        }
        filter.accept((FilterVisitor)this, null);
    }

    public Object visit(Id filter, Object unused) {
        Set identifiers = filter.getIdentifiers();
        if (identifiers.size() == 0) {
            Filter.EXCLUDE.accept((FilterVisitor)this, unused);
            return unused;
        }
        long[] fids = ArcSDEAdapter.getNumericFids(identifiers);
        int nFids = fids.length;
        if (nFids == 0) {
            return unused;
        }
        String fidField = this.layerFidFieldName;
        try {
            String sql = this.buildFilter(fids, String.valueOf(fidField) + " IN(", ")", ",", 1000, " OR ");
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("added fid filter: " + sql);
            }
            this.out.write(sql);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        return unused;
    }

    private String buildFilter(long[] fids, String prefix, String suffix, String separator, int groupSize, String groupSeparator) {
        int count = fids.length;
        int groups = count / groupSize;
        int remainder = count % groupSize;
        StringBuilder sql = new StringBuilder();
        int i = 0;
        while (i < groups) {
            if (i > 0) {
                sql.append(groupSeparator);
            }
            sql.append(prefix);
            this.addSubList(sql, fids, i * groupSize, (i + 1) * groupSize, separator);
            sql.append(suffix);
            ++i;
        }
        if (remainder > 0) {
            if (groups > 0) {
                sql.append(groupSeparator);
            }
            sql.append(prefix);
            this.addSubList(sql, fids, count - remainder, count, separator);
            sql.append(suffix);
        }
        return sql.toString();
    }

    private void addSubList(StringBuilder sql, long[] fids, int start, int end, String separator) {
        int i = start;
        while (i < end) {
            sql.append(fids[i]);
            sql.append(separator);
            ++i;
        }
        sql.setLength(sql.length() - separator.length());
    }

    public Object visit(PropertyName expression, Object extraData) throws RuntimeException {
        LOGGER.finer("exporting PropertyName");
        String attName = expression.getPropertyName();
        String encodedColumnDefinition = this.getColumnDefinition(attName);
        try {
            this.out.write(encodedColumnDefinition);
        }
        catch (IOException ioe) {
            throw new RuntimeException("IO problems writing attribute exp", ioe);
        }
        return extraData;
    }

    protected Object visit(BinaryLogicOperator filter, Object extraData) {
        List children = filter.getChildren();
        if (children.isEmpty()) {
            return extraData;
        }
        return super.visit(filter, extraData);
    }

    public Object visit(ExcludeFilter filter, Object extraData) {
        try {
            this.out.write("1 = 2");
        }
        catch (IOException ioe) {
            throw new RuntimeException("io problem writing filter", ioe);
        }
        return extraData;
    }

    public Object visit(IncludeFilter filter, Object extraData) {
        try {
            this.out.write("1 = 1");
        }
        catch (IOException ioe) {
            throw new RuntimeException("io problem writing filter", ioe);
        }
        return extraData;
    }
}

