/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.raster.info;

import com.esri.sde.sdk.client.SDEPoint;
import com.esri.sde.sdk.client.SeColumnDefinition;
import com.esri.sde.sdk.client.SeConnection;
import com.esri.sde.sdk.client.SeCoordinateReference;
import com.esri.sde.sdk.client.SeException;
import com.esri.sde.sdk.client.SeExtent;
import com.esri.sde.sdk.client.SeQuery;
import com.esri.sde.sdk.client.SeRaster;
import com.esri.sde.sdk.client.SeRasterAttr;
import com.esri.sde.sdk.client.SeRasterBand;
import com.esri.sde.sdk.client.SeRasterColumn;
import com.esri.sde.sdk.client.SeRow;
import com.esri.sde.sdk.client.SeSqlConstruct;
import com.esri.sde.sdk.client.SeTable;
import java.awt.Point;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.arcsde.ArcSdeException;
import org.geotools.arcsde.raster.info.CompressionType;
import org.geotools.arcsde.raster.info.InterleaveType;
import org.geotools.arcsde.raster.info.InterpolationType;
import org.geotools.arcsde.raster.info.RasterBandInfo;
import org.geotools.arcsde.raster.info.RasterCellType;
import org.geotools.arcsde.raster.info.RasterDatasetInfo;
import org.geotools.arcsde.raster.info.RasterInfo;
import org.geotools.arcsde.raster.info.RasterUtils;
import org.geotools.arcsde.session.Command;
import org.geotools.arcsde.session.ISession;
import org.geotools.arcsde.util.ArcSDEUtils;
import org.geotools.data.DataSourceException;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.geotools.util.logging.Logging;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GatherCoverageMetadataCommand
extends Command<RasterDatasetInfo> {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.arcsde.gce");
    private final boolean statisticsMandatory;
    private final String rasterTableName;

    public GatherCoverageMetadataCommand(String rasterTableName, boolean statisticsMandatory) {
        this.rasterTableName = rasterTableName;
        this.statisticsMandatory = statisticsMandatory;
    }

    public RasterDatasetInfo execute(ISession session, SeConnection connection) throws SeException, IOException {
        int bitsPerSample;
        SeRasterBand sampleBand;
        long rasterColumnId;
        SeRasterColumn rasterColumn;
        LOGGER.fine("Gathering raster dataset metadata for " + this.rasterTableName);
        String[] rasterColumns = this.getRasterColumns(connection, this.rasterTableName);
        ArrayList<RasterInfo> rastersLayoutInfo = new ArrayList<RasterInfo>();
        List<SeRasterAttr> rasterAttributes = this.getSeRasterAttr(connection, this.rasterTableName, rasterColumns);
        if (rasterAttributes.size() == 0) {
            throw new IllegalArgumentException("Table " + this.rasterTableName + " contains no raster datasets");
        }
        try {
            SeRasterAttr ratt = rasterAttributes.get(0);
            rasterColumn = new SeRasterColumn(connection, ratt.getRasterColumnId());
            rasterColumnId = rasterColumn.getID().longValue();
            sampleBand = ratt.getBands()[0];
            bitsPerSample = RasterCellType.valueOf(ratt.getPixelType()).getBitsPerSample();
        }
        catch (SeException e) {
            throw new ArcSdeException(e);
        }
        SeCoordinateReference seCoordRef = rasterColumn.getCoordRef();
        if (seCoordRef == null) {
            throw new IllegalArgumentException(String.valueOf(this.rasterTableName) + " has no coordinate reference system set");
        }
        LOGGER.finer("Looking CRS for raster column " + this.rasterTableName);
        CoordinateReferenceSystem coverageCrs = ArcSDEUtils.findCompatibleCRS(seCoordRef);
        if (DefaultEngineeringCRS.CARTESIAN_2D == coverageCrs) {
            LOGGER.warning("Raster " + this.rasterTableName + " has not CRS set, using DefaultEngineeringCRS.CARTESIAN_2D");
        }
        Map<Long, IndexColorModel> rastersColorMaps = sampleBand.hasColorMap() ? this.loadColorMaps(rasterColumnId, bitsPerSample, connection) : Collections.emptyMap();
        try {
            for (SeRasterAttr rAtt : rasterAttributes) {
                LOGGER.fine("Gathering raster metadata for " + this.rasterTableName + " raster " + rAtt.getRasterId().longValue());
                if (rAtt.getMaxLevel() == 0) {
                    throw new IllegalArgumentException("Raster cotains no pyramid levels, we don't support non pyramid rasters");
                }
                if (rAtt.getNumBands() == 0) {
                    throw new IllegalArgumentException("Raster " + rAtt.getRasterId().longValue() + " in " + this.rasterTableName + " contains no raster attribtues");
                }
                if (this.statisticsMandatory && !rAtt.getBandInfo(1).hasStats()) {
                    throw new IllegalArgumentException(String.valueOf(this.rasterTableName) + " has no statistics generated (or not all it's rasters have). " + "Please use sderaster -o stats to create them before use");
                }
                RasterInfo rasterInfo = new RasterInfo(rAtt, coverageCrs);
                rastersLayoutInfo.add(rasterInfo);
                GeneralEnvelope originalEnvelope = this.calculateOriginalEnvelope(rAtt, coverageCrs);
                rasterInfo.setOriginalEnvelope(originalEnvelope);
                List<RasterBandInfo> bands = this.setUpBandInfo(connection, rAtt, rastersColorMaps);
                rasterInfo.setBands(bands);
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("Gathered metadata for " + this.rasterTableName + "#" + rAtt.getRasterId().longValue() + ":\n" + rasterInfo.toString());
                }
                System.out.println(rasterInfo);
            }
        }
        catch (SeException e) {
            throw new ArcSdeException("Gathering raster dataset information", e);
        }
        RasterDatasetInfo rasterInfo = new RasterDatasetInfo();
        rasterInfo.setRasterTable(this.rasterTableName);
        rasterInfo.setRasterColumns(rasterColumns);
        rasterInfo.setPyramidInfo(rastersLayoutInfo);
        return rasterInfo;
    }

    private String[] getRasterColumns(SeConnection scon, String rasterTable) throws IOException, SeException {
        SeColumnDefinition[] cols;
        SeTable sTable = new SeTable(scon, rasterTable);
        try {
            cols = sTable.describe();
        }
        catch (SeException e) {
            throw new ArcSdeException("Exception fetching the list of columns for table " + rasterTable, e);
        }
        ArrayList<String> fetchColumns = new ArrayList<String>(cols.length / 2);
        int i = 0;
        while (i < cols.length) {
            if (cols[i].getType() == SeColumnDefinition.TYPE_RASTER) {
                fetchColumns.add(cols[i].getName());
            }
            ++i;
        }
        if (fetchColumns.size() == 0) {
            throw new DataSourceException("Couldn't find any TYPE_RASTER columns in ArcSDE table " + rasterTable);
        }
        String[] rasterColumns = fetchColumns.toArray(new String[fetchColumns.size()]);
        return rasterColumns;
    }

    private GeneralEnvelope calculateOriginalEnvelope(SeRasterAttr rasterAttributes, CoordinateReferenceSystem coverageCrs) throws IOException {
        SeExtent sdeExtent;
        try {
            sdeExtent = rasterAttributes.getExtent();
        }
        catch (SeException e) {
            throw new ArcSdeException("Exception getting the raster extent", e);
        }
        GeneralEnvelope originalEnvelope = new GeneralEnvelope(coverageCrs);
        originalEnvelope.setRange(0, sdeExtent.getMinX(), sdeExtent.getMaxX());
        originalEnvelope.setRange(1, sdeExtent.getMinY(), sdeExtent.getMaxY());
        return originalEnvelope;
    }

    private List<SeRasterAttr> getSeRasterAttr(SeConnection scon, String rasterTable, String[] rasterColumns) throws IOException {
        LOGGER.fine("Gathering raster attributes for " + rasterTable);
        LinkedList<SeRasterAttr> rasterAttList = new LinkedList<SeRasterAttr>();
        SeQuery query = null;
        try {
            try {
                query = new SeQuery(scon, rasterColumns, new SeSqlConstruct(rasterTable));
                query.prepareQuery();
                query.execute();
                SeRow row = query.fetch();
                while (row != null) {
                    SeRasterAttr rasterAttributes = row.getRaster(0);
                    rasterAttList.addFirst(rasterAttributes);
                    row = query.fetch();
                }
            }
            catch (SeException se) {
                throw new ArcSdeException("Error fetching raster attributes for " + rasterTable, se);
            }
        }
        finally {
            if (query != null) {
                try {
                    query.close();
                }
                catch (SeException e) {
                    throw new ArcSdeException(e);
                }
            }
        }
        LOGGER.fine("Found " + rasterAttList.size() + " raster attributes for " + rasterTable);
        return rasterAttList;
    }

    private Map<Long, IndexColorModel> loadColorMaps(long rasterColumnId, int bitsPerSample, SeConnection scon) throws IOException {
        LOGGER.fine("Reading colormap for raster column " + rasterColumnId);
        String auxTableName = this.getAuxTableName(rasterColumnId, scon);
        LOGGER.fine("Quering auxiliary table " + auxTableName + " for color map data");
        HashMap<Long, IndexColorModel> colorMaps = new HashMap<Long, IndexColorModel>();
        SeQuery query = null;
        try {
            try {
                SeSqlConstruct sqlConstruct = new SeSqlConstruct();
                sqlConstruct.setTables(new String[]{auxTableName});
                String whereClause = "TYPE = 3";
                sqlConstruct.setWhere(whereClause);
                query = new SeQuery(scon, new String[]{"RASTERBAND_ID", "OBJECT"}, sqlConstruct);
                query.prepareQuery();
                query.execute();
                SeRow row = query.fetch();
                while (row != null) {
                    long bandId = ((Number)row.getObject(0)).longValue();
                    ByteArrayInputStream colorMapIS = row.getBlob(1);
                    DataBuffer colorMapData = this.readColorMap(colorMapIS);
                    IndexColorModel colorModel = RasterUtils.sdeColorMapToJavaColorModel(colorMapData, bitsPerSample);
                    colorMaps.put(bandId, colorModel);
                    row = query.fetch();
                }
            }
            catch (SeException e) {
                throw new ArcSdeException("Error fetching colormap data for column " + rasterColumnId + " from table " + auxTableName, e);
            }
        }
        finally {
            if (query != null) {
                try {
                    query.close();
                }
                catch (SeException e) {
                    LOGGER.log(Level.INFO, "ignoring exception when closing query to fetch colormap data", e);
                }
            }
        }
        LOGGER.fine("Read color map data for " + colorMaps.size() + " rasters");
        return colorMaps;
    }

    private DataBuffer readColorMap(ByteArrayInputStream colorMapIS) throws IOException {
        DataBuffer buff;
        int numBanks;
        DataInputStream dataIn = new DataInputStream(colorMapIS);
        dataIn.readInt();
        int colorSpaceType = dataIn.readInt();
        if (colorSpaceType == SeRaster.SE_COLORMAP_RGB) {
            numBanks = 3;
        } else if (colorSpaceType == SeRaster.SE_COLORMAP_RGBA) {
            numBanks = 4;
        } else {
            throw new IllegalStateException("Got unknown colormap type: " + colorSpaceType);
        }
        LOGGER.finest("Colormap has " + numBanks + " color components");
        int buffType = dataIn.readInt();
        int numElems = dataIn.readInt();
        LOGGER.finest("ColorMap length: " + numElems);
        if (buffType == SeRaster.SE_COLORMAP_DATA_BYTE) {
            LOGGER.finest("Creating Byte data buffer for " + numBanks + " banks and " + numElems + " elements per bank");
            buff = new DataBufferByte(numElems, numBanks);
            int elem = 0;
            while (elem < numElems) {
                int bank = 0;
                while (bank < numBanks) {
                    int val = dataIn.readUnsignedByte();
                    buff.setElem(bank, elem, val);
                    ++bank;
                }
                ++elem;
            }
        } else if (buffType == SeRaster.SE_COLORMAP_DATA_SHORT) {
            LOGGER.finest("Creating Short data buffer for " + numBanks + " banks and " + numElems + " elements per bank");
            buff = new DataBufferUShort(numElems, numBanks);
            int elem = 0;
            while (elem < numElems) {
                int bank = 0;
                while (bank < numBanks) {
                    int val = dataIn.readUnsignedShort();
                    buff.setElem(bank, elem, val);
                    ++bank;
                }
                ++elem;
            }
        } else {
            throw new IllegalStateException("Unknown databuffer type from colormap header: " + buffType + " expected one of TYPE_BYTE, TYPE_SHORT");
        }
        assert (dataIn.read() == -1) : "color map data should have been exausted";
        return buff;
    }

    private String getAuxTableName(long rasterColumnId, SeConnection scon) throws IOException {
        String owner;
        SeQuery query = null;
        try {
            try {
                String dbaName = scon.getSdeDbaName();
                String rastersColumnsTable = String.valueOf(dbaName) + ".SDE_RASTER_COLUMNS";
                SeSqlConstruct sqlCons = new SeSqlConstruct(rastersColumnsTable);
                sqlCons.setWhere("RASTERCOLUMN_ID = " + rasterColumnId);
                try {
                    query = new SeQuery(scon, new String[]{"OWNER"}, sqlCons);
                    query.prepareQuery();
                }
                catch (SeException e) {
                    rastersColumnsTable = String.valueOf(dbaName) + ".RASTER_COLUMNS";
                    sqlCons = new SeSqlConstruct(rastersColumnsTable);
                    sqlCons.setWhere("RASTERCOLUMN_ID = " + rasterColumnId);
                    query = new SeQuery(scon, new String[]{"OWNER"}, sqlCons);
                    query.prepareQuery();
                }
                query.execute();
                SeRow row = query.fetch();
                if (row == null) {
                    throw new IllegalArgumentException("No raster column registered with id " + rasterColumnId);
                }
                owner = row.getString(0);
                query.close();
            }
            catch (SeException e) {
                throw new ArcSdeException("Error getting auxiliary table for raster column " + rasterColumnId, e);
            }
        }
        finally {
            if (query != null) {
                try {
                    query.close();
                }
                catch (SeException e) {
                    LOGGER.log(Level.INFO, "ignoring exception when closing query to fetch colormap data", e);
                }
            }
        }
        String auxTableName = String.valueOf(owner) + ".SDE_AUX_" + rasterColumnId;
        return auxTableName;
    }

    private List<RasterBandInfo> setUpBandInfo(SeConnection scon, SeRasterAttr rasterAttributes, Map<Long, IndexColorModel> rastersColorMaps) throws IOException {
        RasterCellType cellType;
        SeRasterBand[] seBands;
        int numBands;
        try {
            numBands = rasterAttributes.getNumBands();
            seBands = rasterAttributes.getBands();
            cellType = RasterCellType.valueOf(rasterAttributes.getPixelType());
        }
        catch (SeException e) {
            throw new ArcSdeException(e);
        }
        ArrayList<RasterBandInfo> detachedBandInfo = new ArrayList<RasterBandInfo>(numBands);
        int bandN = 0;
        while (bandN < numBands) {
            SeRasterBand band = seBands[bandN];
            RasterBandInfo bandInfo = new RasterBandInfo();
            int bitsPerSample = cellType.getBitsPerSample();
            this.setBandInfo(numBands, bandInfo, band, scon, bitsPerSample, rastersColorMaps);
            detachedBandInfo.add(bandInfo);
            ++bandN;
        }
        return detachedBandInfo;
    }

    private void setBandInfo(int numBands, RasterBandInfo bandInfo, SeRasterBand band, SeConnection scon, int bitsPerSample, Map<Long, IndexColorModel> colorMaps) throws IOException {
        SDEPoint tOrigin;
        bandInfo.bandId = band.getId().longValue();
        bandInfo.bandNumber = band.getBandNumber();
        bandInfo.bandName = "Band " + bandInfo.bandNumber;
        boolean hasColorMap = band.hasColorMap();
        if (hasColorMap) {
            IndexColorModel colorMap = colorMaps.get(bandInfo.bandId);
            LOGGER.finest("Setting band's color map: " + colorMap);
            bandInfo.nativeColorMap = colorMap;
            bandInfo.colorMap = RasterUtils.ensureNoDataPixelIsAvailable(colorMap);
        } else {
            bandInfo.nativeColorMap = null;
        }
        bandInfo.compressionType = CompressionType.valueOf(band.getCompressionType());
        bandInfo.cellType = RasterCellType.valueOf(band.getPixelType());
        bandInfo.interleaveType = InterleaveType.valueOf(band.getInterleave());
        bandInfo.interpolationType = InterpolationType.valueOf(band.getInterpolation());
        bandInfo.hasStats = band.hasStats();
        if (bandInfo.hasStats) {
            try {
                bandInfo.statsMin = band.getStatsMin();
                bandInfo.statsMax = band.getStatsMax();
                bandInfo.statsMean = band.getStatsMean();
                bandInfo.statsStdDev = band.getStatsStdDev();
            }
            catch (SeException e) {
                throw new ArcSdeException(e);
            }
        } else {
            bandInfo.statsMin = Double.NaN;
            bandInfo.statsMax = Double.NaN;
            bandInfo.statsMean = Double.NaN;
            bandInfo.statsStdDev = Double.NaN;
        }
        if (bandInfo.getColorMap() != null) {
            bandInfo.noDataValue = RasterUtils.determineNoDataValue(bandInfo.getColorMap());
        } else {
            double statsMin = bandInfo.getStatsMin();
            double statsMax = bandInfo.getStatsMax();
            RasterCellType nativeCellType = bandInfo.getCellType();
            bandInfo.noDataValue = RasterUtils.determineNoDataValue(numBands, statsMin, statsMax, nativeCellType);
        }
        try {
            tOrigin = band.getTileOrigin();
        }
        catch (SeException e) {
            throw new ArcSdeException(e);
        }
        bandInfo.tileOrigin = new Point((int)tOrigin.getX(), (int)tOrigin.getY());
    }
}

